/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   nets.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/nets.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/cont_assign.h>
#include <uhdm/module_inst.h>
#include <uhdm/net_drivers.h>
#include <uhdm/net_loads.h>
#include <uhdm/nets.h>
#include <uhdm/path_term.h>
#include <uhdm/ports.h>
#include <uhdm/prim_term.h>
#include <uhdm/tchk_term.h>


namespace UHDM {
std::string_view nets::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool nets::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view nets::VpiFullName() const {
  if (!vpiFullName_) {
    const std::string fullName = ComputeFullName();
    if (!fullName.empty()) {
      const_cast<nets*>(this)->VpiFullName(fullName);
    }
  }
  return serializer_->GetSymbol(vpiFullName_);
}

bool nets::VpiFullName(std::string_view data) {
  vpiFullName_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* nets::GetByVpiName(std::string_view name) const {
  if (ports_ != nullptr) {
    for (const BaseClass *ref : *ports_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (drivers_ != nullptr) {
    for (const BaseClass *ref : *drivers_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (loads_ != nullptr) {
    for (const BaseClass *ref : *loads_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (local_drivers_ != nullptr) {
    for (const BaseClass *ref : *local_drivers_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (local_loads_ != nullptr) {
    for (const BaseClass *ref : *local_loads_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (prim_terms_ != nullptr) {
    for (const BaseClass *ref : *prim_terms_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (cont_assigns_ != nullptr) {
    for (const BaseClass *ref : *cont_assigns_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (path_terms_ != nullptr) {
    for (const BaseClass *ref : *path_terms_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (tchk_terms_ != nullptr) {
    for (const BaseClass *ref : *tchk_terms_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((sim_net_ != nullptr) && (sim_net_->VpiName().compare(name) == 0)) {
    return sim_net_;
  }
  if ((module_inst_ != nullptr) && (module_inst_->VpiName().compare(name) == 0)) {
    return module_inst_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> nets::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiContAssign: return std::make_tuple(nullptr, uhdmcont_assigns, (const std::vector<const BaseClass*>*)cont_assigns_);
    case vpiDriver: return std::make_tuple(nullptr, uhdmdrivers, (const std::vector<const BaseClass*>*)drivers_);
    case vpiLoad: return std::make_tuple(nullptr, uhdmloads, (const std::vector<const BaseClass*>*)loads_);
    case vpiLocalDriver: return std::make_tuple(nullptr, uhdmlocal_drivers, (const std::vector<const BaseClass*>*)local_drivers_);
    case vpiLocalLoad: return std::make_tuple(nullptr, uhdmlocal_loads, (const std::vector<const BaseClass*>*)local_loads_);
    case vpiModule: return std::make_tuple(module_inst_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiPathTerm: return std::make_tuple(nullptr, uhdmpath_terms, (const std::vector<const BaseClass*>*)path_terms_);
    case vpiPortInst: return std::make_tuple(nullptr, uhdmports, (const std::vector<const BaseClass*>*)ports_);
    case vpiPrimTerm: return std::make_tuple(nullptr, uhdmprim_terms, (const std::vector<const BaseClass*>*)prim_terms_);
    case vpiSimNet: return std::make_tuple(sim_net_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiTchkTerm: return std::make_tuple(nullptr, uhdmtchk_terms, (const std::vector<const BaseClass*>*)tchk_terms_);
  }
  return basetype_t::GetByVpiType(type);
}

nets::vpi_property_value_t nets::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiArrayMember: return vpi_property_value_t(VpiArrayMember());
    case vpiChargeStrength: return vpi_property_value_t(VpiChargeStrength());
    case vpiConstantSelect: return vpi_property_value_t(VpiConstantSelect());
    case vpiExpanded: return vpi_property_value_t(VpiExpanded());
    case vpiExplicitScalared: return vpi_property_value_t(VpiExplicitScalared());
    case vpiExplicitVectored: return vpi_property_value_t(VpiExplicitVectored());
    case vpiFullName: {
      std::string_view fullname = VpiFullName();
      if (!fullname.empty() && (VpiName() != fullname)) {
        return vpi_property_value_t(fullname.data());
      }
    } break;
    case vpiImplicitDecl: return vpi_property_value_t(VpiImplicitDecl());
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiNetDeclAssign: return vpi_property_value_t(VpiNetDeclAssign());
    case vpiNetType: return vpi_property_value_t(VpiNetType());
    case vpiResolvedNetType: return vpi_property_value_t(VpiResolvedNetType());
    case vpiScalar: return vpi_property_value_t(VpiScalar());
    case vpiSigned: return vpi_property_value_t(VpiSigned());
    case vpiStrength0: return vpi_property_value_t(VpiStrength0());
    case vpiStrength1: return vpi_property_value_t(VpiStrength1());
    case vpiStructUnionMember: return vpi_property_value_t(VpiStructUnionMember());
    case vpiVector: return vpi_property_value_t(VpiVector());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void nets::DeepCopy(nets* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Ports()) {
    auto clone_vec = context->m_serializer->MakePortsVec();
    clone->Ports(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Drivers()) {
    auto clone_vec = context->m_serializer->MakeNet_driversVec();
    clone->Drivers(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Loads()) {
    auto clone_vec = context->m_serializer->MakeNet_loadsVec();
    clone->Loads(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Local_drivers()) {
    auto clone_vec = context->m_serializer->MakeNet_driversVec();
    clone->Local_drivers(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Local_loads()) {
    auto clone_vec = context->m_serializer->MakeNet_loadsVec();
    clone->Local_loads(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Prim_terms()) {
    auto clone_vec = context->m_serializer->MakePrim_termVec();
    clone->Prim_terms(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Cont_assigns()) {
    auto clone_vec = context->m_serializer->MakeCont_assignVec();
    clone->Cont_assigns(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Path_terms()) {
    auto clone_vec = context->m_serializer->MakePath_termVec();
    clone->Path_terms(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Tchk_terms()) {
    auto clone_vec = context->m_serializer->MakeTchk_termVec();
    clone->Tchk_terms(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Sim_net()) clone->Sim_net(obj->DeepClone(clone, context));
  if (auto obj = Module_inst()) clone->Module_inst((module_inst*) obj);
}

int32_t nets::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = (lhs->VpiArrayMember() == rhs->VpiArrayMember()) ? 0 : (lhs->VpiArrayMember() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiConstantSelect() == rhs->VpiConstantSelect()) ? 0 : (lhs->VpiConstantSelect() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiExpanded() == rhs->VpiExpanded()) ? 0 : (lhs->VpiExpanded() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiImplicitDecl() == rhs->VpiImplicitDecl()) ? 0 : (lhs->VpiImplicitDecl() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiNetDeclAssign() == rhs->VpiNetDeclAssign()) ? 0 : (lhs->VpiNetDeclAssign() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiNetType() - rhs->VpiNetType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiResolvedNetType() - rhs->VpiResolvedNetType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiScalar() == rhs->VpiScalar()) ? 0 : (lhs->VpiScalar() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiExplicitScalared() == rhs->VpiExplicitScalared()) ? 0 : (lhs->VpiExplicitScalared() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiSigned() == rhs->VpiSigned()) ? 0 : (lhs->VpiSigned() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiStrength0() - rhs->VpiStrength0()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiStrength1() - rhs->VpiStrength1()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiChargeStrength() - rhs->VpiChargeStrength()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiVector() == rhs->VpiVector()) ? 0 : (lhs->VpiVector() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiExplicitVectored() == rhs->VpiExplicitVectored()) ? 0 : (lhs->VpiExplicitVectored() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiStructUnionMember() == rhs->VpiStructUnionMember()) ? 0 : (lhs->VpiStructUnionMember() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Ports(), rhs, rhs->Ports(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Drivers(), rhs, rhs->Drivers(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Loads(), rhs, rhs->Loads(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Local_drivers(), rhs, rhs->Local_drivers(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Local_loads(), rhs, rhs->Local_loads(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Prim_terms(), rhs, rhs->Prim_terms(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Cont_assigns(), rhs, rhs->Cont_assigns(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Path_terms(), rhs, rhs->Path_terms(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Tchk_terms(), rhs, rhs->Tchk_terms(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Sim_net(), rhs->Sim_net(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Module_inst(), rhs->Module_inst(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
