/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   nets_vars_ref_obj_group.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */
#include <uhdm/nets_vars_ref_obj_group.h>

#include <iostream>
#include <uhdm/uhdm.h>

namespace UHDM {
bool nets_vars_ref_obj_groupGroupCompliant(const any* item) {
  if (item == nullptr) {
    return true;
  }
  UHDM_OBJECT_TYPE uhdmtype = item->UhdmType();
  if ((uhdmtype != uhdmarray_net) &&
      (uhdmtype != uhdmarray_var) &&
      (uhdmtype != uhdmbit_var) &&
      (uhdmtype != uhdmbyte_var) &&
      (uhdmtype != uhdmchandle_var) &&
      (uhdmtype != uhdmclass_var) &&
      (uhdmtype != uhdmenum_net) &&
      (uhdmtype != uhdmenum_var) &&
      (uhdmtype != uhdmhier_path) &&
      (uhdmtype != uhdmint_var) &&
      (uhdmtype != uhdminteger_net) &&
      (uhdmtype != uhdminteger_var) &&
      (uhdmtype != uhdmlogic_net) &&
      (uhdmtype != uhdmlogic_var) &&
      (uhdmtype != uhdmlong_int_var) &&
      (uhdmtype != uhdmnet) &&
      (uhdmtype != uhdmnet_bit) &&
      (uhdmtype != uhdmnets) &&
      (uhdmtype != uhdmoperation) &&
      (uhdmtype != uhdmpacked_array_net) &&
      (uhdmtype != uhdmpacked_array_var) &&
      (uhdmtype != uhdmreal_var) &&
      (uhdmtype != uhdmref_obj) &&
      (uhdmtype != uhdmref_var) &&
      (uhdmtype != uhdmshort_int_var) &&
      (uhdmtype != uhdmshort_real_var) &&
      (uhdmtype != uhdmstring_var) &&
      (uhdmtype != uhdmstruct_net) &&
      (uhdmtype != uhdmstruct_var) &&
      (uhdmtype != uhdmtime_net) &&
      (uhdmtype != uhdmtime_var) &&
      (uhdmtype != uhdmunion_var) &&
      (uhdmtype != uhdmvar_bit) &&
      (uhdmtype != uhdmvariables)) {
    item->GetSerializer()->GetErrorHandler()(ErrorType::UHDM_WRONG_OBJECT_TYPE, "Internal Error: adding wrong object type (" + UhdmName(uhdmtype) + ") in a nets_vars_ref_obj_group group!", item, nullptr);
    return false;
  }
  return true;
}

bool nets_vars_ref_obj_groupGroupCompliant(const VectorOfany* vec) {
  if (vec != nullptr) {
    for (auto item : *vec) {
      if (!nets_vars_ref_obj_groupGroupCompliant(item)) {
        return false;
      }
    }
  }
  return true;
}

}  // namespace UHDM
