/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   operation.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/operation.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/attribute.h>
#include <uhdm/operand_group.h>


namespace UHDM {
const BaseClass* operation::GetByVpiName(std::string_view name) const {
  if (operands_ != nullptr) {
    for (const BaseClass *ref : *operands_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (attributes_ != nullptr) {
    for (const BaseClass *ref : *attributes_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> operation::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiAttribute: return std::make_tuple(nullptr, uhdmattributes, (const std::vector<const BaseClass*>*)attributes_);
    case vpiOperand: return std::make_tuple(nullptr, uhdmoperands, (const std::vector<const BaseClass*>*)operands_);
  }
  return basetype_t::GetByVpiType(type);
}

operation::vpi_property_value_t operation::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiFlattened: return vpi_property_value_t(VpiFlattened());
    case vpiOpStrong: return vpi_property_value_t(VpiOpStrong());
    case vpiOpType: return vpi_property_value_t(VpiOpType());
    case vpiReordered: return vpi_property_value_t(VpiReordered());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void operation::DeepCopy(operation* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterOperation(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Operands()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->Operands(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Attributes()) {
    auto clone_vec = context->m_serializer->MakeAttributeVec();
    clone->Attributes(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveOperation(clone, nullptr);
}

operation* operation::DeepClone(BaseClass* parent, CloneContext* context) const {
  operation* const clone = context->m_serializer->MakeOperation();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t operation::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiOpType() - rhs->VpiOpType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiReordered() == rhs->VpiReordered()) ? 0 : (lhs->VpiReordered() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiFlattened() == rhs->VpiFlattened()) ? 0 : (lhs->VpiFlattened() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiOpStrong() == rhs->VpiOpStrong()) ? 0 : (lhs->VpiOpStrong() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Operands(), rhs, rhs->Operands(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Attributes(), rhs, rhs->Attributes(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
