/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   ordered_wait.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/ordered_wait.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr_sequence_inst_group.h>
#include <uhdm/stmt.h>


namespace UHDM {
const BaseClass* ordered_wait::GetByVpiName(std::string_view name) const {
  if (vpiConditions_ != nullptr) {
    for (const BaseClass *ref : *vpiConditions_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((vpiElseStmt_ != nullptr) && (vpiElseStmt_->VpiName().compare(name) == 0)) {
    return vpiElseStmt_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> ordered_wait::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiCondition: return std::make_tuple(nullptr, uhdmvpiConditions, (const std::vector<const BaseClass*>*)vpiConditions_);
    case vpiElseStmt: return std::make_tuple(vpiElseStmt_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

ordered_wait::vpi_property_value_t ordered_wait::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void ordered_wait::DeepCopy(ordered_wait* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterOrdered_wait(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = VpiConditions()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->VpiConditions(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = VpiElseStmt()) clone->VpiElseStmt(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveOrdered_wait(clone, nullptr);
}

ordered_wait* ordered_wait::DeepClone(BaseClass* parent, CloneContext* context) const {
  ordered_wait* const clone = context->m_serializer->MakeOrdered_wait();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t ordered_wait::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs, lhs->VpiConditions(), rhs, rhs->VpiConditions(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->VpiElseStmt(), rhs->VpiElseStmt(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
