/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   package.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/package.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>


namespace UHDM {
std::string_view package::VpiEndLabel() const {
  return vpiEndLabel_ ? serializer_->GetSymbol(vpiEndLabel_) : kEmpty;
}

bool package::VpiEndLabel(std::string_view data) {
  vpiEndLabel_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* package::GetByVpiName(std::string_view name) const {
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> package::GetByVpiType(int32_t type) const {
  switch (type) {
  }
  return basetype_t::GetByVpiType(type);
}

package::vpi_property_value_t package::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiEndLabel: {
      std::string_view data = VpiEndLabel();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiType: return vpi_property_value_t(VpiType());
    case vpiUnit: return vpi_property_value_t(VpiUnit());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void package::DeepCopy(package* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterPackage(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  elaboratorContext->m_elaborator.leavePackage(clone, nullptr);
}

package* package::DeepClone(BaseClass* parent, CloneContext* context) const {
  package* const clone = context->m_serializer->MakePackage();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t package::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiType() - rhs->VpiType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiUnit() == rhs->VpiUnit()) ? 0 : (lhs->VpiUnit() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiEndLabel().compare(rhs->VpiEndLabel())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  return r;
}

}  // namespace UHDM
