/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   packed_array_var.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/packed_array_var.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/enum_struct_union_packed_var_group.h>
#include <uhdm/expr.h>
#include <uhdm/range.h>
#include <uhdm/var_bit.h>


namespace UHDM {
const BaseClass* packed_array_var::GetByVpiName(std::string_view name) const {
  if (ranges_ != nullptr) {
    for (const BaseClass *ref : *ranges_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((left_expr_ != nullptr) && (left_expr_->VpiName().compare(name) == 0)) {
    return left_expr_;
  }
  if ((right_expr_ != nullptr) && (right_expr_->VpiName().compare(name) == 0)) {
    return right_expr_;
  }
  if (var_bits_ != nullptr) {
    for (const BaseClass *ref : *var_bits_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (elements_ != nullptr) {
    for (const BaseClass *ref : *elements_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((expr_index_ != nullptr) && (expr_index_->VpiName().compare(name) == 0)) {
    return expr_index_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> packed_array_var::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiBit: return std::make_tuple(nullptr, uhdmvar_bits, (const std::vector<const BaseClass*>*)var_bits_);
    case vpiElement: return std::make_tuple(nullptr, uhdmelements, (const std::vector<const BaseClass*>*)elements_);
    case vpiIndex: return std::make_tuple(expr_index_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiLeftRange: return std::make_tuple(left_expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiRange: return std::make_tuple(nullptr, uhdmranges, (const std::vector<const BaseClass*>*)ranges_);
    case vpiRightRange: return std::make_tuple(right_expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

packed_array_var::vpi_property_value_t packed_array_var::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiConstantSelect: return vpi_property_value_t(VpiConstantSelect());
    case vpiPacked: return vpi_property_value_t(VpiPacked());
    case vpiPackedArrayMember: return vpi_property_value_t(VpiPackedArrayMember());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void packed_array_var::DeepCopy(packed_array_var* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterPacked_array_var(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Ranges()) {
    auto clone_vec = context->m_serializer->MakeRangeVec();
    clone->Ranges(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Left_expr()) clone->Left_expr(obj->DeepClone(clone, context));
  if (auto obj = Right_expr()) clone->Right_expr(obj->DeepClone(clone, context));
  if (auto vec = Var_bits()) {
    auto clone_vec = context->m_serializer->MakeVar_bitVec();
    clone->Var_bits(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Elements()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->Elements(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Expr_index()) clone->Expr_index(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leavePacked_array_var(clone, nullptr);
}

packed_array_var* packed_array_var::DeepClone(BaseClass* parent, CloneContext* context) const {
  packed_array_var* const clone = context->m_serializer->MakePacked_array_var();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t packed_array_var::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = (lhs->VpiPackedArrayMember() == rhs->VpiPackedArrayMember()) ? 0 : (lhs->VpiPackedArrayMember() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiConstantSelect() == rhs->VpiConstantSelect()) ? 0 : (lhs->VpiConstantSelect() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiPacked() == rhs->VpiPacked()) ? 0 : (lhs->VpiPacked() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Ranges(), rhs, rhs->Ranges(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Left_expr(), rhs->Left_expr(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Right_expr(), rhs->Right_expr(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Var_bits(), rhs, rhs->Var_bits(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Elements(), rhs, rhs->Elements(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Expr_index(), rhs->Expr_index(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
