/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   parameter.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/parameter.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>
#include <uhdm/range.h>


namespace UHDM {
std::string_view parameter::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool parameter::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view parameter::VpiFullName() const {
  if (!vpiFullName_) {
    const std::string fullName = ComputeFullName();
    if (!fullName.empty()) {
      const_cast<parameter*>(this)->VpiFullName(fullName);
    }
  }
  return serializer_->GetSymbol(vpiFullName_);
}

bool parameter::VpiFullName(std::string_view data) {
  vpiFullName_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view parameter::VpiImported() const {
  return vpiImported_ ? serializer_->GetSymbol(vpiImported_) : kEmpty;
}

bool parameter::VpiImported(std::string_view data) {
  vpiImported_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* parameter::GetByVpiName(std::string_view name) const {
  if ((expr_ != nullptr) && (expr_->VpiName().compare(name) == 0)) {
    return expr_;
  }
  if (ranges_ != nullptr) {
    for (const BaseClass *ref : *ranges_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((left_range_ != nullptr) && (left_range_->VpiName().compare(name) == 0)) {
    return left_range_;
  }
  if ((right_range_ != nullptr) && (right_range_->VpiName().compare(name) == 0)) {
    return right_range_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> parameter::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiExpr: return std::make_tuple(expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiLeftRange: return std::make_tuple(left_range_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiRange: return std::make_tuple(nullptr, uhdmranges, (const std::vector<const BaseClass*>*)ranges_);
    case vpiRightRange: return std::make_tuple(right_range_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

parameter::vpi_property_value_t parameter::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiConstType: return vpi_property_value_t(VpiConstType());
    case vpiFullName: {
      std::string_view fullname = VpiFullName();
      if (!fullname.empty() && (VpiName() != fullname)) {
        return vpi_property_value_t(fullname.data());
      }
    } break;
    case vpiImported: {
      std::string_view data = VpiImported();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiLocalParam: return vpi_property_value_t(VpiLocalParam());
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiSigned: return vpi_property_value_t(VpiSigned());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void parameter::DeepCopy(parameter* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterParameter(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Expr()) clone->Expr(obj->DeepClone(clone, context));
  if (auto vec = Ranges()) {
    auto clone_vec = context->m_serializer->MakeRangeVec();
    clone->Ranges(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Left_range()) clone->Left_range(obj->DeepClone(clone, context));
  if (auto obj = Right_range()) clone->Right_range(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveParameter(clone, nullptr);
}

parameter* parameter::DeepClone(BaseClass* parent, CloneContext* context) const {
  ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  parameter* clone = any_cast<parameter*>(elaboratorContext->m_elaborator.bindParam(VpiName()));
  if (clone == nullptr) {
    clone = context->m_serializer->MakeParameter();
  }
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t parameter::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiConstType() - rhs->VpiConstType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiSigned() == rhs->VpiSigned()) ? 0 : (lhs->VpiSigned() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Expr(), rhs->Expr(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Ranges(), rhs, rhs->Ranges(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Left_range(), rhs->Left_range(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Right_range(), rhs->Right_range(), context)) != 0) return r;
  if ((r = (lhs->VpiLocalParam() == rhs->VpiLocalParam()) ? 0 : (lhs->VpiLocalParam() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiImported().compare(rhs->VpiImported())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  return r;
}

}  // namespace UHDM
