/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   ports.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/ports.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr_ref_obj_group.h>
#include <uhdm/instance.h>
#include <uhdm/module_inst.h>
#include <uhdm/ref_typespec.h>


namespace UHDM {
std::string_view ports::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool ports::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view ports::VpiExplicitName() const {
  return vpiExplicitName_ ? serializer_->GetSymbol(vpiExplicitName_) : kEmpty;
}

bool ports::VpiExplicitName(std::string_view data) {
  vpiExplicitName_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* ports::GetByVpiName(std::string_view name) const {
  if ((high_conn_ != nullptr) && (high_conn_->VpiName().compare(name) == 0)) {
    return high_conn_;
  }
  if ((low_conn_ != nullptr) && (low_conn_->VpiName().compare(name) == 0)) {
    return low_conn_;
  }
  if ((typespec_ != nullptr) && (typespec_->VpiName().compare(name) == 0)) {
    return typespec_;
  }
  if ((instance_ != nullptr) && (instance_->VpiName().compare(name) == 0)) {
    return instance_;
  }
  if ((module_inst_ != nullptr) && (module_inst_->VpiName().compare(name) == 0)) {
    return module_inst_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> ports::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiHighConn: return std::make_tuple(high_conn_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiInstance: return std::make_tuple(instance_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiLowConn: return std::make_tuple(low_conn_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiModule: return std::make_tuple(module_inst_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiTypedef: return std::make_tuple(typespec_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

ports::vpi_property_value_t ports::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiConnByName: return vpi_property_value_t(VpiConnByName());
    case vpiDirection: return vpi_property_value_t(VpiDirection());
    case vpiExplicitName: {
      std::string_view data = VpiExplicitName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiPortIndex: return vpi_property_value_t(VpiPortIndex());
    case vpiPortType: return vpi_property_value_t(VpiPortType());
    case vpiScalar: return vpi_property_value_t(VpiScalar());
    case vpiSize: return vpi_property_value_t(VpiSize());
    case vpiVector: return vpi_property_value_t(VpiVector());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void ports::DeepCopy(ports* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = High_conn()) {
    elaboratorContext->m_elaborator.ignoreLastInstance(true); 
    clone->High_conn(obj->DeepClone(clone, context));
    elaboratorContext->m_elaborator.ignoreLastInstance(false);
  }
  if (auto obj = Low_conn()) clone->Low_conn(obj->DeepClone(clone, context));
  if (auto obj = Typespec()) clone->Typespec(obj->DeepClone(clone, context));
  if (auto obj = Instance()) clone->Instance((instance*) obj);
  if (instance* inst = any_cast<instance*>(parent))
    clone->Instance(inst);
  if (auto obj = Module_inst()) clone->Module_inst((module_inst*) obj);
}

int32_t ports::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiPortIndex() - rhs->VpiPortIndex()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiPortType() - rhs->VpiPortType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiScalar() == rhs->VpiScalar()) ? 0 : (lhs->VpiScalar() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiVector() == rhs->VpiVector()) ? 0 : (lhs->VpiVector() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiConnByName() == rhs->VpiConnByName()) ? 0 : (lhs->VpiConnByName() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiDirection() - rhs->VpiDirection()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiSize() - rhs->VpiSize()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiExplicitName().compare(rhs->VpiExplicitName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->High_conn(), rhs->High_conn(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Low_conn(), rhs->Low_conn(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Typespec(), rhs->Typespec(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Instance(), rhs->Instance(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Module_inst(), rhs->Module_inst(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
