/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   primitive.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/primitive.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/attribute.h>
#include <uhdm/expr.h>
#include <uhdm/prim_term.h>


namespace UHDM {
std::string_view primitive::VpiDefName() const {
  return vpiDefName_ ? serializer_->GetSymbol(vpiDefName_) : kEmpty;
}

bool primitive::VpiDefName(std::string_view data) {
  vpiDefName_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view primitive::VpiDelay() const {
  return vpiDelay_ ? serializer_->GetSymbol(vpiDelay_) : kEmpty;
}

bool primitive::VpiDelay(std::string_view data) {
  vpiDelay_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view primitive::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool primitive::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view primitive::VpiFullName() const {
  if (!vpiFullName_) {
    const std::string fullName = ComputeFullName();
    if (!fullName.empty()) {
      const_cast<primitive*>(this)->VpiFullName(fullName);
    }
  }
  return serializer_->GetSymbol(vpiFullName_);
}

bool primitive::VpiFullName(std::string_view data) {
  vpiFullName_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view primitive::VpiValue() const {
  return vpiValue_ ? serializer_->GetSymbol(vpiValue_) : kEmpty;
}

bool primitive::VpiValue(std::string_view data) {
  vpiValue_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* primitive::GetByVpiName(std::string_view name) const {
  if (attributes_ != nullptr) {
    for (const BaseClass *ref : *attributes_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((delay_ != nullptr) && (delay_->VpiName().compare(name) == 0)) {
    return delay_;
  }
  if ((index_ != nullptr) && (index_->VpiName().compare(name) == 0)) {
    return index_;
  }
  if (prim_terms_ != nullptr) {
    for (const BaseClass *ref : *prim_terms_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> primitive::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiAttribute: return std::make_tuple(nullptr, uhdmattributes, (const std::vector<const BaseClass*>*)attributes_);
    case vpiDelay: return std::make_tuple(delay_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiIndex: return std::make_tuple(index_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiPrimTerm: return std::make_tuple(nullptr, uhdmprim_terms, (const std::vector<const BaseClass*>*)prim_terms_);
  }
  return basetype_t::GetByVpiType(type);
}

primitive::vpi_property_value_t primitive::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiArrayMember: return vpi_property_value_t(VpiArrayMember());
    case vpiDefName: {
      std::string_view data = VpiDefName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiFullName: {
      std::string_view fullname = VpiFullName();
      if (!fullname.empty() && (VpiName() != fullname)) {
        return vpi_property_value_t(fullname.data());
      }
    } break;
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiPrimType: return vpi_property_value_t(VpiPrimType());
    case vpiStrength0: return vpi_property_value_t(VpiStrength0());
    case vpiStrength1: return vpi_property_value_t(VpiStrength1());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void primitive::DeepCopy(primitive* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Attributes()) {
    auto clone_vec = context->m_serializer->MakeAttributeVec();
    clone->Attributes(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Delay()) clone->Delay(obj->DeepClone(clone, context));
  if (auto obj = Index()) clone->Index(obj->DeepClone(clone, context));
  if (auto vec = Prim_terms()) {
    auto clone_vec = context->m_serializer->MakePrim_termVec();
    clone->Prim_terms(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
}

int32_t primitive::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = (lhs->VpiArrayMember() == rhs->VpiArrayMember()) ? 0 : (lhs->VpiArrayMember() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiDefName().compare(rhs->VpiDefName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiPrimType() - rhs->VpiPrimType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiStrength0() - rhs->VpiStrength0()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiStrength1() - rhs->VpiStrength1()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Attributes(), rhs, rhs->Attributes(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Delay(), rhs->Delay(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Index(), rhs->Index(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Prim_terms(), rhs, rhs->Prim_terms(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
