/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   primitive_array.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/primitive_array.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>
#include <uhdm/primitive.h>


namespace UHDM {
const BaseClass* primitive_array::GetByVpiName(std::string_view name) const {
  if ((delay_ != nullptr) && (delay_->VpiName().compare(name) == 0)) {
    return delay_;
  }
  if (primitives_ != nullptr) {
    for (const BaseClass *ref : *primitives_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> primitive_array::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiDelay: return std::make_tuple(delay_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiPrimitive: return std::make_tuple(nullptr, uhdmprimitives, (const std::vector<const BaseClass*>*)primitives_);
  }
  return basetype_t::GetByVpiType(type);
}

primitive_array::vpi_property_value_t primitive_array::GetVpiPropertyValue(int32_t property) const {
  return basetype_t::GetVpiPropertyValue(property);
}

void primitive_array::DeepCopy(primitive_array* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Delay()) clone->Delay(obj->DeepClone(clone, context));
  if (auto vec = Primitives()) {
    auto clone_vec = context->m_serializer->MakePrimitiveVec();
    clone->Primitives(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
}

int32_t primitive_array::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->Delay(), rhs->Delay(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Primitives(), rhs, rhs->Primitives(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
