/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   process_stmt.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/process_stmt.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/attribute.h>
#include <uhdm/module_inst.h>
#include <uhdm/stmt.h>


namespace UHDM {
const BaseClass* process_stmt::GetByVpiName(std::string_view name) const {
  if ((stmt_ != nullptr) && (stmt_->VpiName().compare(name) == 0)) {
    return stmt_;
  }
  if ((module_inst_ != nullptr) && (module_inst_->VpiName().compare(name) == 0)) {
    return module_inst_;
  }
  if (attributes_ != nullptr) {
    for (const BaseClass *ref : *attributes_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> process_stmt::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiAttribute: return std::make_tuple(nullptr, uhdmattributes, (const std::vector<const BaseClass*>*)attributes_);
    case vpiModule: return std::make_tuple(module_inst_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiStmt: return std::make_tuple(stmt_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

process_stmt::vpi_property_value_t process_stmt::GetVpiPropertyValue(int32_t property) const {
  return basetype_t::GetVpiPropertyValue(property);
}

void process_stmt::DeepCopy(process_stmt* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Stmt()) clone->Stmt(obj->DeepClone(clone, context));
  if (auto obj = Module_inst()) clone->Module_inst((module_inst*) obj);
  if (auto vec = Attributes()) {
    auto clone_vec = context->m_serializer->MakeAttributeVec();
    clone->Attributes(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
}

int32_t process_stmt::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->Stmt(), rhs->Stmt(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Module_inst(), rhs->Module_inst(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Attributes(), rhs, rhs->Attributes(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
