/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   program.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/program.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/clocking_block.h>
#include <uhdm/cont_assign.h>
#include <uhdm/expr_dist.h>
#include <uhdm/gen_scope_array.h>
#include <uhdm/instance_array.h>
#include <uhdm/interface_array.h>
#include <uhdm/interface_inst.h>
#include <uhdm/port.h>
#include <uhdm/process_stmt.h>


namespace UHDM {
std::string_view program::VpiEndLabel() const {
  return vpiEndLabel_ ? serializer_->GetSymbol(vpiEndLabel_) : kEmpty;
}

bool program::VpiEndLabel(std::string_view data) {
  vpiEndLabel_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* program::GetByVpiName(std::string_view name) const {
  if ((default_clocking_ != nullptr) && (default_clocking_->VpiName().compare(name) == 0)) {
    return default_clocking_;
  }
  if ((instance_array_ != nullptr) && (instance_array_->VpiName().compare(name) == 0)) {
    return instance_array_;
  }
  if (interfaces_ != nullptr) {
    for (const BaseClass *ref : *interfaces_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((expr_dist_ != nullptr) && (expr_dist_->VpiName().compare(name) == 0)) {
    return expr_dist_;
  }
  if (interface_arrays_ != nullptr) {
    for (const BaseClass *ref : *interface_arrays_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (process_ != nullptr) {
    for (const BaseClass *ref : *process_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (cont_assigns_ != nullptr) {
    for (const BaseClass *ref : *cont_assigns_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (clocking_blocks_ != nullptr) {
    for (const BaseClass *ref : *clocking_blocks_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (ports_ != nullptr) {
    for (const BaseClass *ref : *ports_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (gen_scope_arrays_ != nullptr) {
    for (const BaseClass *ref : *gen_scope_arrays_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> program::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiClockingBlock: return std::make_tuple(nullptr, uhdmclocking_blocks, (const std::vector<const BaseClass*>*)clocking_blocks_);
    case vpiContAssign: return std::make_tuple(nullptr, uhdmcont_assigns, (const std::vector<const BaseClass*>*)cont_assigns_);
    case vpiDefaultClocking: return std::make_tuple(default_clocking_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiDefaultDisableIff: return std::make_tuple(expr_dist_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiGenScopeArray: return std::make_tuple(nullptr, uhdmgen_scope_arrays, (const std::vector<const BaseClass*>*)gen_scope_arrays_);
    case vpiInstanceArray: return std::make_tuple(instance_array_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiInterface: return std::make_tuple(nullptr, uhdminterfaces, (const std::vector<const BaseClass*>*)interfaces_);
    case vpiInterfaceArray: return std::make_tuple(nullptr, uhdminterface_arrays, (const std::vector<const BaseClass*>*)interface_arrays_);
    case vpiPort: return std::make_tuple(nullptr, uhdmports, (const std::vector<const BaseClass*>*)ports_);
    case vpiProcess: return std::make_tuple(nullptr, uhdmprocess, (const std::vector<const BaseClass*>*)process_);
  }
  return basetype_t::GetByVpiType(type);
}

program::vpi_property_value_t program::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiEndLabel: {
      std::string_view data = VpiEndLabel();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiIndex: return vpi_property_value_t(VpiIndex());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void program::DeepCopy(program* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterProgram(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Default_clocking()) clone->Default_clocking(obj->DeepClone(clone, context));
  if (auto obj = Instance_array()) clone->Instance_array(obj->DeepClone(clone, context));
  if (auto vec = Interfaces()) {
    auto clone_vec = context->m_serializer->MakeInterface_instVec();
    clone->Interfaces(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Expr_dist()) clone->Expr_dist(obj->DeepClone(clone, context));
  if (auto vec = Interface_arrays()) {
    auto clone_vec = context->m_serializer->MakeInterface_arrayVec();
    clone->Interface_arrays(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Process()) {
    auto clone_vec = context->m_serializer->MakeProcess_stmtVec();
    clone->Process(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Cont_assigns()) {
    auto clone_vec = context->m_serializer->MakeCont_assignVec();
    clone->Cont_assigns(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Clocking_blocks()) {
    auto clone_vec = context->m_serializer->MakeClocking_blockVec();
    clone->Clocking_blocks(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Ports()) {
    auto clone_vec = context->m_serializer->MakePortVec();
    clone->Ports(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Gen_scope_arrays()) {
    auto clone_vec = context->m_serializer->MakeGen_scope_arrayVec();
    clone->Gen_scope_arrays(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveProgram(clone, nullptr);
}

program* program::DeepClone(BaseClass* parent, CloneContext* context) const {
  program* const clone = context->m_serializer->MakeProgram();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t program::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiIndex() - rhs->VpiIndex()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiType() - rhs->VpiType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Default_clocking(), rhs->Default_clocking(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Instance_array(), rhs->Instance_array(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Interfaces(), rhs, rhs->Interfaces(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Expr_dist(), rhs->Expr_dist(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Interface_arrays(), rhs, rhs->Interface_arrays(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Process(), rhs, rhs->Process(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Cont_assigns(), rhs, rhs->Cont_assigns(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Clocking_blocks(), rhs, rhs->Clocking_blocks(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Ports(), rhs, rhs->Ports(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Gen_scope_arrays(), rhs, rhs->Gen_scope_arrays(), context)) != 0) return r;
  if ((r = lhs->VpiEndLabel().compare(rhs->VpiEndLabel())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  return r;
}

}  // namespace UHDM
