/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   property_decl.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/property_decl.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/attribute.h>
#include <uhdm/prop_formal_decl.h>
#include <uhdm/property_spec.h>
#include <uhdm/variables.h>


namespace UHDM {
std::string_view property_decl::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool property_decl::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view property_decl::VpiFullName() const {
  if (!vpiFullName_) {
    const std::string fullName = ComputeFullName();
    if (!fullName.empty()) {
      const_cast<property_decl*>(this)->VpiFullName(fullName);
    }
  }
  return serializer_->GetSymbol(vpiFullName_);
}

bool property_decl::VpiFullName(std::string_view data) {
  vpiFullName_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* property_decl::GetByVpiName(std::string_view name) const {
  if (attributes_ != nullptr) {
    for (const BaseClass *ref : *attributes_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (prop_formal_decls_ != nullptr) {
    for (const BaseClass *ref : *prop_formal_decls_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (variables_ != nullptr) {
    for (const BaseClass *ref : *variables_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((property_spec_ != nullptr) && (property_spec_->VpiName().compare(name) == 0)) {
    return property_spec_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> property_decl::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiAttribute: return std::make_tuple(nullptr, uhdmattributes, (const std::vector<const BaseClass*>*)attributes_);
    case vpiPropFormalDecl: return std::make_tuple(nullptr, uhdmprop_formal_decls, (const std::vector<const BaseClass*>*)prop_formal_decls_);
    case vpiPropertySpec: return std::make_tuple(property_spec_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiVariables: return std::make_tuple(nullptr, uhdmvariables, (const std::vector<const BaseClass*>*)variables_);
  }
  return basetype_t::GetByVpiType(type);
}

property_decl::vpi_property_value_t property_decl::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiFullName: {
      std::string_view fullname = VpiFullName();
      if (!fullname.empty() && (VpiName() != fullname)) {
        return vpi_property_value_t(fullname.data());
      }
    } break;
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void property_decl::DeepCopy(property_decl* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterProperty_decl(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Attributes()) {
    auto clone_vec = context->m_serializer->MakeAttributeVec();
    clone->Attributes(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Prop_formal_decls()) {
    auto clone_vec = context->m_serializer->MakeProp_formal_declVec();
    clone->Prop_formal_decls(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Variables()) {
    auto clone_vec = context->m_serializer->MakeVariablesVec();
    clone->Variables(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Property_spec()) clone->Property_spec(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveProperty_decl(clone, nullptr);
}

property_decl* property_decl::DeepClone(BaseClass* parent, CloneContext* context) const {
  property_decl* const clone = context->m_serializer->MakeProperty_decl();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t property_decl::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Attributes(), rhs, rhs->Attributes(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Prop_formal_decls(), rhs, rhs->Prop_formal_decls(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Variables(), rhs, rhs->Variables(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Property_spec(), rhs->Property_spec(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
