/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   property_inst.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/property_inst.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/clocking_block.h>
#include <uhdm/expr_dist.h>
#include <uhdm/property_decl.h>
#include <uhdm/property_expr_named_event_group.h>


namespace UHDM {
std::string_view property_inst::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool property_inst::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* property_inst::GetByVpiName(std::string_view name) const {
  if ((vpiDisableCondition_ != nullptr) && (vpiDisableCondition_->VpiName().compare(name) == 0)) {
    return vpiDisableCondition_;
  }
  if (vpiArguments_ != nullptr) {
    for (const BaseClass *ref : *vpiArguments_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((property_decl_ != nullptr) && (property_decl_->VpiName().compare(name) == 0)) {
    return property_decl_;
  }
  if ((clocking_block_ != nullptr) && (clocking_block_->VpiName().compare(name) == 0)) {
    return clocking_block_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> property_inst::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiArgument: return std::make_tuple(nullptr, uhdmvpiArguments, (const std::vector<const BaseClass*>*)vpiArguments_);
    case vpiClockingBlock: return std::make_tuple(clocking_block_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiDisableCondition: return std::make_tuple(vpiDisableCondition_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiPropertyDecl: return std::make_tuple(property_decl_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

property_inst::vpi_property_value_t property_inst::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void property_inst::DeepCopy(property_inst* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterProperty_inst(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = VpiDisableCondition()) clone->VpiDisableCondition(obj->DeepClone(clone, context));
  if (auto vec = VpiArguments()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->VpiArguments(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Property_decl()) clone->Property_decl(obj->DeepClone(clone, context));
  if (auto obj = Clocking_block()) clone->Clocking_block(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveProperty_inst(clone, nullptr);
}

property_inst* property_inst::DeepClone(BaseClass* parent, CloneContext* context) const {
  property_inst* const clone = context->m_serializer->MakeProperty_inst();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t property_inst::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->VpiDisableCondition(), rhs->VpiDisableCondition(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->VpiArguments(), rhs, rhs->VpiArguments(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Property_decl(), rhs->Property_decl(), context)) != 0) return r;
  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Clocking_block(), rhs->Clocking_block(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
