/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   property_spec.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/property_spec.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>
#include <uhdm/expr_dist.h>
#include <uhdm/property_expr_group.h>


namespace UHDM {
const BaseClass* property_spec::GetByVpiName(std::string_view name) const {
  if ((vpiDisableCondition_ != nullptr) && (vpiDisableCondition_->VpiName().compare(name) == 0)) {
    return vpiDisableCondition_;
  }
  if ((vpiClockingEvent_ != nullptr) && (vpiClockingEvent_->VpiName().compare(name) == 0)) {
    return vpiClockingEvent_;
  }
  if ((vpiPropertyExpr_ != nullptr) && (vpiPropertyExpr_->VpiName().compare(name) == 0)) {
    return vpiPropertyExpr_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> property_spec::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiClockingEvent: return std::make_tuple(vpiClockingEvent_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiDisableCondition: return std::make_tuple(vpiDisableCondition_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiPropertyExpr: return std::make_tuple(vpiPropertyExpr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

property_spec::vpi_property_value_t property_spec::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void property_spec::DeepCopy(property_spec* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterProperty_spec(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = VpiDisableCondition()) clone->VpiDisableCondition(obj->DeepClone(clone, context));
  if (auto obj = VpiClockingEvent()) clone->VpiClockingEvent(obj->DeepClone(clone, context));
  if (auto obj = VpiPropertyExpr()) clone->VpiPropertyExpr(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveProperty_spec(clone, nullptr);
}

property_spec* property_spec::DeepClone(BaseClass* parent, CloneContext* context) const {
  property_spec* const clone = context->m_serializer->MakeProperty_spec();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t property_spec::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->VpiDisableCondition(), rhs->VpiDisableCondition(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->VpiClockingEvent(), rhs->VpiClockingEvent(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->VpiPropertyExpr(), rhs->VpiPropertyExpr(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
