/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   ref_module.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/ref_module.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/actual_group.h>
#include <uhdm/port.h>


namespace UHDM {
std::string_view ref_module::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool ref_module::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view ref_module::VpiDefName() const {
  return vpiDefName_ ? serializer_->GetSymbol(vpiDefName_) : kEmpty;
}

bool ref_module::VpiDefName(std::string_view data) {
  vpiDefName_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* ref_module::GetByVpiName(std::string_view name) const {
  if ((actual_group_ != nullptr) && (actual_group_->VpiName().compare(name) == 0)) {
    return actual_group_;
  }
  if (ports_ != nullptr) {
    for (const BaseClass *ref : *ports_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> ref_module::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiActual: return std::make_tuple(actual_group_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiPort: return std::make_tuple(nullptr, uhdmports, (const std::vector<const BaseClass*>*)ports_);
  }
  return basetype_t::GetByVpiType(type);
}

ref_module::vpi_property_value_t ref_module::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiDefName: {
      std::string_view data = VpiDefName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void ref_module::DeepCopy(ref_module* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterRef_module(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Actual_group()) clone->Actual_group(obj->DeepClone(clone, context));
  if (auto vec = Ports()) {
    auto clone_vec = context->m_serializer->MakePortVec();
    clone->Ports(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveRef_module(clone, nullptr);
}

ref_module* ref_module::DeepClone(BaseClass* parent, CloneContext* context) const {
  ref_module* const clone = context->m_serializer->MakeRef_module();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t ref_module::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiDefName().compare(rhs->VpiDefName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Actual_group(), rhs->Actual_group(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Ports(), rhs, rhs->Ports(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
