/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   ref_obj.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/ref_obj.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/actual_group.h>


namespace UHDM {
std::string_view ref_obj::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool ref_obj::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view ref_obj::VpiFullName() const {
  if (!vpiFullName_) {
    const std::string fullName = ComputeFullName();
    if (!fullName.empty()) {
      const_cast<ref_obj*>(this)->VpiFullName(fullName);
    }
  }
  return serializer_->GetSymbol(vpiFullName_);
}

bool ref_obj::VpiFullName(std::string_view data) {
  vpiFullName_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view ref_obj::VpiDefName() const {
  return vpiDefName_ ? serializer_->GetSymbol(vpiDefName_) : kEmpty;
}

bool ref_obj::VpiDefName(std::string_view data) {
  vpiDefName_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* ref_obj::GetByVpiName(std::string_view name) const {
  if ((actual_group_ != nullptr) && (actual_group_->VpiName().compare(name) == 0)) {
    return actual_group_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> ref_obj::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiActual: return std::make_tuple(actual_group_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

ref_obj::vpi_property_value_t ref_obj::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiDefName: {
      std::string_view data = VpiDefName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiFullName: {
      std::string_view fullname = VpiFullName();
      if (!fullname.empty() && (VpiName() != fullname)) {
        return vpi_property_value_t(fullname.data());
      }
    } break;
    case vpiGeneric: return vpi_property_value_t(VpiGeneric());
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiStructMember: return vpi_property_value_t(VpiStructMember());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void ref_obj::DeepCopy(ref_obj* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterRef_obj(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (!clone->Actual_group()) clone->Actual_group(elaboratorContext->m_elaborator.bindAny(VpiName()));
  if (!clone->Actual_group()) clone->Actual_group((any*) Actual_group());
  elaboratorContext->m_elaborator.leaveRef_obj(clone, nullptr);
}

ref_obj* ref_obj::DeepClone(BaseClass* parent, CloneContext* context) const {
  ref_obj* const clone = context->m_serializer->MakeRef_obj();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t ref_obj::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if ((r = VpiType() - other->VpiType()) != 0) {
    context->m_failedLhs = this;
    context->m_failedRhs = other;
    return r;
  }
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiDefName().compare(rhs->VpiDefName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiGeneric() == rhs->VpiGeneric()) ? 0 : (lhs->VpiGeneric() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Actual_group(), rhs->Actual_group(), context)) != 0) return r;
  if ((r = (lhs->VpiStructMember() == rhs->VpiStructMember()) ? 0 : (lhs->VpiStructMember() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  return r;
}

}  // namespace UHDM
