/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   ref_var.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/ref_var.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/actual_group.h>
#include <uhdm/task_func.h>


namespace UHDM {
std::string_view ref_var::VpiDefName() const {
  return vpiDefName_ ? serializer_->GetSymbol(vpiDefName_) : kEmpty;
}

bool ref_var::VpiDefName(std::string_view data) {
  vpiDefName_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* ref_var::GetByVpiName(std::string_view name) const {
  if ((actual_group_ != nullptr) && (actual_group_->VpiName().compare(name) == 0)) {
    return actual_group_;
  }
  if ((task_func_ != nullptr) && (task_func_->VpiName().compare(name) == 0)) {
    return task_func_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> ref_var::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiActual: return std::make_tuple(actual_group_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiTaskFunc: return std::make_tuple(task_func_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

ref_var::vpi_property_value_t ref_var::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiDefName: {
      std::string_view data = VpiDefName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiGeneric: return vpi_property_value_t(VpiGeneric());
    case vpiStructMember: return vpi_property_value_t(VpiStructMember());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void ref_var::DeepCopy(ref_var* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterRef_var(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (!clone->Actual_group()) clone->Actual_group(elaboratorContext->m_elaborator.bindAny(VpiName()));
  if (!clone->Actual_group()) clone->Actual_group((any*) Actual_group());
  if (auto obj = Task_func()) clone->Task_func(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveRef_var(clone, nullptr);
}

ref_var* ref_var::DeepClone(BaseClass* parent, CloneContext* context) const {
  ref_var* const clone = context->m_serializer->MakeRef_var();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t ref_var::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiDefName().compare(rhs->VpiDefName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiGeneric() == rhs->VpiGeneric()) ? 0 : (lhs->VpiGeneric() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Actual_group(), rhs->Actual_group(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Task_func(), rhs->Task_func(), context)) != 0) return r;
  if ((r = (lhs->VpiStructMember() == rhs->VpiStructMember()) ? 0 : (lhs->VpiStructMember() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  return r;
}

}  // namespace UHDM
