/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   reg.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/reg.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>


namespace UHDM {
const BaseClass* reg::GetByVpiName(std::string_view name) const {
  if ((left_expr_ != nullptr) && (left_expr_->VpiName().compare(name) == 0)) {
    return left_expr_;
  }
  if ((right_expr_ != nullptr) && (right_expr_->VpiName().compare(name) == 0)) {
    return right_expr_;
  }
  if ((index_ != nullptr) && (index_->VpiName().compare(name) == 0)) {
    return index_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> reg::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiIndex: return std::make_tuple(index_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiLeftRange: return std::make_tuple(left_expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiRightRange: return std::make_tuple(right_expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

reg::vpi_property_value_t reg::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void reg::DeepCopy(reg* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterReg(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Left_expr()) clone->Left_expr(obj->DeepClone(clone, context));
  if (auto obj = Right_expr()) clone->Right_expr(obj->DeepClone(clone, context));
  if (auto obj = Index()) clone->Index(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveReg(clone, nullptr);
}

reg* reg::DeepClone(BaseClass* parent, CloneContext* context) const {
  reg* const clone = context->m_serializer->MakeReg();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t reg::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->Left_expr(), rhs->Left_expr(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Right_expr(), rhs->Right_expr(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Index(), rhs->Index(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
