/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   restrict.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/restrict.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/clocking_block.h>


namespace UHDM {
const BaseClass* restrict::GetByVpiName(std::string_view name) const {
  if ((clocking_block_ != nullptr) && (clocking_block_->VpiName().compare(name) == 0)) {
    return clocking_block_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> restrict::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiClockingBlock: return std::make_tuple(clocking_block_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

restrict::vpi_property_value_t restrict::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void restrict::DeepCopy(restrict* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterRestrict(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Clocking_block()) clone->Clocking_block(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveRestrict(clone, nullptr);
}

restrict* restrict::DeepClone(BaseClass* parent, CloneContext* context) const {
  restrict* const clone = context->m_serializer->MakeRestrict();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t restrict::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->Clocking_block(), rhs->Clocking_block(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
