/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   scope.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/scope.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/array_var.h>
#include <uhdm/attribute.h>
#include <uhdm/concurrent_assertions.h>
#include <uhdm/instance_item.h>
#include <uhdm/let_decl.h>
#include <uhdm/logic_var.h>
#include <uhdm/named_event.h>
#include <uhdm/named_event_array.h>
#include <uhdm/param_assign.h>
#include <uhdm/parameters.h>
#include <uhdm/property_decl.h>
#include <uhdm/scope.h>
#include <uhdm/sequence_decl.h>
#include <uhdm/typespec.h>
#include <uhdm/variables.h>
#include <uhdm/virtual_interface_var.h>


namespace UHDM {
std::string_view scope::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool scope::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view scope::VpiFullName() const {
  if (!vpiFullName_) {
    const std::string fullName = ComputeFullName();
    if (!fullName.empty()) {
      const_cast<scope*>(this)->VpiFullName(fullName);
    }
  }
  return serializer_->GetSymbol(vpiFullName_);
}

bool scope::VpiFullName(std::string_view data) {
  vpiFullName_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* scope::GetByVpiName(std::string_view name) const {
  if (property_decls_ != nullptr) {
    for (const BaseClass *ref : *property_decls_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (sequence_decls_ != nullptr) {
    for (const BaseClass *ref : *sequence_decls_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (concurrent_assertions_ != nullptr) {
    for (const BaseClass *ref : *concurrent_assertions_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (named_events_ != nullptr) {
    for (const BaseClass *ref : *named_events_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (named_event_arrays_ != nullptr) {
    for (const BaseClass *ref : *named_event_arrays_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (variables_ != nullptr) {
    for (const BaseClass *ref : *variables_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (virtual_interface_vars_ != nullptr) {
    for (const BaseClass *ref : *virtual_interface_vars_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (logic_vars_ != nullptr) {
    for (const BaseClass *ref : *logic_vars_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (array_vars_ != nullptr) {
    for (const BaseClass *ref : *array_vars_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (array_var_mems_ != nullptr) {
    for (const BaseClass *ref : *array_var_mems_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (parameters_ != nullptr) {
    for (const BaseClass *ref : *parameters_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (param_assigns_ != nullptr) {
    for (const BaseClass *ref : *param_assigns_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (scopes_ != nullptr) {
    for (const BaseClass *ref : *scopes_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (typespecs_ != nullptr) {
    for (const BaseClass *ref : *typespecs_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (instance_items_ != nullptr) {
    for (const BaseClass *ref : *instance_items_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (let_decls_ != nullptr) {
    for (const BaseClass *ref : *let_decls_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (attributes_ != nullptr) {
    for (const BaseClass *ref : *attributes_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> scope::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiAttribute: return std::make_tuple(nullptr, uhdmattributes, (const std::vector<const BaseClass*>*)attributes_);
    case vpiConcurrentAssertions: return std::make_tuple(nullptr, uhdmconcurrent_assertions, (const std::vector<const BaseClass*>*)concurrent_assertions_);
    case vpiImportTypespec: return std::make_tuple(nullptr, uhdminstance_items, (const std::vector<const BaseClass*>*)instance_items_);
    case vpiInternalScope: return std::make_tuple(nullptr, uhdmscopes, (const std::vector<const BaseClass*>*)scopes_);
    case vpiLetDecl: return std::make_tuple(nullptr, uhdmlet_decls, (const std::vector<const BaseClass*>*)let_decls_);
    case vpiMemory: return std::make_tuple(nullptr, uhdmarray_var_mems, (const std::vector<const BaseClass*>*)array_var_mems_);
    case vpiNamedEvent: return std::make_tuple(nullptr, uhdmnamed_events, (const std::vector<const BaseClass*>*)named_events_);
    case vpiNamedEventArray: return std::make_tuple(nullptr, uhdmnamed_event_arrays, (const std::vector<const BaseClass*>*)named_event_arrays_);
    case vpiParamAssign: return std::make_tuple(nullptr, uhdmparam_assigns, (const std::vector<const BaseClass*>*)param_assigns_);
    case vpiParameter: return std::make_tuple(nullptr, uhdmparameters, (const std::vector<const BaseClass*>*)parameters_);
    case vpiPropertyDecl: return std::make_tuple(nullptr, uhdmproperty_decls, (const std::vector<const BaseClass*>*)property_decls_);
    case vpiReg: return std::make_tuple(nullptr, uhdmlogic_vars, (const std::vector<const BaseClass*>*)logic_vars_);
    case vpiRegArray: return std::make_tuple(nullptr, uhdmarray_vars, (const std::vector<const BaseClass*>*)array_vars_);
    case vpiSequenceDecl: return std::make_tuple(nullptr, uhdmsequence_decls, (const std::vector<const BaseClass*>*)sequence_decls_);
    case vpiTypedef: return std::make_tuple(nullptr, uhdmtypespecs, (const std::vector<const BaseClass*>*)typespecs_);
    case vpiVariables: return std::make_tuple(nullptr, uhdmvariables, (const std::vector<const BaseClass*>*)variables_);
    case vpiVirtualInterfaceVar: return std::make_tuple(nullptr, uhdmvirtual_interface_vars, (const std::vector<const BaseClass*>*)virtual_interface_vars_);
  }
  return basetype_t::GetByVpiType(type);
}

scope::vpi_property_value_t scope::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiFullName: {
      std::string_view fullname = VpiFullName();
      if (!fullname.empty() && (VpiName() != fullname)) {
        return vpi_property_value_t(fullname.data());
      }
    } break;
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void scope::DeepCopy(scope* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Property_decls()) {
    auto clone_vec = context->m_serializer->MakeProperty_declVec();
    clone->Property_decls(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Sequence_decls()) {
    auto clone_vec = context->m_serializer->MakeSequence_declVec();
    clone->Sequence_decls(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Concurrent_assertions()) {
    auto clone_vec = context->m_serializer->MakeConcurrent_assertionsVec();
    clone->Concurrent_assertions(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Named_events()) {
    auto clone_vec = context->m_serializer->MakeNamed_eventVec();
    clone->Named_events(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Named_event_arrays()) {
    auto clone_vec = context->m_serializer->MakeNamed_event_arrayVec();
    clone->Named_event_arrays(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Variables()) {
    auto clone_vec = context->m_serializer->MakeVariablesVec();
    clone->Variables(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Virtual_interface_vars()) {
    auto clone_vec = context->m_serializer->MakeVirtual_interface_varVec();
    clone->Virtual_interface_vars(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Logic_vars()) {
    auto clone_vec = context->m_serializer->MakeLogic_varVec();
    clone->Logic_vars(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Array_vars()) {
    auto clone_vec = context->m_serializer->MakeArray_varVec();
    clone->Array_vars(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Array_var_mems()) {
    auto clone_vec = context->m_serializer->MakeArray_varVec();
    clone->Array_var_mems(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Parameters()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->Parameters(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Param_assigns()) {
    auto clone_vec = context->m_serializer->MakeParam_assignVec();
    clone->Param_assigns(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Scopes()) {
    auto clone_vec = context->m_serializer->MakeScopeVec();
    clone->Scopes(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Typespecs()) {
    auto clone_vec = context->m_serializer->MakeTypespecVec();
    clone->Typespecs(clone_vec);
    clone_vec->insert(clone_vec->cend(), vec->cbegin(), vec->cend());
  }
  if (auto vec = Instance_items()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->Instance_items(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Let_decls()) {
    auto clone_vec = context->m_serializer->MakeLet_declVec();
    clone->Let_decls(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Attributes()) {
    auto clone_vec = context->m_serializer->MakeAttributeVec();
    clone->Attributes(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
}

int32_t scope::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Property_decls(), rhs, rhs->Property_decls(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Sequence_decls(), rhs, rhs->Sequence_decls(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Concurrent_assertions(), rhs, rhs->Concurrent_assertions(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Named_events(), rhs, rhs->Named_events(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Named_event_arrays(), rhs, rhs->Named_event_arrays(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Variables(), rhs, rhs->Variables(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Virtual_interface_vars(), rhs, rhs->Virtual_interface_vars(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Logic_vars(), rhs, rhs->Logic_vars(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Array_vars(), rhs, rhs->Array_vars(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Array_var_mems(), rhs, rhs->Array_var_mems(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Parameters(), rhs, rhs->Parameters(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Param_assigns(), rhs, rhs->Param_assigns(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Scopes(), rhs, rhs->Scopes(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Typespecs(), rhs, rhs->Typespecs(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Instance_items(), rhs, rhs->Instance_items(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Let_decls(), rhs, rhs->Let_decls(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Attributes(), rhs, rhs->Attributes(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
