/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   sequence_inst.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/sequence_inst.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/clocking_block.h>
#include <uhdm/named_event_sequence_expr_group.h>
#include <uhdm/sequence_decl.h>


namespace UHDM {
std::string_view sequence_inst::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool sequence_inst::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* sequence_inst::GetByVpiName(std::string_view name) const {
  if ((sequence_decl_ != nullptr) && (sequence_decl_->VpiName().compare(name) == 0)) {
    return sequence_decl_;
  }
  if (named_event_sequence_expr_groups_ != nullptr) {
    for (const BaseClass *ref : *named_event_sequence_expr_groups_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((clocking_block_ != nullptr) && (clocking_block_->VpiName().compare(name) == 0)) {
    return clocking_block_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> sequence_inst::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiArgument: return std::make_tuple(nullptr, uhdmnamed_event_sequence_expr_groups, (const std::vector<const BaseClass*>*)named_event_sequence_expr_groups_);
    case vpiClockingBlock: return std::make_tuple(clocking_block_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiSequenceDecl: return std::make_tuple(sequence_decl_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

sequence_inst::vpi_property_value_t sequence_inst::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void sequence_inst::DeepCopy(sequence_inst* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterSequence_inst(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Sequence_decl()) clone->Sequence_decl(obj->DeepClone(clone, context));
  if (auto vec = Named_event_sequence_expr_groups()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->Named_event_sequence_expr_groups(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Clocking_block()) clone->Clocking_block(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveSequence_inst(clone, nullptr);
}

sequence_inst* sequence_inst::DeepClone(BaseClass* parent, CloneContext* context) const {
  sequence_inst* const clone = context->m_serializer->MakeSequence_inst();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t sequence_inst::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->Sequence_decl(), rhs->Sequence_decl(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Named_event_sequence_expr_groups(), rhs, rhs->Named_event_sequence_expr_groups(), context)) != 0) return r;
  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Clocking_block(), rhs->Clocking_block(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
