/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   simple_expr.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/simple_expr.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/simple_expr_use_group.h>


namespace UHDM {
const BaseClass* simple_expr::GetByVpiName(std::string_view name) const {
  if (vpiUses_ != nullptr) {
    for (const BaseClass *ref : *vpiUses_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> simple_expr::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiUse: return std::make_tuple(nullptr, uhdmvpiUses, (const std::vector<const BaseClass*>*)vpiUses_);
  }
  return basetype_t::GetByVpiType(type);
}

simple_expr::vpi_property_value_t simple_expr::GetVpiPropertyValue(int32_t property) const {
  return basetype_t::GetVpiPropertyValue(property);
}

void simple_expr::DeepCopy(simple_expr* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = VpiUses()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->VpiUses(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
}

int32_t simple_expr::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs, lhs->VpiUses(), rhs, rhs->VpiUses(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
