/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   stmt.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */
#include <uhdm/stmt.h>

#include <iostream>
#include <uhdm/uhdm.h>

namespace UHDM {
bool stmtGroupCompliant(const any* item) {
  if (item == nullptr) {
    return true;
  }
  UHDM_OBJECT_TYPE uhdmtype = item->UhdmType();
  if ((uhdmtype != uhdmalways) &&
      (uhdmtype != uhdmarray_expr) &&
      (uhdmtype != uhdmarray_net) &&
      (uhdmtype != uhdmarray_var) &&
      (uhdmtype != uhdmassert_stmt) &&
      (uhdmtype != uhdmassertion) &&
      (uhdmtype != uhdmassign_stmt) &&
      (uhdmtype != uhdmassignment) &&
      (uhdmtype != uhdmassume) &&
      (uhdmtype != uhdmatomic_stmt) &&
      (uhdmtype != uhdmbegin) &&
      (uhdmtype != uhdmbit_select) &&
      (uhdmtype != uhdmbit_var) &&
      (uhdmtype != uhdmbreak_stmt) &&
      (uhdmtype != uhdmbyte_var) &&
      (uhdmtype != uhdmcase_stmt) &&
      (uhdmtype != uhdmchandle_var) &&
      (uhdmtype != uhdmchecker_decl) &&
      (uhdmtype != uhdmchecker_inst) &&
      (uhdmtype != uhdmclass_defn) &&
      (uhdmtype != uhdmclass_obj) &&
      (uhdmtype != uhdmclass_var) &&
      (uhdmtype != uhdmclocking_block) &&
      (uhdmtype != uhdmconstant) &&
      (uhdmtype != uhdmcont_assign) &&
      (uhdmtype != uhdmcontinue_stmt) &&
      (uhdmtype != uhdmcover) &&
      (uhdmtype != uhdmdeassign) &&
      (uhdmtype != uhdmdelay_control) &&
      (uhdmtype != uhdmdisable) &&
      (uhdmtype != uhdmdisable_fork) &&
      (uhdmtype != uhdmdisables) &&
      (uhdmtype != uhdmdo_while) &&
      (uhdmtype != uhdmenum_net) &&
      (uhdmtype != uhdmenum_var) &&
      (uhdmtype != uhdmevent_control) &&
      (uhdmtype != uhdmevent_stmt) &&
      (uhdmtype != uhdmexpect_stmt) &&
      (uhdmtype != uhdmexpr) &&
      (uhdmtype != uhdmfinal_stmt) &&
      (uhdmtype != uhdmfor_stmt) &&
      (uhdmtype != uhdmforce) &&
      (uhdmtype != uhdmforeach_stmt) &&
      (uhdmtype != uhdmforever_stmt) &&
      (uhdmtype != uhdmfork_stmt) &&
      (uhdmtype != uhdmfunc_call) &&
      (uhdmtype != uhdmfunction) &&
      (uhdmtype != uhdmgen_case) &&
      (uhdmtype != uhdmgen_for) &&
      (uhdmtype != uhdmgen_if) &&
      (uhdmtype != uhdmgen_if_else) &&
      (uhdmtype != uhdmgen_region) &&
      (uhdmtype != uhdmgen_scope) &&
      (uhdmtype != uhdmgen_stmt) &&
      (uhdmtype != uhdmhier_path) &&
      (uhdmtype != uhdmif_else) &&
      (uhdmtype != uhdmif_stmt) &&
      (uhdmtype != uhdmimmediate_assert) &&
      (uhdmtype != uhdmimmediate_assume) &&
      (uhdmtype != uhdmimmediate_cover) &&
      (uhdmtype != uhdmindexed_part_select) &&
      (uhdmtype != uhdminitial) &&
      (uhdmtype != uhdminstance) &&
      (uhdmtype != uhdmint_var) &&
      (uhdmtype != uhdminteger_net) &&
      (uhdmtype != uhdminteger_var) &&
      (uhdmtype != uhdminterface_inst) &&
      (uhdmtype != uhdmlet_expr) &&
      (uhdmtype != uhdmlogic_net) &&
      (uhdmtype != uhdmlogic_var) &&
      (uhdmtype != uhdmlong_int_var) &&
      (uhdmtype != uhdmmethod_func_call) &&
      (uhdmtype != uhdmmethod_task_call) &&
      (uhdmtype != uhdmmodule_array) &&
      (uhdmtype != uhdmmodule_inst) &&
      (uhdmtype != uhdmnamed_begin) &&
      (uhdmtype != uhdmnamed_fork) &&
      (uhdmtype != uhdmnet) &&
      (uhdmtype != uhdmnet_bit) &&
      (uhdmtype != uhdmnets) &&
      (uhdmtype != uhdmnull_stmt) &&
      (uhdmtype != uhdmoperation) &&
      (uhdmtype != uhdmordered_wait) &&
      (uhdmtype != uhdmpackage) &&
      (uhdmtype != uhdmpacked_array_net) &&
      (uhdmtype != uhdmpacked_array_var) &&
      (uhdmtype != uhdmparam_assign) &&
      (uhdmtype != uhdmparameter) &&
      (uhdmtype != uhdmpart_select) &&
      (uhdmtype != uhdmprocess_stmt) &&
      (uhdmtype != uhdmprogram) &&
      (uhdmtype != uhdmproperty_inst) &&
      (uhdmtype != uhdmreal_var) &&
      (uhdmtype != uhdmref_module) &&
      (uhdmtype != uhdmref_obj) &&
      (uhdmtype != uhdmref_typespec) &&
      (uhdmtype != uhdmref_var) &&
      (uhdmtype != uhdmrelease) &&
      (uhdmtype != uhdmrepeat) &&
      (uhdmtype != uhdmrepeat_control) &&
      (uhdmtype != uhdmrestrict) &&
      (uhdmtype != uhdmreturn_stmt) &&
      (uhdmtype != uhdmscope) &&
      (uhdmtype != uhdmsequence_inst) &&
      (uhdmtype != uhdmshort_int_var) &&
      (uhdmtype != uhdmshort_real_var) &&
      (uhdmtype != uhdmsimple_expr) &&
      (uhdmtype != uhdmspec_param) &&
      (uhdmtype != uhdmstring_var) &&
      (uhdmtype != uhdmstruct_net) &&
      (uhdmtype != uhdmstruct_var) &&
      (uhdmtype != uhdmsys_func_call) &&
      (uhdmtype != uhdmsys_task_call) &&
      (uhdmtype != uhdmtask) &&
      (uhdmtype != uhdmtask_call) &&
      (uhdmtype != uhdmtask_func) &&
      (uhdmtype != uhdmtf_call) &&
      (uhdmtype != uhdmtime_net) &&
      (uhdmtype != uhdmtime_var) &&
      (uhdmtype != uhdmunion_var) &&
      (uhdmtype != uhdmunsupported_expr) &&
      (uhdmtype != uhdmunsupported_stmt) &&
      (uhdmtype != uhdmvar_bit) &&
      (uhdmtype != uhdmvar_select) &&
      (uhdmtype != uhdmvariables) &&
      (uhdmtype != uhdmwait_fork) &&
      (uhdmtype != uhdmwait_stmt) &&
      (uhdmtype != uhdmwaits) &&
      (uhdmtype != uhdmwhile_stmt)) {
    item->GetSerializer()->GetErrorHandler()(ErrorType::UHDM_WRONG_OBJECT_TYPE, "Internal Error: adding wrong object type (" + UhdmName(uhdmtype) + ") in a stmt group!", item, nullptr);
    return false;
  }
  return true;
}

bool stmtGroupCompliant(const VectorOfany* vec) {
  if (vec != nullptr) {
    for (auto item : *vec) {
      if (!stmtGroupCompliant(item)) {
        return false;
      }
    }
  }
  return true;
}

}  // namespace UHDM
