/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   struct_net.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/struct_net.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/nets.h>


namespace UHDM {
const BaseClass* struct_net::GetByVpiName(std::string_view name) const {
  if (nets_ != nullptr) {
    for (const BaseClass *ref : *nets_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> struct_net::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiMember: return std::make_tuple(nullptr, uhdmnets, (const std::vector<const BaseClass*>*)nets_);
  }
  return basetype_t::GetByVpiType(type);
}

struct_net::vpi_property_value_t struct_net::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiPackedArrayMember: return vpi_property_value_t(VpiPackedArrayMember());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void struct_net::DeepCopy(struct_net* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterStruct_net(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Nets()) {
    auto clone_vec = context->m_serializer->MakeNetsVec();
    clone->Nets(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveStruct_net(clone, nullptr);
}

struct_net* struct_net::DeepClone(BaseClass* parent, CloneContext* context) const {
  ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  struct_net* clone = any_cast<struct_net*>(elaboratorContext->m_elaborator.bindNet(VpiName()));
  if (clone != nullptr) {
    return clone;
  }
  clone = context->m_serializer->MakeStruct_net();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t struct_net::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = (lhs->VpiPackedArrayMember() == rhs->VpiPackedArrayMember()) ? 0 : (lhs->VpiPackedArrayMember() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Nets(), rhs, rhs->Nets(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
