/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   struct_typespec.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/struct_typespec.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/function.h>
#include <uhdm/typespec_member.h>


namespace UHDM {
const BaseClass* struct_typespec::GetByVpiName(std::string_view name) const {
  if (members_ != nullptr) {
    for (const BaseClass *ref : *members_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((resolution_func_ != nullptr) && (resolution_func_->VpiName().compare(name) == 0)) {
    return resolution_func_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> struct_typespec::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiFunction: return std::make_tuple(resolution_func_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiTypespecMember: return std::make_tuple(nullptr, uhdmmembers, (const std::vector<const BaseClass*>*)members_);
  }
  return basetype_t::GetByVpiType(type);
}

struct_typespec::vpi_property_value_t struct_typespec::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiPacked: return vpi_property_value_t(VpiPacked());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void struct_typespec::DeepCopy(struct_typespec* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterStruct_typespec(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Members()) {
    auto clone_vec = context->m_serializer->MakeTypespec_memberVec();
    clone->Members(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Resolution_func()) clone->Resolution_func(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveStruct_typespec(clone, nullptr);
}

struct_typespec* struct_typespec::DeepClone(BaseClass* parent, CloneContext* context) const {
  struct_typespec* const clone = context->m_serializer->MakeStruct_typespec();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t struct_typespec::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = (lhs->VpiPacked() == rhs->VpiPacked()) ? 0 : (lhs->VpiPacked() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Members(), rhs, rhs->Members(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Resolution_func(), rhs->Resolution_func(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
