/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   sys_task_call.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/sys_task_call.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/user_systf.h>


namespace UHDM {
const BaseClass* sys_task_call::GetByVpiName(std::string_view name) const {
  if ((user_systf_ != nullptr) && (user_systf_->VpiName().compare(name) == 0)) {
    return user_systf_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> sys_task_call::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiUserSystf: return std::make_tuple(user_systf_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

sys_task_call::vpi_property_value_t sys_task_call::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
    case vpiUserDefn: return vpi_property_value_t(VpiUserDefn());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void sys_task_call::DeepCopy(sys_task_call* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterSys_task_call(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = User_systf()) clone->User_systf(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveSys_task_call(clone, nullptr);
}

int32_t sys_task_call::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = (lhs->VpiUserDefn() == rhs->VpiUserDefn()) ? 0 : (lhs->VpiUserDefn() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->User_systf(), rhs->User_systf(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
