/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   table_entry.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/table_entry.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/attribute.h>


namespace UHDM {
std::string_view table_entry::VpiValue() const {
  return vpiValue_ ? serializer_->GetSymbol(vpiValue_) : kEmpty;
}

bool table_entry::VpiValue(std::string_view data) {
  vpiValue_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* table_entry::GetByVpiName(std::string_view name) const {
  if (attributes_ != nullptr) {
    for (const BaseClass *ref : *attributes_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> table_entry::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiAttribute: return std::make_tuple(nullptr, uhdmattributes, (const std::vector<const BaseClass*>*)attributes_);
  }
  return basetype_t::GetByVpiType(type);
}

table_entry::vpi_property_value_t table_entry::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiSize: return vpi_property_value_t(VpiSize());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void table_entry::DeepCopy(table_entry* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterTable_entry(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Attributes()) {
    auto clone_vec = context->m_serializer->MakeAttributeVec();
    clone->Attributes(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveTable_entry(clone, nullptr);
}

table_entry* table_entry::DeepClone(BaseClass* parent, CloneContext* context) const {
  table_entry* const clone = context->m_serializer->MakeTable_entry();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t table_entry::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiSize() - rhs->VpiSize()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Attributes(), rhs, rhs->Attributes(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
