/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   task_func.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/task_func.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/clocking_block.h>
#include <uhdm/expr.h>
#include <uhdm/instance.h>
#include <uhdm/io_decl.h>
#include <uhdm/stmt.h>
#include <uhdm/variables.h>


namespace UHDM {
std::string_view task_func::VpiDPICIdentifier() const {
  return vpiDPICIdentifier_ ? serializer_->GetSymbol(vpiDPICIdentifier_) : kEmpty;
}

bool task_func::VpiDPICIdentifier(std::string_view data) {
  vpiDPICIdentifier_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* task_func::GetByVpiName(std::string_view name) const {
  if ((left_range_ != nullptr) && (left_range_->VpiName().compare(name) == 0)) {
    return left_range_;
  }
  if ((right_range_ != nullptr) && (right_range_->VpiName().compare(name) == 0)) {
    return right_range_;
  }
  if ((return_ != nullptr) && (return_->VpiName().compare(name) == 0)) {
    return return_;
  }
  if ((class_defn_ != nullptr) && (class_defn_->VpiName().compare(name) == 0)) {
    return class_defn_;
  }
  if (io_decls_ != nullptr) {
    for (const BaseClass *ref : *io_decls_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((stmt_ != nullptr) && (stmt_->VpiName().compare(name) == 0)) {
    return stmt_;
  }
  if ((instance_ != nullptr) && (instance_->VpiName().compare(name) == 0)) {
    return instance_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> task_func::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiClassDefn: return std::make_tuple(class_defn_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiIODecl: return std::make_tuple(nullptr, uhdmio_decls, (const std::vector<const BaseClass*>*)io_decls_);
    case vpiInstance: return std::make_tuple(instance_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiLeftRange: return std::make_tuple(left_range_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiReturn: return std::make_tuple(return_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiRightRange: return std::make_tuple(right_range_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiStmt: return std::make_tuple(stmt_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

task_func::vpi_property_value_t task_func::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiAccessType: return vpi_property_value_t(VpiAccessType());
    case vpiAutomatic: return vpi_property_value_t(VpiAutomatic());
    case vpiDPICIdentifier: {
      std::string_view data = VpiDPICIdentifier();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiDPICStr: return vpi_property_value_t(VpiDPICStr());
    case vpiDPIContext: return vpi_property_value_t(VpiDPIContext());
    case vpiDPIPure: return vpi_property_value_t(VpiDPIPure());
    case vpiMethod: return vpi_property_value_t(VpiMethod());
    case vpiVirtual: return vpi_property_value_t(VpiVirtual());
    case vpiVisibility: return vpi_property_value_t(VpiVisibility());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void task_func::DeepCopy(task_func* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Left_range()) clone->Left_range(obj->DeepClone(clone, context));
  if (auto obj = Right_range()) clone->Right_range(obj->DeepClone(clone, context));
  if (auto obj = Return()) clone->Return(obj->DeepClone(clone, context));
  if (auto obj = Class_defn()) clone->Class_defn(obj->DeepClone(clone, context));
  if (auto vec = Io_decls()) {
    auto clone_vec = context->m_serializer->MakeIo_declVec();
    clone->Io_decls(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Stmt()) clone->Stmt(obj->DeepClone(clone, context));
  if (auto obj = Instance()) clone->Instance((instance*) obj);
  if (instance* inst = any_cast<instance*>(parent))
    clone->Instance(inst);
}

int32_t task_func::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = (lhs->VpiMethod() == rhs->VpiMethod()) ? 0 : (lhs->VpiMethod() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiAccessType() - rhs->VpiAccessType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiVisibility() - rhs->VpiVisibility()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiVirtual() == rhs->VpiVirtual()) ? 0 : (lhs->VpiVirtual() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiAutomatic() == rhs->VpiAutomatic()) ? 0 : (lhs->VpiAutomatic() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiDPIPure() == rhs->VpiDPIPure()) ? 0 : (lhs->VpiDPIPure() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiDPIContext() == rhs->VpiDPIContext()) ? 0 : (lhs->VpiDPIContext() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiDPICStr() - rhs->VpiDPICStr()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiDPICIdentifier().compare(rhs->VpiDPICIdentifier())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Left_range(), rhs->Left_range(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Right_range(), rhs->Right_range(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Return(), rhs->Return(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Class_defn(), rhs->Class_defn(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Io_decls(), rhs, rhs->Io_decls(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Stmt(), rhs->Stmt(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Instance(), rhs->Instance(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
