/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   tchk.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/tchk.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/attribute.h>
#include <uhdm/expr.h>
#include <uhdm/expr_tchk_term_group.h>
#include <uhdm/module_inst.h>
#include <uhdm/reg.h>
#include <uhdm/tchk_term.h>


namespace UHDM {
std::string_view tchk::VpiDelay() const {
  return vpiDelay_ ? serializer_->GetSymbol(vpiDelay_) : kEmpty;
}

bool tchk::VpiDelay(std::string_view data) {
  vpiDelay_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* tchk::GetByVpiName(std::string_view name) const {
  if ((module_inst_ != nullptr) && (module_inst_->VpiName().compare(name) == 0)) {
    return module_inst_;
  }
  if ((expr_ != nullptr) && (expr_->VpiName().compare(name) == 0)) {
    return expr_;
  }
  if (expr_tchk_terms_ != nullptr) {
    for (const BaseClass *ref : *expr_tchk_terms_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((tchk_ref_term_ != nullptr) && (tchk_ref_term_->VpiName().compare(name) == 0)) {
    return tchk_ref_term_;
  }
  if ((tchk_data_term_ != nullptr) && (tchk_data_term_->VpiName().compare(name) == 0)) {
    return tchk_data_term_;
  }
  if ((reg_ != nullptr) && (reg_->VpiName().compare(name) == 0)) {
    return reg_;
  }
  if (attributes_ != nullptr) {
    for (const BaseClass *ref : *attributes_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> tchk::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiAttribute: return std::make_tuple(nullptr, uhdmattributes, (const std::vector<const BaseClass*>*)attributes_);
    case vpiDelay: return std::make_tuple(expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiExpr: return std::make_tuple(nullptr, uhdmexpr_tchk_terms, (const std::vector<const BaseClass*>*)expr_tchk_terms_);
    case vpiModule: return std::make_tuple(module_inst_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiTchkDataTerm: return std::make_tuple(tchk_data_term_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiTchkNotifier: return std::make_tuple(reg_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiTchkRefTerm: return std::make_tuple(tchk_ref_term_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

tchk::vpi_property_value_t tchk::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiTchkType: return vpi_property_value_t(VpiTchkType());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void tchk::DeepCopy(tchk* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterTchk(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Module_inst()) clone->Module_inst((module_inst*) obj);
  if (auto obj = Expr()) clone->Expr(obj->DeepClone(clone, context));
  if (auto vec = Expr_tchk_terms()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->Expr_tchk_terms(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Tchk_ref_term()) clone->Tchk_ref_term(obj->DeepClone(clone, context));
  if (auto obj = Tchk_data_term()) clone->Tchk_data_term(obj->DeepClone(clone, context));
  if (auto obj = Reg()) clone->Reg(obj->DeepClone(clone, context));
  if (auto vec = Attributes()) {
    auto clone_vec = context->m_serializer->MakeAttributeVec();
    clone->Attributes(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveTchk(clone, nullptr);
}

tchk* tchk::DeepClone(BaseClass* parent, CloneContext* context) const {
  tchk* const clone = context->m_serializer->MakeTchk();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t tchk::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->Module_inst(), rhs->Module_inst(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Expr(), rhs->Expr(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Expr_tchk_terms(), rhs, rhs->Expr_tchk_terms(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Tchk_ref_term(), rhs->Tchk_ref_term(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Tchk_data_term(), rhs->Tchk_data_term(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Reg(), rhs->Reg(), context)) != 0) return r;
  if ((r = lhs->VpiTchkType() - rhs->VpiTchkType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Attributes(), rhs, rhs->Attributes(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
