/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   tchk_term.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/tchk_term.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>


namespace UHDM {
const BaseClass* tchk_term::GetByVpiName(std::string_view name) const {
  if ((expr_ != nullptr) && (expr_->VpiName().compare(name) == 0)) {
    return expr_;
  }
  if ((condition_ != nullptr) && (condition_->VpiName().compare(name) == 0)) {
    return condition_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> tchk_term::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiCondition: return std::make_tuple(condition_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiExpr: return std::make_tuple(expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

tchk_term::vpi_property_value_t tchk_term::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiEdge: return vpi_property_value_t(VpiEdge());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void tchk_term::DeepCopy(tchk_term* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterTchk_term(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Expr()) clone->Expr(obj->DeepClone(clone, context));
  if (auto obj = Condition()) clone->Condition(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveTchk_term(clone, nullptr);
}

tchk_term* tchk_term::DeepClone(BaseClass* parent, CloneContext* context) const {
  tchk_term* const clone = context->m_serializer->MakeTchk_term();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t tchk_term::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->Expr(), rhs->Expr(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Condition(), rhs->Condition(), context)) != 0) return r;
  if ((r = lhs->VpiEdge() - rhs->VpiEdge()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  return r;
}

}  // namespace UHDM
