/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   tf_call.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/tf_call.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/scope.h>
#include <uhdm/tf_call_args.h>


namespace UHDM {
std::string_view tf_call::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool tf_call::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* tf_call::GetByVpiName(std::string_view name) const {
  if ((scope_ != nullptr) && (scope_->VpiName().compare(name) == 0)) {
    return scope_;
  }
  if (tf_call_args_ != nullptr) {
    for (const BaseClass *ref : *tf_call_args_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> tf_call::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiArgument: return std::make_tuple(nullptr, uhdmtf_call_args, (const std::vector<const BaseClass*>*)tf_call_args_);
    case vpiScope: return std::make_tuple(scope_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

tf_call::vpi_property_value_t tf_call::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void tf_call::DeepCopy(tf_call* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Scope()) clone->Scope(obj->DeepClone(clone, context));
  if (auto vec = Tf_call_args()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->Tf_call_args(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
}

int32_t tf_call::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->Scope(), rhs->Scope(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Tf_call_args(), rhs, rhs->Tf_call_args(), context)) != 0) return r;
  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  return r;
}

}  // namespace UHDM
