/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   type_parameter.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/type_parameter.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/ref_typespec.h>


namespace UHDM {
std::string_view type_parameter::VpiFullName() const {
  if (!vpiFullName_) {
    const std::string fullName = ComputeFullName();
    if (!fullName.empty()) {
      const_cast<type_parameter*>(this)->VpiFullName(fullName);
    }
  }
  return serializer_->GetSymbol(vpiFullName_);
}

bool type_parameter::VpiFullName(std::string_view data) {
  vpiFullName_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view type_parameter::VpiImported() const {
  return vpiImported_ ? serializer_->GetSymbol(vpiImported_) : kEmpty;
}

bool type_parameter::VpiImported(std::string_view data) {
  vpiImported_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* type_parameter::GetByVpiName(std::string_view name) const {
  if ((typespec_ != nullptr) && (typespec_->VpiName().compare(name) == 0)) {
    return typespec_;
  }
  if ((expr_ != nullptr) && (expr_->VpiName().compare(name) == 0)) {
    return expr_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> type_parameter::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiExpr: return std::make_tuple(expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiTypespec: return std::make_tuple(typespec_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

type_parameter::vpi_property_value_t type_parameter::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiFullName: {
      std::string_view fullname = VpiFullName();
      if (!fullname.empty() && (VpiName() != fullname)) {
        return vpi_property_value_t(fullname.data());
      }
    } break;
    case vpiImported: {
      std::string_view data = VpiImported();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiLocalParam: return vpi_property_value_t(VpiLocalParam());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void type_parameter::DeepCopy(type_parameter* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterType_parameter(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Typespec()) clone->Typespec(obj->DeepClone(clone, context));
  if (auto obj = Expr()) clone->Expr(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveType_parameter(clone, nullptr);
}

type_parameter* type_parameter::DeepClone(BaseClass* parent, CloneContext* context) const {
  ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  type_parameter* clone = any_cast<type_parameter*>(elaboratorContext->m_elaborator.bindParam(VpiName()));
  if (clone == nullptr) {
    clone = context->m_serializer->MakeType_parameter();
  }
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t type_parameter::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = (lhs->VpiLocalParam() == rhs->VpiLocalParam()) ? 0 : (lhs->VpiLocalParam() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Typespec(), rhs->Typespec(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Expr(), rhs->Expr(), context)) != 0) return r;
  if ((r = lhs->VpiImported().compare(rhs->VpiImported())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  return r;
}

}  // namespace UHDM
