/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   typespec_member.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/typespec_member.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>
#include <uhdm/ref_typespec.h>


namespace UHDM {
std::string_view typespec_member::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool typespec_member::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view typespec_member::VpiRefFile() const {
  return vpiRefFile_ ? serializer_->GetSymbol(vpiRefFile_) : kEmpty;
}

bool typespec_member::VpiRefFile(std::string_view data) {
  vpiRefFile_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* typespec_member::GetByVpiName(std::string_view name) const {
  if ((typespec_ != nullptr) && (typespec_->VpiName().compare(name) == 0)) {
    return typespec_;
  }
  if ((default_value_ != nullptr) && (default_value_->VpiName().compare(name) == 0)) {
    return default_value_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> typespec_member::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiExpr: return std::make_tuple(default_value_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiTypespec: return std::make_tuple(typespec_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

typespec_member::vpi_property_value_t typespec_member::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiRandType: return vpi_property_value_t(VpiRandType());
    case vpiRefColumnNo: return vpi_property_value_t(VpiRefColumnNo());
    case vpiRefEndColumnNo: return vpi_property_value_t(VpiRefEndColumnNo());
    case vpiRefEndLineNo: return vpi_property_value_t(VpiRefEndLineNo());
    case vpiRefFile: {
      std::string_view data = VpiRefFile();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiRefLineNo: return vpi_property_value_t(VpiRefLineNo());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void typespec_member::DeepCopy(typespec_member* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterTypespec_member(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Typespec()) clone->Typespec(obj->DeepClone(clone, context));
  if (auto obj = Default_value()) clone->Default_value(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveTypespec_member(clone, nullptr);
}

typespec_member* typespec_member::DeepClone(BaseClass* parent, CloneContext* context) const {
  typespec_member* const clone = context->m_serializer->MakeTypespec_member();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t typespec_member::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiRandType() == rhs->VpiRandType()) ? 0 : (lhs->VpiRandType() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Typespec(), rhs->Typespec(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Default_value(), rhs->Default_value(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
