/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   udp.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/udp.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/udp_defn.h>


namespace UHDM {
const BaseClass* udp::GetByVpiName(std::string_view name) const {
  if ((udp_defn_ != nullptr) && (udp_defn_->VpiName().compare(name) == 0)) {
    return udp_defn_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> udp::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiUdpDefn: return std::make_tuple(udp_defn_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

udp::vpi_property_value_t udp::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void udp::DeepCopy(udp* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterUdp(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (!clone->Udp_defn()) clone->Udp_defn((udp_defn*) elaboratorContext->m_elaborator.bindAny(VpiDefName()));
  if (!clone->Udp_defn()) clone->Udp_defn((udp_defn*) Udp_defn());
  elaboratorContext->m_elaborator.leaveUdp(clone, nullptr);
}

udp* udp::DeepClone(BaseClass* parent, CloneContext* context) const {
  udp* const clone = context->m_serializer->MakeUdp();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t udp::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->Udp_defn(), rhs->Udp_defn(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
