/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   udp_defn.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/udp_defn.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/attribute.h>
#include <uhdm/initial.h>
#include <uhdm/io_decl.h>
#include <uhdm/table_entry.h>


namespace UHDM {
std::string_view udp_defn::VpiDefName() const {
  return vpiDefName_ ? serializer_->GetSymbol(vpiDefName_) : kEmpty;
}

bool udp_defn::VpiDefName(std::string_view data) {
  vpiDefName_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* udp_defn::GetByVpiName(std::string_view name) const {
  if (attributes_ != nullptr) {
    for (const BaseClass *ref : *attributes_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (io_decls_ != nullptr) {
    for (const BaseClass *ref : *io_decls_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (table_entrys_ != nullptr) {
    for (const BaseClass *ref : *table_entrys_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((initial_ != nullptr) && (initial_->VpiName().compare(name) == 0)) {
    return initial_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> udp_defn::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiAttribute: return std::make_tuple(nullptr, uhdmattributes, (const std::vector<const BaseClass*>*)attributes_);
    case vpiIODecl: return std::make_tuple(nullptr, uhdmio_decls, (const std::vector<const BaseClass*>*)io_decls_);
    case vpiInitial: return std::make_tuple(initial_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiTableEntry: return std::make_tuple(nullptr, uhdmtable_entrys, (const std::vector<const BaseClass*>*)table_entrys_);
  }
  return basetype_t::GetByVpiType(type);
}

udp_defn::vpi_property_value_t udp_defn::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiDefName: {
      std::string_view data = VpiDefName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiPrimType: return vpi_property_value_t(VpiPrimType());
    case vpiProtected: return vpi_property_value_t(VpiProtected());
    case vpiSize: return vpi_property_value_t(VpiSize());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void udp_defn::DeepCopy(udp_defn* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterUdp_defn(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Attributes()) {
    auto clone_vec = context->m_serializer->MakeAttributeVec();
    clone->Attributes(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Io_decls()) {
    auto clone_vec = context->m_serializer->MakeIo_declVec();
    clone->Io_decls(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Table_entrys()) {
    auto clone_vec = context->m_serializer->MakeTable_entryVec();
    clone->Table_entrys(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Initial()) clone->Initial(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveUdp_defn(clone, nullptr);
}

udp_defn* udp_defn::DeepClone(BaseClass* parent, CloneContext* context) const {
  udp_defn* const clone = context->m_serializer->MakeUdp_defn();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t udp_defn::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiDefName().compare(rhs->VpiDefName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiSize() - rhs->VpiSize()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiProtected() == rhs->VpiProtected()) ? 0 : (lhs->VpiProtected() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiPrimType() - rhs->VpiPrimType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Attributes(), rhs, rhs->Attributes(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Io_decls(), rhs, rhs->Io_decls(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Table_entrys(), rhs, rhs->Table_entrys(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Initial(), rhs->Initial(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
