/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   union_var.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/union_var.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>
#include <uhdm/var_bit.h>
#include <uhdm/variables.h>


namespace UHDM {
const BaseClass* union_var::GetByVpiName(std::string_view name) const {
  if (var_bits_ != nullptr) {
    for (const BaseClass *ref : *var_bits_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (variables_ != nullptr) {
    for (const BaseClass *ref : *variables_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((expr_index_ != nullptr) && (expr_index_->VpiName().compare(name) == 0)) {
    return expr_index_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> union_var::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiBit: return std::make_tuple(nullptr, uhdmvar_bits, (const std::vector<const BaseClass*>*)var_bits_);
    case vpiIndex: return std::make_tuple(expr_index_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiMember: return std::make_tuple(nullptr, uhdmvariables, (const std::vector<const BaseClass*>*)variables_);
  }
  return basetype_t::GetByVpiType(type);
}

union_var::vpi_property_value_t union_var::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiConstantSelect: return vpi_property_value_t(VpiConstantSelect());
    case vpiPackedArrayMember: return vpi_property_value_t(VpiPackedArrayMember());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void union_var::DeepCopy(union_var* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterUnion_var(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Var_bits()) {
    auto clone_vec = context->m_serializer->MakeVar_bitVec();
    clone->Var_bits(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Variables()) {
    auto clone_vec = context->m_serializer->MakeVariablesVec();
    clone->Variables(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Expr_index()) clone->Expr_index(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveUnion_var(clone, nullptr);
}

union_var* union_var::DeepClone(BaseClass* parent, CloneContext* context) const {
  union_var* const clone = context->m_serializer->MakeUnion_var();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t union_var::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = (lhs->VpiPackedArrayMember() == rhs->VpiPackedArrayMember()) ? 0 : (lhs->VpiPackedArrayMember() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiConstantSelect() == rhs->VpiConstantSelect()) ? 0 : (lhs->VpiConstantSelect() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Var_bits(), rhs, rhs->Var_bits(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Variables(), rhs, rhs->Variables(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Expr_index(), rhs->Expr_index(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
