/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   var_bit.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/var_bit.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>


namespace UHDM {
const BaseClass* var_bit::GetByVpiName(std::string_view name) const {
  if ((expr_index_ != nullptr) && (expr_index_->VpiName().compare(name) == 0)) {
    return expr_index_;
  }
  if (expr_indexes_ != nullptr) {
    for (const BaseClass *ref : *expr_indexes_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> var_bit::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiIndex: return std::make_tuple(expr_index_, uhdmexpr_indexes, (const std::vector<const BaseClass*>*)expr_indexes_);
  }
  return basetype_t::GetByVpiType(type);
}

var_bit::vpi_property_value_t var_bit::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiConstantSelect: return vpi_property_value_t(VpiConstantSelect());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void var_bit::DeepCopy(var_bit* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterVar_bit(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Expr_index()) clone->Expr_index(obj->DeepClone(clone, context));
  if (auto vec = Expr_indexes()) {
    auto clone_vec = context->m_serializer->MakeExprVec();
    clone->Expr_indexes(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveVar_bit(clone, nullptr);
}

var_bit* var_bit::DeepClone(BaseClass* parent, CloneContext* context) const {
  var_bit* const clone = context->m_serializer->MakeVar_bit();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t var_bit::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = (lhs->VpiConstantSelect() == rhs->VpiConstantSelect()) ? 0 : (lhs->VpiConstantSelect() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Expr_index(), rhs->Expr_index(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Expr_indexes(), rhs, rhs->Expr_indexes(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
