/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   var_select.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/var_select.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>
#include <uhdm/net.h>


namespace UHDM {
const BaseClass* var_select::GetByVpiName(std::string_view name) const {
  if ((expr_ != nullptr) && (expr_->VpiName().compare(name) == 0)) {
    return expr_;
  }
  if (exprs_ != nullptr) {
    for (const BaseClass *ref : *exprs_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> var_select::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiIndex: return std::make_tuple(expr_, uhdmexprs, (const std::vector<const BaseClass*>*)exprs_);
  }
  return basetype_t::GetByVpiType(type);
}

var_select::vpi_property_value_t var_select::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiConstantSelect: return vpi_property_value_t(VpiConstantSelect());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void var_select::DeepCopy(var_select* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterVar_select(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (any* n = elaboratorContext->m_elaborator.bindNet(VpiName())) {
    if (net* nn = any_cast<net*>(n))
      clone->VpiFullName(nn->VpiFullName());
  }
  if (auto obj = Expr()) clone->Expr(obj->DeepClone(clone, context));
  if (auto vec = Exprs()) {
    auto clone_vec = context->m_serializer->MakeExprVec();
    clone->Exprs(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveVar_select(clone, nullptr);
}

var_select* var_select::DeepClone(BaseClass* parent, CloneContext* context) const {
  var_select* const clone = context->m_serializer->MakeVar_select();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t var_select::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = (lhs->VpiConstantSelect() == rhs->VpiConstantSelect()) ? 0 : (lhs->VpiConstantSelect() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Expr(), rhs->Expr(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Exprs(), rhs, rhs->Exprs(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
