/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   variable_drivers_group.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */
#include <uhdm/variable_drivers_group.h>

#include <iostream>
#include <uhdm/uhdm.h>

namespace UHDM {
bool variable_drivers_groupGroupCompliant(const any* item) {
  if (item == nullptr) {
    return true;
  }
  UHDM_OBJECT_TYPE uhdmtype = item->UhdmType();
  if ((uhdmtype != uhdmassign_stmt) &&
      (uhdmtype != uhdmchecker_port) &&
      (uhdmtype != uhdmcont_assign) &&
      (uhdmtype != uhdmcont_assign_bit) &&
      (uhdmtype != uhdmforce) &&
      (uhdmtype != uhdmport) &&
      (uhdmtype != uhdmport_bit) &&
      (uhdmtype != uhdmports)) {
    item->GetSerializer()->GetErrorHandler()(ErrorType::UHDM_WRONG_OBJECT_TYPE, "Internal Error: adding wrong object type (" + UhdmName(uhdmtype) + ") in a variable_drivers_group group!", item, nullptr);
    return false;
  }
  return true;
}

bool variable_drivers_groupGroupCompliant(const VectorOfany* vec) {
  if (vec != nullptr) {
    for (auto item : *vec) {
      if (!variable_drivers_groupGroupCompliant(item)) {
        return false;
      }
    }
  }
  return true;
}

}  // namespace UHDM
