/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   variables.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/variables.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/attribute.h>
#include <uhdm/cont_assign.h>
#include <uhdm/expr.h>
#include <uhdm/instance.h>
#include <uhdm/module_inst.h>
#include <uhdm/path_term.h>
#include <uhdm/ports.h>
#include <uhdm/prim_term.h>
#include <uhdm/scope.h>
#include <uhdm/tchk_term.h>
#include <uhdm/variable_drivers_group.h>
#include <uhdm/variable_loads_group.h>


namespace UHDM {
std::string_view variables::VpiName() const {
  return vpiName_ ? serializer_->GetSymbol(vpiName_) : kEmpty;
}

bool variables::VpiName(std::string_view data) {
  vpiName_ = serializer_->MakeSymbol(data);
  return true;
}

std::string_view variables::VpiFullName() const {
  if (!vpiFullName_) {
    const std::string fullName = ComputeFullName();
    if (!fullName.empty()) {
      const_cast<variables*>(this)->VpiFullName(fullName);
    }
  }
  return serializer_->GetSymbol(vpiFullName_);
}

bool variables::VpiFullName(std::string_view data) {
  vpiFullName_ = serializer_->MakeSymbol(data);
  return true;
}

const BaseClass* variables::GetByVpiName(std::string_view name) const {
  if (ports_ != nullptr) {
    for (const BaseClass *ref : *ports_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (variable_drivers_ != nullptr) {
    for (const BaseClass *ref : *variable_drivers_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (variable_loads_ != nullptr) {
    for (const BaseClass *ref : *variable_loads_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (prim_terms_ != nullptr) {
    for (const BaseClass *ref : *prim_terms_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (cont_assigns_ != nullptr) {
    for (const BaseClass *ref : *cont_assigns_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((path_term_ != nullptr) && (path_term_->VpiName().compare(name) == 0)) {
    return path_term_;
  }
  if ((tchk_term_ != nullptr) && (tchk_term_->VpiName().compare(name) == 0)) {
    return tchk_term_;
  }
  if ((module_inst_ != nullptr) && (module_inst_->VpiName().compare(name) == 0)) {
    return module_inst_;
  }
  if ((instance_ != nullptr) && (instance_->VpiName().compare(name) == 0)) {
    return instance_;
  }
  if ((scope_ != nullptr) && (scope_->VpiName().compare(name) == 0)) {
    return scope_;
  }
  if ((expr_ != nullptr) && (expr_->VpiName().compare(name) == 0)) {
    return expr_;
  }
  if (indexes_ != nullptr) {
    for (const BaseClass *ref : *indexes_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (attributes_ != nullptr) {
    for (const BaseClass *ref : *attributes_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> variables::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiAttribute: return std::make_tuple(nullptr, uhdmattributes, (const std::vector<const BaseClass*>*)attributes_);
    case vpiContAssign: return std::make_tuple(nullptr, uhdmcont_assigns, (const std::vector<const BaseClass*>*)cont_assigns_);
    case vpiDriver: return std::make_tuple(nullptr, uhdmvariable_drivers, (const std::vector<const BaseClass*>*)variable_drivers_);
    case vpiExpr: return std::make_tuple(expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiIndex: return std::make_tuple(nullptr, uhdmindexes, (const std::vector<const BaseClass*>*)indexes_);
    case vpiInstance: return std::make_tuple(instance_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiLoad: return std::make_tuple(nullptr, uhdmvariable_loads, (const std::vector<const BaseClass*>*)variable_loads_);
    case vpiModule: return std::make_tuple(module_inst_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiPathTerm: return std::make_tuple(path_term_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiPortInst: return std::make_tuple(nullptr, uhdmports, (const std::vector<const BaseClass*>*)ports_);
    case vpiPrimTerm: return std::make_tuple(nullptr, uhdmprim_terms, (const std::vector<const BaseClass*>*)prim_terms_);
    case vpiScope: return std::make_tuple(scope_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiTchkTerm: return std::make_tuple(tchk_term_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

variables::vpi_property_value_t variables::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiAllocScheme: return vpi_property_value_t(VpiAllocScheme());
    case vpiArrayMember: return vpi_property_value_t(VpiArrayMember());
    case vpiAutomatic: return vpi_property_value_t(VpiAutomatic());
    case vpiConstantVariable: return vpi_property_value_t(VpiConstantVariable());
    case vpiFullName: {
      std::string_view fullname = VpiFullName();
      if (!fullname.empty() && (VpiName() != fullname)) {
        return vpi_property_value_t(fullname.data());
      }
    } break;
    case vpiIsRandomized: return vpi_property_value_t(VpiIsRandomized());
    case vpiName: {
      std::string_view data = VpiName();
      if (!data.empty()) return vpi_property_value_t(data.data());
    } break;
    case vpiRandType: return vpi_property_value_t(VpiRandType());
    case vpiScalar: return vpi_property_value_t(VpiScalar());
    case vpiSigned: return vpi_property_value_t(VpiSigned());
    case vpiStructUnionMember: return vpi_property_value_t(VpiStructUnionMember());
    case vpiVector: return vpi_property_value_t(VpiVector());
    case vpiVisibility: return vpi_property_value_t(VpiVisibility());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void variables::DeepCopy(variables* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Ports()) {
    auto clone_vec = context->m_serializer->MakePortsVec();
    clone->Ports(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Variable_drivers()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->Variable_drivers(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Variable_loads()) {
    auto clone_vec = context->m_serializer->MakeAnyVec();
    clone->Variable_loads(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Prim_terms()) {
    auto clone_vec = context->m_serializer->MakePrim_termVec();
    clone->Prim_terms(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Cont_assigns()) {
    auto clone_vec = context->m_serializer->MakeCont_assignVec();
    clone->Cont_assigns(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Path_term()) clone->Path_term(obj->DeepClone(clone, context));
  if (auto obj = Tchk_term()) clone->Tchk_term(obj->DeepClone(clone, context));
  if (auto obj = Module_inst()) clone->Module_inst((module_inst*) obj);
  if (auto obj = Instance()) clone->Instance((instance*) obj);
  if (instance* inst = any_cast<instance*>(parent))
    clone->Instance(inst);
  if (auto obj = Scope()) clone->Scope(obj->DeepClone(clone, context));
  if (auto obj = Expr()) clone->Expr(obj->DeepClone(clone, context));
  if (auto vec = Indexes()) {
    auto clone_vec = context->m_serializer->MakeExprVec();
    clone->Indexes(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Attributes()) {
    auto clone_vec = context->m_serializer->MakeAttributeVec();
    clone->Attributes(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
}

int32_t variables::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = (lhs->VpiArrayMember() == rhs->VpiArrayMember()) ? 0 : (lhs->VpiArrayMember() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiName().compare(rhs->VpiName())) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiSigned() == rhs->VpiSigned()) ? 0 : (lhs->VpiSigned() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiAutomatic() == rhs->VpiAutomatic()) ? 0 : (lhs->VpiAutomatic() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiAllocScheme() - rhs->VpiAllocScheme()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiConstantVariable() == rhs->VpiConstantVariable()) ? 0 : (lhs->VpiConstantVariable() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiIsRandomized() == rhs->VpiIsRandomized()) ? 0 : (lhs->VpiIsRandomized() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiRandType() - rhs->VpiRandType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiStructUnionMember() == rhs->VpiStructUnionMember()) ? 0 : (lhs->VpiStructUnionMember() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiScalar() == rhs->VpiScalar()) ? 0 : (lhs->VpiScalar() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = lhs->VpiVisibility() - rhs->VpiVisibility()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiVector() == rhs->VpiVector()) ? 0 : (lhs->VpiVector() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Ports(), rhs, rhs->Ports(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Variable_drivers(), rhs, rhs->Variable_drivers(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Variable_loads(), rhs, rhs->Variable_loads(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Prim_terms(), rhs, rhs->Prim_terms(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Cont_assigns(), rhs, rhs->Cont_assigns(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Path_term(), rhs->Path_term(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Tchk_term(), rhs->Tchk_term(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Module_inst(), rhs->Module_inst(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Instance(), rhs->Instance(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Scope(), rhs->Scope(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Expr(), rhs->Expr(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Indexes(), rhs, rhs->Indexes(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Attributes(), rhs, rhs->Attributes(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
