/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   vpi_user.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */
#include <uhdm/sv_vpi_user.h>
#include <uhdm/vhpi_user.h>

#include <cctype>
#include <cstring>
#include <iostream>
#include <string>
#include <string_view>
#include <vector>

#include <uhdm/NumUtils.h>
#include <uhdm/Serializer.h>
#include <uhdm/containers.h>
#include <uhdm/uhdm.h>
#include <uhdm/uhdm_types.h>
#include <uhdm/vpi_uhdm.h>

#include <uhdm/array_expr.h>
#include <uhdm/array_net.h>
#include <uhdm/array_var.h>
#include <uhdm/attribute.h>
#include <uhdm/bit_select.h>
#include <uhdm/bit_var.h>
#include <uhdm/byte_var.h>
#include <uhdm/chandle_var.h>
#include <uhdm/class_var.h>
#include <uhdm/constant.h>
#include <uhdm/cont_assign.h>
#include <uhdm/cont_assign_bit.h>
#include <uhdm/delay_control.h>
#include <uhdm/enum_const.h>
#include <uhdm/enum_net.h>
#include <uhdm/enum_var.h>
#include <uhdm/func_call.h>
#include <uhdm/gate.h>
#include <uhdm/hier_path.h>
#include <uhdm/indexed_part_select.h>
#include <uhdm/int_typespec.h>
#include <uhdm/int_var.h>
#include <uhdm/integer_net.h>
#include <uhdm/integer_typespec.h>
#include <uhdm/integer_var.h>
#include <uhdm/let_expr.h>
#include <uhdm/logic_net.h>
#include <uhdm/logic_var.h>
#include <uhdm/long_int_var.h>
#include <uhdm/method_func_call.h>
#include <uhdm/method_task_call.h>
#include <uhdm/net_bit.h>
#include <uhdm/operation.h>
#include <uhdm/packed_array_net.h>
#include <uhdm/packed_array_var.h>
#include <uhdm/parameter.h>
#include <uhdm/part_select.h>
#include <uhdm/prim_term.h>
#include <uhdm/real_var.h>
#include <uhdm/ref_obj.h>
#include <uhdm/ref_typespec.h>
#include <uhdm/ref_var.h>
#include <uhdm/short_int_var.h>
#include <uhdm/short_real_var.h>
#include <uhdm/spec_param.h>
#include <uhdm/string_var.h>
#include <uhdm/struct_net.h>
#include <uhdm/struct_var.h>
#include <uhdm/switch_tran.h>
#include <uhdm/sys_func_call.h>
#include <uhdm/sys_task_call.h>
#include <uhdm/table_entry.h>
#include <uhdm/task_call.h>
#include <uhdm/tchk.h>
#include <uhdm/time_net.h>
#include <uhdm/time_var.h>
#include <uhdm/udp.h>
#include <uhdm/union_var.h>
#include <uhdm/unsupported_expr.h>
#include <uhdm/unsupported_stmt.h>
#include <uhdm/var_bit.h>
#include <uhdm/var_select.h>

using namespace UHDM;

static char* StrClone(std::string_view sv) {
  char* clone = new char[sv.length() + 1];
  std::memcpy(clone, sv.data(), sv.length());
  clone[sv.length()] = '\0';
  return clone;
}

static int32_t StriCmp(std::string_view lhs, std::string_view rhs) {
  for (size_t i = 0, n = std::min(lhs.length(), rhs.length()); i < n; ++i) {
    int32_t lc = std::tolower((int32_t)lhs[i]);
    int32_t rc = std::tolower((int32_t)rhs[i]);
    if (lc != rc) return (lc < rc) ? -1 : +1;
  }

  return (lhs.length() == rhs.length())
    ? 0
    : ((lhs.length() < rhs.length()) ? -1 : +1);
}

UHDM::design* UhdmDesignFromVpiHandle(vpiHandle hdesign) {
  if (!hdesign) return nullptr;
  UHDM::any* tmp = (UHDM::any*)((uhdm_handle*)hdesign)->object;
  if (tmp->UhdmType() == UHDM_OBJECT_TYPE::uhdmdesign)
    return (UHDM::design*)tmp;
  else
    return nullptr;
}

s_vpi_value* String2VpiValue(std::string_view sv) {
  while (!sv.empty() && isspace(sv.front())) sv.remove_prefix(1);
  s_vpi_value* val = new s_vpi_value;
  val->format = 0;
  val->value.integer = 0;
  val->value.scalar = 0;
  val->value.str = nullptr;
  if (sv.find("UINT:") == 0) {
    val->format = vpiUIntVal;
    sv.remove_prefix(std::string_view("UINT:").length());
    if (NumUtils::parseUint64(sv, &val->value.uint) == nullptr) {
      val->value.uint = 0;
    }
  } else if (sv.find("INT:") == 0) {
    val->format = vpiIntVal;
    sv.remove_prefix(std::string_view("INT:").length());
    if (NumUtils::parseInt64(sv, &val->value.integer) == nullptr) {
      val->value.integer = 0;
    }
  } else if (sv.find("SCAL:") == 0) {
    val->format = vpiScalarVal;
    sv.remove_prefix(std::string_view("SCAL:").length());
    switch (sv.front()) {
      case 'Z': val->value.scalar = vpiZ; break;
      case 'X': val->value.scalar = vpiX; break;
      case 'H': val->value.scalar = vpiH; break;
      case 'L': val->value.scalar = vpiL; break;
        // Not really clear what the difference between X and DontCare is.
        // Let's parse 'W'eak don't care as this one.
      case 'W': val->value.scalar = vpiDontCare; break;
      default: {
        if (StriCmp(sv, std::string_view("DontCare")) == 0) {
          val->value.scalar = vpiDontCare;
        } else if (StriCmp(sv, std::string_view("NoChange")) == 0) {
          val->value.scalar = vpiNoChange;
        } else {
          // Maybe written numerically?
          if (NumUtils::parseInt32(sv, &val->value.scalar) == nullptr) {
            val->value.scalar = 0;
          }
        }
      } break;
    }
  } else if (sv.find("BIN:") == 0) {
    val->format = vpiBinStrVal;
    sv.remove_prefix(std::string_view("BIN:").length());
    val->value.str = StrClone(sv);
  } else if (sv.find("HEX:") == 0) {
    val->format = vpiHexStrVal;
    sv.remove_prefix(std::string_view("HEX:").length());
    val->value.str = StrClone(sv);
  } else if (sv.find("OCT:") == 0) {
    val->format = vpiOctStrVal;
    sv.remove_prefix(std::string_view("OCT:").length());
    val->value.str = StrClone(sv);
  } else if (sv.find("STRING:") == 0) {
    val->format = vpiStringVal;
    sv.remove_prefix(std::string_view("STRING:").length());
    val->value.str = StrClone(sv);
  } else if (sv.find("REAL:") == 0) {
    val->format = vpiRealVal;
    sv.remove_prefix(std::string_view("REAL:").length());
    if (NumUtils::parseDouble(sv, &val->value.real) == nullptr) {
      val->value.real = 0;
    }
  } else if (sv.find("DEC:") == 0) {
    val->format = vpiDecStrVal;
    sv.remove_prefix(std::string_view("DEC:").length());
    val->value.str = StrClone(sv);
  }

  return val;
}

s_vpi_delay* String2VpiDelays(std::string_view sv) {
  while (!sv.empty() && isspace(sv.front())) sv.remove_prefix(1);
  s_vpi_delay* delay = new s_vpi_delay;
  delay->da = nullptr;
  if (!sv.empty() && (sv.front() == '#')) {
    delay->da = new t_vpi_time;
    delay->no_of_delays = 1;
    delay->time_type = vpiScaledRealTime;
    sv.remove_prefix(1);
    if (NumUtils::parseUint32(sv, &delay->da[0].low) == nullptr) {
      delay->da[0].low = 0;
    }
    delay->da[0].type = vpiScaledRealTime;
  }
  return delay;
}

std::string VpiValue2String(const s_vpi_value* value) {
  static constexpr std::string_view kIntPrefix("INT:");
  static constexpr std::string_view kUIntPrefix("UINT:");
  static constexpr std::string_view kScalPrefix("SCAL:");
  static constexpr std::string_view kStrPrefix("STRING:");
  static constexpr std::string_view kHexPrefix("HEX:");
  static constexpr std::string_view kOctPrefix("OCT:");
  static constexpr std::string_view kBinPrefix("BIN:");
  static constexpr std::string_view kRealPrefix("REAL:");
  static constexpr std::string_view kDecPrefix("DEC:");

  if (!value) return "";
  switch (value->format) {
    case vpiIntVal: return std::string(kIntPrefix).append(std::to_string(value->value.integer));
    case vpiUIntVal: return std::string(kUIntPrefix).append(std::to_string(value->value.uint));
    case vpiScalarVal: {
      switch (value->value.scalar) {
        case vpi0: return "SCAL:0";
        case vpi1: return "SCAL:1";
        case vpiZ: return "SCAL:Z";
        case vpiX: return "SCAL:X";
        case vpiH: return "SCAL:H";
        case vpiL: return "SCAL:L";
        case vpiDontCare: return "SCAL:DontCare";
        case vpiNoChange: return "SCAL:NoChange";
        default:
          // mmh, some unknown number.
          return std::string(kScalPrefix).append(std::to_string(value->value.scalar));
      }
    }
    case vpiStringVal: return std::string(kStrPrefix).append(value->value.str);
    case vpiHexStrVal: return std::string(kHexPrefix).append(value->value.str);
    case vpiOctStrVal: return std::string(kOctPrefix).append(value->value.str);
    case vpiBinStrVal: return std::string(kBinPrefix).append(value->value.str);
    case vpiDecStrVal: return std::string(kDecPrefix).append(value->value.str);
    case vpiRealVal: return std::string(kRealPrefix) .append(std::to_string(value->value.real));
  }

  return "";
}

std::string VpiDelay2String(const s_vpi_delay* delay) {
  std::string result;
  if (delay == nullptr) return result;
  if (delay->da == nullptr) return result;
  switch (delay->time_type) {
    case vpiScaledRealTime: {
      result.append("#").append(std::to_string(delay->da[0].low));
      break;
    }
    default:
      break;
  }
  return result;
}

vpiHandle NewVpiHandle(const UHDM::BaseClass* object) {
  return reinterpret_cast<vpiHandle>(
      new uhdm_handle(object->UhdmType(), object));
}

static vpiHandle NewHandle(UHDM_OBJECT_TYPE type, const void* object) {
  return reinterpret_cast<vpiHandle>(new uhdm_handle(type, object));
}

vpiHandle vpi_handle_by_index(vpiHandle object, PLI_INT32 indx) { return 0; }

vpiHandle vpi_handle_by_name(PLI_BYTE8* name, vpiHandle refHandle) {
  const uhdm_handle* const handle = (const uhdm_handle*)refHandle;
  const BaseClass* const object = (const BaseClass*)handle->object;
  if (object->GetSerializer()->GetSymbolId(name) ==
      SymbolFactory::getBadId()) {
    return nullptr;
  }
  const BaseClass *const ref = object->GetByVpiName(std::string_view(name));
  return (ref != nullptr) ? NewVpiHandle(ref) : nullptr;
}

vpiHandle vpi_handle(PLI_INT32 type, vpiHandle refHandle) {
  const uhdm_handle* const handle = (const uhdm_handle*)refHandle;
  const BaseClass* const object = (const BaseClass*)handle->object;
  auto [ref, ignored1, ignored2] = object->GetByVpiType(type);
  return (ref != nullptr) ? NewHandle(ref->UhdmType(), ref) : nullptr;
}

vpiHandle vpi_handle_multi(PLI_INT32 type, vpiHandle refHandle1,
                           vpiHandle refHandle2, ...) {
  return 0;
}

/* for traversing relationships */

vpiHandle vpi_iterate(PLI_INT32 type, vpiHandle refHandle) {
  const uhdm_handle* const handle = (const uhdm_handle*)refHandle;
  const BaseClass* const object = (const BaseClass*)handle->object;
  auto [ignored, refType, refVector] = object->GetByVpiType(type);
  return (refVector != nullptr) ? NewHandle(refType, refVector) : nullptr;
}

PLI_INT32 vpi_compare_objects(vpiHandle handle1, vpiHandle handle2) {
  const BaseClass* const object1 =
      (const BaseClass*)((const uhdm_handle*)handle1)->object;
  const BaseClass* const object2 =
      (const BaseClass*)((const uhdm_handle*)handle2)->object;
  // NOTE: As per the standard, this API is expected to return a 1 for equal.
  // And, yes that is counter intuitive. But BaseClass::Compare returns a 0
  // for equal. Negate the result here to meet standard requirements.
  CompareContext context;
  return (object1 == object2) ? 1 : ((object1->Compare(object2, &context) == 0) ? 1 : 0);
}

vpiHandle vpi_scan(vpiHandle iterator) {
  if (!iterator) return 0;
  uhdm_handle* handle = (uhdm_handle*)iterator;
  const std::vector<const BaseClass*>* vect =
      (const std::vector<const BaseClass*>*)handle->object;
  if (handle->index < vect->size()) {
    const BaseClass* const object = vect->at(handle->index);
    uhdm_handle* h = new uhdm_handle(object->UhdmType(), object);
    ++handle->index;
    return (vpiHandle) h;
  }
  return nullptr;
}

PLI_INT32 vpi_free_object(vpiHandle object) {
  return vpi_release_handle(object);
}

PLI_INT32 vpi_release_handle(vpiHandle object) {
  delete (uhdm_handle*)object;
  return 0;
}

/* for processing properties */

PLI_INT32 vpi_get(PLI_INT32 property, vpiHandle object) {
  if (!object) {
    std::cout << "VPI ERROR: Bad usage of vpi_get" << std::endl;
    return 0;
  }

  // At this point, the implementation is exactly the same as for 64 bit,
  // but we truncate.
  return (PLI_INT32)vpi_get64(property, object);
}

PLI_INT64 vpi_get64(PLI_INT32 property, vpiHandle object) {
  if (!object) {
    std::cout << "VPI ERROR: Bad usage of vpi_get64" << std::endl;
    return 0;
  }

  const uhdm_handle* const handle = (const uhdm_handle*)object;
  const BaseClass* const obj = (const BaseClass*)handle->object;
  BaseClass::vpi_property_value_t value = obj->GetVpiPropertyValue(property);
  return std::holds_alternative<int64_t>(value) ? std::get<int64_t>(value) : 0;
}

PLI_BYTE8* vpi_get_str(PLI_INT32 property, vpiHandle object) {
  if (!object) {
    std::cout << "VPI ERROR: Bad usage of vpi_get_str" << std::endl;
    return 0;
  }
  const uhdm_handle* const handle = (const uhdm_handle*)object;
  const BaseClass* const obj = (const BaseClass*)handle->object;
  BaseClass::vpi_property_value_t value = obj->GetVpiPropertyValue(property);
  return std::holds_alternative<const char *>(value)
      ? const_cast<char *>(std::get<const char *>(value))
      : nullptr;
}

/* delay processing */

void vpi_get_delays(vpiHandle object, p_vpi_delay delay_p) {
  delay_p->da = nullptr;
  if (!object) {
    std::cout << "VPI ERROR: Bad usage of vpi_get_delay" << std::endl;
    return;
  }
  const uhdm_handle* const handle = (const uhdm_handle*)object;
  const BaseClass* const obj = (const BaseClass*)handle->object;
  const s_vpi_delay* v = nullptr;
  switch (handle->type) {
    case uhdmdelay_control: v = String2VpiDelays(((delay_control*)obj)->VpiDelay()); break;
    case uhdmgate: v = String2VpiDelays(((gate*)obj)->VpiDelay()); break;
    case uhdmswitch_tran: v = String2VpiDelays(((switch_tran*)obj)->VpiDelay()); break;
    case uhdmtchk: v = String2VpiDelays(((tchk*)obj)->VpiDelay()); break;
    case uhdmudp: v = String2VpiDelays(((udp*)obj)->VpiDelay()); break;
    default: break;
  }
  if (v != nullptr) *delay_p = *v;
}

void vpi_put_delays(vpiHandle object, p_vpi_delay delay_p) {}

/* value processing */

void vpi_get_value(vpiHandle vexpr, p_vpi_value value_p) {
  value_p->format = 0;
  if (!vexpr) {
    std::cout << "VPI ERROR: Bad usage of vpi_get_value" << std::endl;
    return;
  }
  const uhdm_handle* const handle = (const uhdm_handle*)vexpr;
  const BaseClass* const obj = (const BaseClass*)handle->object;
  const s_vpi_value* v = nullptr;
  switch (handle->type) {
    case uhdmarray_expr: v = String2VpiValue(((array_expr*)obj)->VpiValue()); break;
    case uhdmarray_net: v = String2VpiValue(((array_net*)obj)->VpiValue()); break;
    case uhdmarray_var: v = String2VpiValue(((array_var*)obj)->VpiValue()); break;
    case uhdmattribute: v = String2VpiValue(((attribute*)obj)->VpiValue()); break;
    case uhdmbit_select: v = String2VpiValue(((bit_select*)obj)->VpiValue()); break;
    case uhdmbit_var: v = String2VpiValue(((bit_var*)obj)->VpiValue()); break;
    case uhdmbyte_var: v = String2VpiValue(((byte_var*)obj)->VpiValue()); break;
    case uhdmchandle_var: v = String2VpiValue(((chandle_var*)obj)->VpiValue()); break;
    case uhdmclass_var: v = String2VpiValue(((class_var*)obj)->VpiValue()); break;
    case uhdmconstant: v = String2VpiValue(((constant*)obj)->VpiValue()); break;
    case uhdmcont_assign: v = String2VpiValue(((cont_assign*)obj)->VpiValue()); break;
    case uhdmcont_assign_bit: v = String2VpiValue(((cont_assign_bit*)obj)->VpiValue()); break;
    case uhdmenum_const: v = String2VpiValue(((enum_const*)obj)->VpiValue()); break;
    case uhdmenum_net: v = String2VpiValue(((enum_net*)obj)->VpiValue()); break;
    case uhdmenum_var: v = String2VpiValue(((enum_var*)obj)->VpiValue()); break;
    case uhdmfunc_call: v = String2VpiValue(((func_call*)obj)->VpiValue()); break;
    case uhdmgate: v = String2VpiValue(((gate*)obj)->VpiValue()); break;
    case uhdmhier_path: v = String2VpiValue(((hier_path*)obj)->VpiValue()); break;
    case uhdmindexed_part_select: v = String2VpiValue(((indexed_part_select*)obj)->VpiValue()); break;
    case uhdmint_typespec: v = String2VpiValue(((int_typespec*)obj)->VpiValue()); break;
    case uhdmint_var: v = String2VpiValue(((int_var*)obj)->VpiValue()); break;
    case uhdminteger_net: v = String2VpiValue(((integer_net*)obj)->VpiValue()); break;
    case uhdminteger_typespec: v = String2VpiValue(((integer_typespec*)obj)->VpiValue()); break;
    case uhdminteger_var: v = String2VpiValue(((integer_var*)obj)->VpiValue()); break;
    case uhdmlet_expr: v = String2VpiValue(((let_expr*)obj)->VpiValue()); break;
    case uhdmlogic_net: v = String2VpiValue(((logic_net*)obj)->VpiValue()); break;
    case uhdmlogic_var: v = String2VpiValue(((logic_var*)obj)->VpiValue()); break;
    case uhdmlong_int_var: v = String2VpiValue(((long_int_var*)obj)->VpiValue()); break;
    case uhdmmethod_func_call: v = String2VpiValue(((method_func_call*)obj)->VpiValue()); break;
    case uhdmmethod_task_call: v = String2VpiValue(((method_task_call*)obj)->VpiValue()); break;
    case uhdmnet_bit: v = String2VpiValue(((net_bit*)obj)->VpiValue()); break;
    case uhdmoperation: v = String2VpiValue(((operation*)obj)->VpiValue()); break;
    case uhdmpacked_array_net: v = String2VpiValue(((packed_array_net*)obj)->VpiValue()); break;
    case uhdmpacked_array_var: v = String2VpiValue(((packed_array_var*)obj)->VpiValue()); break;
    case uhdmparameter: v = String2VpiValue(((parameter*)obj)->VpiValue()); break;
    case uhdmpart_select: v = String2VpiValue(((part_select*)obj)->VpiValue()); break;
    case uhdmprim_term: v = String2VpiValue(((prim_term*)obj)->VpiValue()); break;
    case uhdmreal_var: v = String2VpiValue(((real_var*)obj)->VpiValue()); break;
    case uhdmref_obj: v = String2VpiValue(((ref_obj*)obj)->VpiValue()); break;
    case uhdmref_typespec: v = String2VpiValue(((ref_typespec*)obj)->VpiValue()); break;
    case uhdmref_var: v = String2VpiValue(((ref_var*)obj)->VpiValue()); break;
    case uhdmshort_int_var: v = String2VpiValue(((short_int_var*)obj)->VpiValue()); break;
    case uhdmshort_real_var: v = String2VpiValue(((short_real_var*)obj)->VpiValue()); break;
    case uhdmspec_param: v = String2VpiValue(((spec_param*)obj)->VpiValue()); break;
    case uhdmstring_var: v = String2VpiValue(((string_var*)obj)->VpiValue()); break;
    case uhdmstruct_net: v = String2VpiValue(((struct_net*)obj)->VpiValue()); break;
    case uhdmstruct_var: v = String2VpiValue(((struct_var*)obj)->VpiValue()); break;
    case uhdmswitch_tran: v = String2VpiValue(((switch_tran*)obj)->VpiValue()); break;
    case uhdmsys_func_call: v = String2VpiValue(((sys_func_call*)obj)->VpiValue()); break;
    case uhdmsys_task_call: v = String2VpiValue(((sys_task_call*)obj)->VpiValue()); break;
    case uhdmtable_entry: v = String2VpiValue(((table_entry*)obj)->VpiValue()); break;
    case uhdmtask_call: v = String2VpiValue(((task_call*)obj)->VpiValue()); break;
    case uhdmtime_net: v = String2VpiValue(((time_net*)obj)->VpiValue()); break;
    case uhdmtime_var: v = String2VpiValue(((time_var*)obj)->VpiValue()); break;
    case uhdmudp: v = String2VpiValue(((udp*)obj)->VpiValue()); break;
    case uhdmunion_var: v = String2VpiValue(((union_var*)obj)->VpiValue()); break;
    case uhdmunsupported_expr: v = String2VpiValue(((unsupported_expr*)obj)->VpiValue()); break;
    case uhdmunsupported_stmt: v = String2VpiValue(((unsupported_stmt*)obj)->VpiValue()); break;
    case uhdmvar_bit: v = String2VpiValue(((var_bit*)obj)->VpiValue()); break;
    case uhdmvar_select: v = String2VpiValue(((var_select*)obj)->VpiValue()); break;
    default: break;
  }
  if (v != nullptr) *value_p = *v;
}

vpiHandle vpi_put_value(vpiHandle object, p_vpi_value value_p,
                        p_vpi_time time_p, PLI_INT32 flags) {
  return 0;
}

void vpi_get_value_array(vpiHandle object, p_vpi_arrayvalue arrayvalue_p,
                         PLI_INT32* index_p, PLI_UINT32 num) {}

void vpi_put_value_array(vpiHandle object, p_vpi_arrayvalue arrayvalue_p,
                         PLI_INT32* index_p, PLI_UINT32 num) {}

/* time processing */

void vpi_get_time(vpiHandle object, p_vpi_time time_p) {}

PLI_INT32 vpi_get_data(PLI_INT32 id, PLI_BYTE8* dataLoc, PLI_INT32 numOfBytes) {
  return 0;
}

PLI_INT32 vpi_put_data(PLI_INT32 id, PLI_BYTE8* dataLoc, PLI_INT32 numOfBytes) {
  return 0;
}

void* vpi_get_userdata(vpiHandle obj) { return 0; }

PLI_INT32 vpi_put_userdata(vpiHandle obj, void* userdata) { return 0; }

vpiHandle vpi_handle_by_multi_index(vpiHandle obj, PLI_INT32 num_index,
                                    PLI_INT32* index_array) {
  return 0;
}


vpiHandle vpi_register_assertion_cb( vpiHandle assertion, PLI_INT32 reason, vpi_assertion_callback_func *cb_rtn, PLI_BYTE8 *user_data) {
  return 0;
}


PLI_INT32 vpi_printf(PLI_BYTE8 *format, ...){
  return 0;
};

/* callback related */
vpiHandle vpi_register_cb(p_cb_data cb_data_p){
  return 0;
}

PLI_INT32 vpi_remove_cb(vpiHandle cb_obj){
  return 0;
}

void vpi_get_cb_info(vpiHandle object, p_cb_data cb_data_p){
}

vpiHandle vpi_register_systf(p_vpi_systf_data systf_data_p){
  return 0;
}

void vpi_get_systf_info(vpiHandle object, p_vpi_systf_data systf_data_p){
}

PLI_UINT32 vpi_mcd_open(PLI_BYTE8 *fileName){
  return 0;
}
PLI_UINT32 vpi_mcd_close(PLI_UINT32 mcd){
  return 0;
}
PLI_BYTE8 *vpi_mcd_name(PLI_UINT32 cd){
  return 0;
}
PLI_INT32 vpi_mcd_printf(PLI_UINT32 mcd,PLI_BYTE8 *format, ...){
  return 0;
}

PLI_INT32 vpi_chk_error(p_vpi_error_info error_info_p){
  return 0;
}
PLI_INT32 vpi_get_vlog_info(p_vpi_vlog_info vlog_info_p){
  return 0;
}

PLI_INT32 vpi_flush(void) {
  return 0;
}
PLI_INT32 vpi_mcd_flush(PLI_UINT32 mcd){
  return 0;
}
PLI_INT32 vpi_control(PLI_INT32 operation, ...){
  return 0;
}

/* 
 * 38.37.1 System task and system function callbacks
 * Global variable
 */
void (*vlog_startup_routines[]) () = {
  0
};
