/*
 Do not modify, auto-generated by script

 Copyright 2019-2020 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   vpi_visitor.cpp
 * Author: alain
 *
 * Created on December 14, 2019, 10:03 PM
 */
#include <uhdm/vpi_visitor.h>

#include <cstring>
#include <iostream>
#include <set>
#include <sstream>
#include <string>
#include <vector>
#include <algorithm>

static bool showIDs = false;
static constexpr int32_t kLevelIndent = 2;

#ifdef STANDARD_VPI

#include <sv_vpi_user.h>

// Missing defines from vpi_user.h, sv_vpi_user.h, They are no-op in the
// Standard implementation.
#define uhdmdesign 2569
#define uhdmallPackages 2570
#define uhdmallClasses 2571
#define uhdmallInterfaces 2572
#define uhdmallUdps 2573
#define uhdmallPrograms 2574
#define uhdmallModules 2575
#define uhdmtopModules 2576
#define vpiDesign 3000
#define vpiInterfaceTypespec 3001
#define vpiNets 3002
#define vpiSimpleExpr 3003
#define vpiParameters 3004
#define vpiSequenceExpr 3005
#define vpiUnsupportedStmt 4000
#define vpiUnsupportedExpr 4001
#define uhdmimport 2577

#else

#include <uhdm/Serializer.h>
#include <uhdm/containers.h>
#include <uhdm/sv_vpi_user.h>
#include <uhdm/uhdm.h>
#include <uhdm/uhdm_types.h>
#include <uhdm/vhpi_user.h>
#include <uhdm/vpi_uhdm.h>

#endif



// UHDM implementation redefine these
#ifndef vpiVarBit
  #define vpiVarBit   vpiRegBit
  #define vpiLogicVar vpiReg
  #define vpiArrayVar vpiRegArray
#endif

namespace UHDM {
#ifdef STANDARD_VPI

static std::string vpiTypeName(vpiHandle h) {
  int32_t type = vpi_get(vpiType, h);
  switch (type) {
    case 35: return "vpiNamedFork";
    case 611: return "vpiShortIntVar";
    case 36: return "vpiNet";
    case 612: return "vpiIntVar";
    case 37: return "vpiNetBit";
    case 613: return "vpiShortRealVar";
    case 38: return "vpiNullStmt";
    case 614: return "vpiByteVar";
    case 40: return "vpiParamAssign";
    case 39: return "vpiOperation";
    case 615: return "vpiClassVar";
    case 41: return "vpiParameter";
    case 616: return "vpiStringVar";
    case 42: return "vpiPartSelect";
    case 617: return "vpiEnumVar";
    case 43: return "vpiPathTerm";
    case 618: return "vpiStructVar";
    case 44: return "vpiPort";
    case 619: return "vpiUnionVar";
    case 620: return "vpiBitVar";
    case 45: return "vpiPortBit";
    case 621: return "vpiClassObj";
    case 46: return "vpiPrimTerm";
    case 622: return "vpiChandleVar";
    case 47: return "vpiRealVar";
    case 623: return "vpiPackedArrayVar";
    case 624: return "vpiAlwaysType";
    case 48: return "vpiReg";
    case 49: return "vpiRegBit";
    case 50: return "vpiRelease";
    case 625: return "vpiLongIntTypespec";
    case 51: return "vpiRepeat";
    case 626: return "vpiShortRealTypespec";
    case 52: return "vpiRepeatControl";
    case 627: return "vpiByteTypespec";
    case 53: return "vpiSchedEvent";
    case 628: return "vpiShortIntTypespec";
    case 54: return "vpiSpecParam";
    case 629: return "vpiIntTypespec";
    case 630: return "vpiClassTypespec";
    case 55: return "vpiSwitch";
    case 631: return "vpiStringTypespec";
    case 56: return "vpiSysFuncCall";
    case 632: return "vpiChandleTypespec";
    case 57: return "vpiSysTaskCall";
    case 633: return "vpiEnumTypespec";
    case 58: return "vpiTableEntry";
    case 634: return "vpiEnumConst";
    case 59: return "vpiTask";
    case 60: return "vpiTaskCall";
    case 635: return "vpiIntegerTypespec";
    case 61: return "vpiTchk";
    case 636: return "vpiTimeTypespec";
    case 62: return "vpiTchkTerm";
    case 637: return "vpiRealTypespec";
    case 63: return "vpiTimeVar";
    case 638: return "vpiStructTypespec";
    case 64: return "vpiTimeQueue";
    case 639: return "vpiUnionTypespec";
    case 640: return "vpiBitTypespec";
    case 65: return "vpiUdp";
    case 641: return "vpiLogicTypespec";
    case 66: return "vpiUdpDefn";
    case 642: return "vpiArrayTypespec";
    case 67: return "vpiUserSystf";
    case 643: return "vpiVoidTypespec";
    case 68: return "vpiVarSelect";
    case 644: return "vpiTypespecMember";
    case 69: return "vpiWait";
    case 70: return "vpiWhile";
    case 645: return "vpiDistItem";
    case 646: return "vpiAliasStmt";
    case 71: return "vpiCondition";
    case 647: return "vpiThread";
    case 72: return "vpiDelay";
    case 648: return "vpiMethodFuncCall";
    case 73: return "vpiElseStmt";
    case 649: return "vpiMethodTaskCall";
    case 74: return "vpiForIncStmt";
    case 650: return "vpiClockingBlock";
    case 75: return "vpiForInitStmt";
    case 651: return "vpiClockingIODecl";
    case 76: return "vpiHighConn";
    case 652: return "vpiClassDefn";
    case 77: return "vpiLhs";
    case 653: return "vpiConstraint";
    case 78: return "vpiIndex";
    case 654: return "vpiConstraintOrdering";
    case 655: return "vpiPropertyDecl";
    case 79: return "vpiLeftRange";
    case 80: return "vpiLowConn";
    case 656: return "vpiPropertySpec";
    case 81: return "vpiParent";
    case 657: return "vpiPropertyExpr";
    case 82: return "vpiRhs";
    case 658: return "vpiMulticlockSequenceExpr";
    case 83: return "vpiRightRange";
    case 660: return "vpiPropertyInst";
    case 659: return "vpiClockedSeq";
    case 84: return "vpiScope";
    case 661: return "vpiSequenceDecl";
    case 85: return "vpiSysTfCall";
    case 662: return "vpiCaseProperty";
    case 86: return "vpiTchkDataTerm";
    case 663: return "vpiEndLine";
    case 87: return "vpiTchkNotifier";
    case 664: return "vpiSequenceInst";
    case 88: return "vpiTchkRefTerm";
    case 0: return "vpiLargeCharge";
    case 665: return "vpiImmediateAssert";
    case 1: return "vpiAlways";
    case 89: return "vpiArgument";
    case 90: return "vpiBit";
    case 666: return "vpiReturn";
    case 2: return "vpiAssignStmt";
    case 91: return "vpiDriver";
    case 667: return "vpiAnyPattern";
    case 3: return "vpiAssignment";
    case 92: return "vpiInternalScope";
    case 668: return "vpiTaggedPattern";
    case 4: return "vpiBegin";
    case 93: return "vpiLoad";
    case 670: return "vpiDoWhile";
    case 669: return "vpiStructPattern";
    case 5: return "vpiCase";
    case 94: return "vpiModDataPathIn";
    case 671: return "vpiOrderedWait";
    case 6: return "vpiCaseItem";
    case 95: return "vpiModPathIn";
    case 672: return "vpiWaitFork";
    case 7: return "vpiConstant";
    case 96: return "vpiModPathOut";
    case 673: return "vpiDisableFork";
    case 8: return "vpiContAssign";
    case 97: return "vpiOperand";
    case 674: return "vpiExpectStmt";
    case 9: return "vpiDeassign";
    case 98: return "vpiPortInst";
    case 675: return "vpiForeachStmt";
    case 99: return "vpiProcess";
    case 676: return "vpiFinal";
    case 677: return "vpiExtends";
    case 678: return "vpiDistribution";
    case 680: return "vpiEnumNet";
    case 679: return "vpiSeqFormalDecl";
    case 681: return "vpiIntegerNet";
    case 682: return "vpiTimeNet";
    case 683: return "vpiStructNet";
    case 684: return "vpiBreak";
    case 685: return "vpiContinue";
    case 686: return "vpiAssert";
    case 687: return "vpiAssume";
    case 688: return "vpiCover";
    case 700: return "vpiActual";
    case 690: return "vpiClockingEvent";
    case 689: return "vpiDisableCondition";
    case 701: return "vpiTypedefAlias";
    case 691: return "vpiReturnStmt";
    case 702: return "vpiIndexTypespec";
    case 692: return "vpiPackedArrayTypespec";
    case 703: return "vpiBaseTypespec";
    case 693: return "vpiPackedArrayNet";
    case 704: return "vpiElemTypespec";
    case 694: return "vpiImmediateAssume";
    case 695: return "vpiImmediateCover";
    case 706: return "vpiInputSkew";
    case 696: return "vpiSequenceTypespec";
    case 707: return "vpiOutputSkew";
    case 697: return "vpiPropertyTypespec";
    case 708: return "vpiGlobalClocking";
    case 698: return "vpiEventTypespec";
    case 710: return "vpiDefaultDisableIff";
    case 709: return "vpiDefaultClocking";
    case 699: return "vpiPropFormalDecl";
    case 713: return "vpiOrigin";
    case 714: return "vpiPrefix";
    case 715: return "vpiWith";
    case 718: return "vpiProperty";
    case 720: return "vpiValueRange";
    case 721: return "vpiPattern";
    case 722: return "vpiWeight";
    case 725: return "vpiTypedef";
    case 726: return "vpiImportTypespec";
    case 727: return "vpiDerivedClasses";
    case 100: return "vpiVariables";
    case 728: return "vpiVirtualInterfaceVar";
    case 730: return "vpiMethods";
    case 101: return "vpiUse";
    case 731: return "vpiSolveBefore";
    case 102: return "vpiExpr";
    case 732: return "vpiSolveAfter";
    case 103: return "vpiPrimitive";
    case 104: return "vpiStmt";
    case 734: return "vpiWaitingProcesses";
    case 105: return "vpiAttribute";
    case 735: return "vpiMessages";
    case 106: return "vpiBitSelect";
    case 736: return "vpiConstrForEach";
    case 107: return "vpiCallback";
    case 737: return "vpiLoopVars";
    case 108: return "vpiDelayTerm";
    case 738: return "vpiConstrIf";
    case 109: return "vpiDelayDevice";
    case 110: return "vpiFrame";
    case 740: return "vpiConcurrentAssertions";
    case 739: return "vpiConstrIfElse";
    case 111: return "vpiGateArray";
    case 741: return "vpiMatchItem";
    case 112: return "vpiModuleArray";
    case 742: return "vpiMember";
    case 113: return "vpiPrimitiveArray";
    case 743: return "vpiElement";
    case 114: return "vpiNetArray";
    case 744: return "vpiAssertion";
    case 115: return "vpiRange";
    case 745: return "vpiInstance";
    case 116: return "vpiRegArray";
    case 746: return "vpiConstraintItem";
    case 117: return "vpiSwitchArray";
    case 747: return "vpiConstraintExpr";
    case 118: return "vpiUdpArray";
    case 748: return "vpiElseConst";
    case 119: return "vpiActiveTimeFormat";
    case 120: return "vpiInTerm";
    case 750: return "vpiCoverageStart";
    case 749: return "vpiImplication";
    case 121: return "vpiInstanceArray";
    case 751: return "vpiCoverageStOp";
    case 122: return "vpiLocalDriver";
    case 752: return "vpiCoverageReset";
    case 123: return "vpiLocalLoad";
    case 753: return "vpiCoverageCheck";
    case 124: return "vpiOutTerm";
    case 754: return "vpiCoverageMerge";
    case 125: return "vpiPorts";
    case 755: return "vpiCoverageSave";
    case 126: return "vpiSimNet";
    case 127: return "vpiTaskFunc";
    case 128: return "vpiContAssignBit";
    case 758: return "vpiFsm";
    case 129: return "vpiNamedEventArray";
    case 130: return "vpiIndexedPartSelect";
    case 759: return "vpiFsmHandle";
    case 760: return "vpiAssertCoverage";
    case 131: return "vpiBaseExpr";
    case 761: return "vpiFsmStateCoverage";
    case 132: return "vpiWidthExpr";
    case 762: return "vpiStatementCoverage";
    case 133: return "vpiGenScopeArray";
    case 763: return "vpiToggleCoverage";
    case 134: return "vpiGenScope";
    case 135: return "vpiGenVar";
    case 765: return "vpiCovered";
    case 136: return "vpiAutomatics";
    case 766: return "vpiCoverMax";
    case 767: return "vpiCoveredCount";
    case 770: return "vpiAssertAttemptCovered";
    case 771: return "vpiAssertSuccessCovered";
    case 772: return "vpiAssertFailureCovered";
    case 773: return "vpiAssertVacuousSuccessCovered";
    case 774: return "vpiAssertDisableCovered";
    case 775: return "vpiFsmStates";
    case 776: return "vpiFsmStateExpression";
    case 777: return "vpiAssertKillCovered";
    case 10: return "vpiDefParam";
    case 901: return "vpiRestrict";
    case 11: return "vpiDelayControl";
    case 902: return "vpiClockedProp";
    case 12: return "vpiDisable";
    case 903: return "vpiLetDecl";
    case 13: return "vpiEventControl";
    case 904: return "vpiLetExpr";
    case 14: return "vpiEventStmt";
    case 905: return "vpiCasePropertyItem";
    case 15: return "vpiFor";
    case 16: return "vpiForce";
    case 17: return "vpiForever";
    case 18: return "vpiFork";
    case 20: return "vpiFunction";
    case 19: return "vpiFuncCall";
    case 21: return "vpiGate";
    case 22: return "vpiIf";
    case 23: return "vpiIfElse";
    case 24: return "vpiInitial";
    case 600: return "vpiPackage";
    case 25: return "vpiIntegerVar";
    case 601: return "vpiInterface";
    case 26: return "vpiInterModPath";
    case 602: return "vpiProgram";
    case 27: return "vpiIterator";
    case 603: return "vpiInterfaceArray";
    case 28: return "vpiIODecl";
    case 604: return "vpiProgramArray";
    case 30: return "vpiMemoryWord";
    case 29: return "vpiMemory";
    case 605: return "vpiTypespec";
    case 31: return "vpiModPath";
    case 606: return "vpiModport";
    case 32: return "vpiModule";
    case 607: return "vpiInterfaceTfDecl";
    case 33: return "vpiNamedBegin";
    case 608: return "vpiRefObj";
    case 34: return "vpiNamedEvent";
    case 609: return "vpiTypeParameter";
    case 610: return "vpiLongIntVar";
  }
}

#endif

static void release_handle(vpiHandle obj_h) {
#ifndef STANDARD_VPI
  vpi_release_handle(obj_h);
#endif
}

static std::string visit_value(s_vpi_value* value) {
  if (value == nullptr) return "";
  switch (value->format) {
    case vpiIntVal:
      return std::string("|INT:")
          .append(std::to_string(value->value.integer))
          .append("\n");
    case vpiUIntVal:
      return std::string("|UINT:")
          .append(std::to_string(value->value.uint))
          .append("\n");
    case vpiStringVal:
      return std::string("|STRING:")
          .append((const char*)value->value.str)
          .append("\n");
    case vpiBinStrVal:
      return std::string("|BIN:")
          .append((const char*)value->value.str)
          .append("\n");
    case vpiHexStrVal:
      return std::string("|HEX:")
          .append((const char*)value->value.str)
          .append("\n");
    case vpiOctStrVal:
      return std::string("|OCT:")
          .append((const char*)value->value.str)
          .append("\n");
    case vpiRealVal:
      return std::string("|REAL:")
          .append(std::to_string(value->value.real))
          .append("\n");
    case vpiScalarVal:
      return std::string("|SCAL:")
          .append(std::to_string(value->value.scalar))
          .append("\n");
    case vpiDecStrVal:
      return std::string("|DEC:")
          .append((const char*)value->value.str)
          .append("\n");
  }
  return "";
}

static std::string visit_delays(s_vpi_delay* delay) {
  if (delay == nullptr) return "";
  switch (delay->time_type) {
    case vpiScaledRealTime:
      return std::string("|#")
          .append(std::to_string(delay->da[0].low))
          .append("\n");
  }
  return "";
}

std::ostream& VpiVisitor::stream_indent(int32_t indent) const {
  return m_out << std::string(indent, ' ');
}

void VpiVisitor::visit_baseclass(vpiHandle obj_h, int32_t indent,
                                     const char* relation, bool shallowVisit) {
  if (vpiHandle itr = vpi_handle(vpiParent, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiParent", true);
    release_handle(itr);
  }
}

void VpiVisitor::visit_attribute(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const int32_t n = vpi_get(vpiDefAttribute, obj_h))
    stream_indent(indent) << "|vpiDefAttribute:" << n << "\n";
  s_vpi_value value;
  vpi_get_value(obj_h, &value);
  if (value.format) {
    std::string val = visit_value(&value);
    if (!val.empty()) {
      stream_indent(indent) << val;
    }
  }
  if (const char* s = vpi_get_str(vpiDefFile, obj_h))
    stream_indent(indent) << "|vpiDefFile:" << s << "\n";
  if (const int32_t n = vpi_get(vpiDefLineNo, obj_h))
    stream_indent(indent) << "|vpiDefLineNo:" << n << "\n";
}

void VpiVisitor::visit_virtual_interface_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_let_decl(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiExpr, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiExpr", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiSeqFormalDecl, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiSeqFormalDecl", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
}

void VpiVisitor::visit_concurrent_assertions(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const char* s = vpi_get_str(vpiFullName, obj_h))
    stream_indent(indent) << "|vpiFullName:" << s << "\n";
  if (const int32_t n = vpi_get(vpiIsClockInferred, obj_h))
    stream_indent(indent) << "|vpiIsClockInferred:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiClockingEvent, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiClockingEvent", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiProperty, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiProperty", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_process_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiModule, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiModule", true);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_always(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_process_stmt(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiAlwaysType, obj_h))
    stream_indent(indent) << "|vpiAlwaysType:" << n << "\n";
}

void VpiVisitor::visit_final_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_process_stmt(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_initial(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_process_stmt(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_atomic_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_delay_control(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  s_vpi_delay delay;
  vpi_get_delays(obj_h, &delay);
  if (delay.da != nullptr) {
    stream_indent(indent) << visit_delays(&delay);
  }
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiDelay, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiDelay", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_delay_term(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_event_control(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiCondition, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiCondition", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_repeat_control(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_scope(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const char* s = vpi_get_str(vpiFullName, obj_h))
    stream_indent(indent) << "|vpiFullName:" << s << "\n";
  if (vpiHandle itr = vpi_iterate(vpiPropertyDecl, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiPropertyDecl", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiSequenceDecl, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiSequenceDecl", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiConcurrentAssertions, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiConcurrentAssertions", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiNamedEvent, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiNamedEvent", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiNamedEventArray, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiNamedEventArray", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiVariables, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiVariables", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiVirtualInterfaceVar, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiVirtualInterfaceVar", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiReg, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiReg", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiRegArray, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiRegArray", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiMemory, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiMemory", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiParameter, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiParameter", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiParamAssign, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiParamAssign", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiInternalScope, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiInternalScope", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiTypedef, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiTypedef", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiImportTypespec, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiImportTypespec", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiLetDecl, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiLetDecl", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_begin(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_scope(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiStmt, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiStmt", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_named_begin(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_scope(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiStmt, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiStmt", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (const char* s = vpi_get_str(vpiEndLabel, obj_h))
    stream_indent(indent) << "|vpiEndLabel:" << s << "\n";
}

void VpiVisitor::visit_named_fork(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_scope(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiJoinType, obj_h))
    stream_indent(indent) << "|vpiJoinType:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiStmt, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiStmt", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (const char* s = vpi_get_str(vpiEndLabel, obj_h))
    stream_indent(indent) << "|vpiEndLabel:" << s << "\n";
}

void VpiVisitor::visit_fork_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_scope(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiJoinType, obj_h))
    stream_indent(indent) << "|vpiJoinType:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiStmt, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiStmt", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_for_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_scope(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiLocalVarDecls, obj_h))
    stream_indent(indent) << "|vpiLocalVarDecls:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiForInitStmt, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiForInitStmt", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiForIncStmt, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiForIncStmt", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiForInitStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiForInitStmt", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiCondition, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiCondition", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiForIncStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiForIncStmt", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_if_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiQualifier, obj_h))
    stream_indent(indent) << "|vpiQualifier:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiCondition, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiCondition", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_event_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiBlocking, obj_h))
    stream_indent(indent) << "|vpiBlocking:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiNamedEvent, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiNamedEvent", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_thread_obj(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_forever_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_waits(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_wait_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_waits(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiCondition, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiCondition", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_wait_fork(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_waits(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_ordered_wait(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_waits(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiCondition, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiCondition", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiElseStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiElseStmt", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_disables(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_disable(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_disables(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExpr", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_disable_fork(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_disables(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_continue_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_break_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_return_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiCondition, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiCondition", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_while_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiCondition, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiCondition", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_repeat(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiCondition, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiCondition", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_do_while(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiCondition, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiCondition", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_if_else(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiQualifier, obj_h))
    stream_indent(indent) << "|vpiQualifier:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiCondition, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiCondition", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiElseStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiElseStmt", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_case_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiRandType, obj_h))
    stream_indent(indent) << "|vpiRandType:" << n << "\n";
  if (const int32_t n = vpi_get(vpiCaseType, obj_h))
    stream_indent(indent) << "|vpiCaseType:" << n << "\n";
  if (const int32_t n = vpi_get(vpiQualifier, obj_h))
    stream_indent(indent) << "|vpiQualifier:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiCondition, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiCondition", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiCaseItem, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiCaseItem", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_force(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiRhs, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRhs", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiLhs, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLhs", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_assign_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiRhs, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRhs", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiLhs, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLhs", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_deassign(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiLhs, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLhs", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_release(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiLhs, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLhs", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_null_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_expect_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiElseStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiElseStmt", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiPropertySpec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiPropertySpec", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_foreach_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_scope(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiVariables, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiVariables", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiLoopVars, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiLoopVars", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_gen_scope(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_scope(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiIndex, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiIndex", false);
    release_handle(itr);
  }
  if (const int32_t n = vpi_get(vpiArrayMember, obj_h))
    stream_indent(indent) << "|vpiArrayMember:" << n << "\n";
  if (const int32_t n = vpi_get(vpiProtected, obj_h))
    stream_indent(indent) << "|vpiProtected:" << n << "\n";
  if (const int32_t n = vpi_get(vpiImplicitDecl, obj_h))
    stream_indent(indent) << "|vpiImplicitDecl:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiNet, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiNet", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiArrayNet, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiArrayNet", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiProcess, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiProcess", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiContAssign, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiContAssign", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiModule, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiModule", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiModuleArray, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiModuleArray", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiPrimitive, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiPrimitive", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiPrimitiveArray, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiPrimitiveArray", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiDefParam, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiDefParam", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiGenScopeArray, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiGenScopeArray", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiProgram, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiProgram", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiProgramArray, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiProgramArray", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiAssertion, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAssertion", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiInterface, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiInterface", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiInterfaceArray, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiInterfaceArray", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiAliasStmt, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAliasStmt", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiClockingBlock, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiClockingBlock", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiTaskFunc, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiTaskFunc", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiSysTaskCall, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiSysTaskCall", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_gen_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const char* s = vpi_get_str(vpiFullName, obj_h))
    stream_indent(indent) << "|vpiFullName:" << s << "\n";
  if (vpiHandle itr = vpi_iterate(vpiGenScopeArray, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiGenScopeArray", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_gen_scope_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiSize, obj_h))
    stream_indent(indent) << "|vpiSize:" << n << "\n";
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const char* s = vpi_get_str(vpiFullName, obj_h))
    stream_indent(indent) << "|vpiFullName:" << s << "\n";
  if (vpiHandle itr = vpi_handle(vpiGenVar, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiGenVar", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiGenScope, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiGenScope", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiInstance, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiInstance", true);
    release_handle(itr);
  }
}

void VpiVisitor::visit_assert_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_concurrent_assertions(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiElseStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiElseStmt", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiClockingBlock, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiClockingBlock", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_cover(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_concurrent_assertions(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiIsCoverSequence, obj_h))
    stream_indent(indent) << "|vpiIsCoverSequence:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiClockingBlock, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiClockingBlock", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_assume(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_concurrent_assertions(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiClockingBlock, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiClockingBlock", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_restrict(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_concurrent_assertions(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiClockingBlock, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiClockingBlock", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_immediate_assert(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiIsDeferred, obj_h))
    stream_indent(indent) << "|vpiIsDeferred:" << n << "\n";
  if (const int32_t n = vpi_get(vpiIsFinal, obj_h))
    stream_indent(indent) << "|vpiIsFinal:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExpr", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiElseStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiElseStmt", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiClockingBlock, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiClockingBlock", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_immediate_assume(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiIsDeferred, obj_h))
    stream_indent(indent) << "|vpiIsDeferred:" << n << "\n";
  if (const int32_t n = vpi_get(vpiIsFinal, obj_h))
    stream_indent(indent) << "|vpiIsFinal:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExpr", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiElseStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiElseStmt", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiClockingBlock, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiClockingBlock", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_immediate_cover(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiIsDeferred, obj_h))
    stream_indent(indent) << "|vpiIsDeferred:" << n << "\n";
  if (const int32_t n = vpi_get(vpiIsFinal, obj_h))
    stream_indent(indent) << "|vpiIsFinal:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExpr", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiClockingBlock, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiClockingBlock", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_expr(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiDecompile, obj_h))
    stream_indent(indent) << "|vpiDecompile:" << s << "\n";
  if (const int32_t n = vpi_get(vpiSize, obj_h))
    stream_indent(indent) << "|vpiSize:" << n << "\n";
  s_vpi_value value;
  vpi_get_value(obj_h, &value);
  if (value.format) {
    std::string val = visit_value(&value);
    if (!val.empty()) {
      stream_indent(indent) << val;
    }
  }
  if (vpiHandle itr = vpi_handle(vpiTypespec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiTypespec", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_case_item(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiExpr, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiExpr", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_assignment(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiOpType, obj_h))
    stream_indent(indent) << "|vpiOpType:" << n << "\n";
  if (const int32_t n = vpi_get(vpiBlocking, obj_h))
    stream_indent(indent) << "|vpiBlocking:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiRhs, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRhs", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiLhs, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLhs", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiDelayControl, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiDelayControl", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiEventControl, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiEventControl", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiRepeatControl, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRepeatControl", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_any_pattern(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
}

void VpiVisitor::visit_tagged_pattern(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (vpiHandle itr = vpi_handle(vpiPattern, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiPattern", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiTypespec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiTypespec", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_struct_pattern(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (vpiHandle itr = vpi_handle(vpiPattern, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiPattern", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_unsupported_expr(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_expr(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_unsupported_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_atomic_stmt(obj_h, indent, relation, shallowVisit);
  s_vpi_value value;
  vpi_get_value(obj_h, &value);
  if (value.format) {
    std::string val = visit_value(&value);
    if (!val.empty()) {
      stream_indent(indent) << val;
    }
  }
}

void VpiVisitor::visit_include_file_info(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiIncludedFile, obj_h))
    stream_indent(indent) << "|vpiIncludedFile:" << s << "\n";
}

void VpiVisitor::visit_sequence_inst(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiSequenceDecl, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiSequenceDecl", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiArgument, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiArgument", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (vpiHandle itr = vpi_handle(vpiClockingBlock, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiClockingBlock", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_seq_formal_decl(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const int32_t n = vpi_get(vpiDirection, obj_h))
    stream_indent(indent) << "|vpiDirection:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExpr", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiTypespec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiTypespec", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_sequence_decl(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const char* s = vpi_get_str(vpiFullName, obj_h))
    stream_indent(indent) << "|vpiFullName:" << s << "\n";
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiVariables, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiVariables", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExpr", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiSeqFormalDecl, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiSeqFormalDecl", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_prop_formal_decl(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const int32_t n = vpi_get(vpiDirection, obj_h))
    stream_indent(indent) << "|vpiDirection:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExpr", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiTypespec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiTypespec", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_property_inst(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiDisableCondition, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiDisableCondition", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiArgument, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiArgument", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiPropertyDecl, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiPropertyDecl", false);
    release_handle(itr);
  }
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (vpiHandle itr = vpi_handle(vpiClockingBlock, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiClockingBlock", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_property_spec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiDisableCondition, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiDisableCondition", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiClockingEvent, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiClockingEvent", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiPropertyExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiPropertyExpr", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_property_decl(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const char* s = vpi_get_str(vpiFullName, obj_h))
    stream_indent(indent) << "|vpiFullName:" << s << "\n";
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiPropFormalDecl, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiPropFormalDecl", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiVariables, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiVariables", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiPropertySpec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiPropertySpec", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_clocked_property(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiClockingEvent, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiClockingEvent", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiPropertyExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiPropertyExpr", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_case_property_item(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiExpr, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiExpr", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiPropertyExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiPropertyExpr", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_case_property(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiCondition, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiCondition", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiCasePropertyItem, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiCasePropertyItem", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_multiclock_sequence_expr(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiClockedSeq, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiClockedSeq", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_clocked_seq(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiClockingEvent, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiClockingEvent", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiSequenceExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiSequenceExpr", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_simple_expr(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_expr(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiUse, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiUse", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_constant(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_expr(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiConstType, obj_h))
    stream_indent(indent) << "|vpiConstType:" << n << "\n";
}

void VpiVisitor::visit_let_expr(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_expr(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiArgument, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiArgument", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiLetDecl, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLetDecl", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_operation(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_expr(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiOpType, obj_h))
    stream_indent(indent) << "|vpiOpType:" << n << "\n";
  if (const int32_t n = vpi_get(vpiReordered, obj_h))
    stream_indent(indent) << "|vpiReordered:" << n << "\n";
  if (const int32_t n = vpi_get(vpiFlattened, obj_h))
    stream_indent(indent) << "|vpiFlattened:" << n << "\n";
  if (const int32_t n = vpi_get(vpiOpStrong, obj_h))
    stream_indent(indent) << "|vpiOpStrong:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiOperand, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiOperand", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_ref_obj(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_simple_expr(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const char* s = vpi_get_str(vpiFullName, obj_h))
    stream_indent(indent) << "|vpiFullName:" << s << "\n";
  if (const char* s = vpi_get_str(vpiDefName, obj_h))
    stream_indent(indent) << "|vpiDefName:" << s << "\n";
  if (const int32_t n = vpi_get(vpiGeneric, obj_h))
    stream_indent(indent) << "|vpiGeneric:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiActual, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiActual", true);
    release_handle(itr);
  }
  if (const int32_t n = vpi_get(vpiStructMember, obj_h))
    stream_indent(indent) << "|vpiStructMember:" << n << "\n";
}

void VpiVisitor::visit_ref_module(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const char* s = vpi_get_str(vpiDefName, obj_h))
    stream_indent(indent) << "|vpiDefName:" << s << "\n";
  if (vpiHandle itr = vpi_handle(vpiActual, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiActual", true);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiPort, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiPort", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_ref_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_simple_expr(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const char* s = vpi_get_str(vpiFullName, obj_h))
    stream_indent(indent) << "|vpiFullName:" << s << "\n";
  if (const char* s = vpi_get_str(vpiDefName, obj_h))
    stream_indent(indent) << "|vpiDefName:" << s << "\n";
  if (vpiHandle itr = vpi_handle(vpiActual, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiActual", true);
    release_handle(itr);
  }
}

void VpiVisitor::visit_part_select(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_ref_obj(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiConstantSelect, obj_h))
    stream_indent(indent) << "|vpiConstantSelect:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiLeftRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLeftRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiRightRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRightRange", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_indexed_part_select(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_ref_obj(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiConstantSelect, obj_h))
    stream_indent(indent) << "|vpiConstantSelect:" << n << "\n";
  if (const int32_t n = vpi_get(vpiIndexedPartSelectType, obj_h))
    stream_indent(indent) << "|vpiIndexedPartSelectType:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiBaseExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiBaseExpr", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiWidthExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiWidthExpr", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_var_select(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_ref_obj(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiConstantSelect, obj_h))
    stream_indent(indent) << "|vpiConstantSelect:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiIndex, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiIndex", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiIndex, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiIndex", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_bit_select(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_ref_obj(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiConstantSelect, obj_h))
    stream_indent(indent) << "|vpiConstantSelect:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiIndex, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiIndex", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_variables(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_simple_expr(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiArrayMember, obj_h))
    stream_indent(indent) << "|vpiArrayMember:" << n << "\n";
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const char* s = vpi_get_str(vpiFullName, obj_h))
    stream_indent(indent) << "|vpiFullName:" << s << "\n";
  if (const int32_t n = vpi_get(vpiSigned, obj_h))
    stream_indent(indent) << "|vpiSigned:" << n << "\n";
  if (const int32_t n = vpi_get(vpiAutomatic, obj_h))
    stream_indent(indent) << "|vpiAutomatic:" << n << "\n";
  if (const int32_t n = vpi_get(vpiAllocScheme, obj_h))
    stream_indent(indent) << "|vpiAllocScheme:" << n << "\n";
  if (const int32_t n = vpi_get(vpiConstantVariable, obj_h))
    stream_indent(indent) << "|vpiConstantVariable:" << n << "\n";
  if (const int32_t n = vpi_get(vpiIsRandomized, obj_h))
    stream_indent(indent) << "|vpiIsRandomized:" << n << "\n";
  if (const int32_t n = vpi_get(vpiRandType, obj_h))
    stream_indent(indent) << "|vpiRandType:" << n << "\n";
  if (const int32_t n = vpi_get(vpiStructUnionMember, obj_h))
    stream_indent(indent) << "|vpiStructUnionMember:" << n << "\n";
  if (const int32_t n = vpi_get(vpiScalar, obj_h))
    stream_indent(indent) << "|vpiScalar:" << n << "\n";
  if (const int32_t n = vpi_get(vpiVisibility, obj_h))
    stream_indent(indent) << "|vpiVisibility:" << n << "\n";
  if (const int32_t n = vpi_get(vpiVector, obj_h))
    stream_indent(indent) << "|vpiVector:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiPortInst, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiPortInst", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiDriver, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiDriver", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiLoad, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiLoad", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiPrimTerm, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiPrimTerm", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiContAssign, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiContAssign", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiPathTerm, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiPathTerm", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiTchkTerm, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiTchkTerm", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiModule, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiModule", true);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiInstance, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiInstance", true);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiScope, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiScope", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExpr", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiIndex, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiIndex", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_hier_path(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_simple_expr(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiActual, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiActual", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExpr", false);
    release_handle(itr);
  }
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const char* s = vpi_get_str(vpiFullName, obj_h))
    stream_indent(indent) << "|vpiFullName:" << s << "\n";
}

void VpiVisitor::visit_ref_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_variables(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiDefName, obj_h))
    stream_indent(indent) << "|vpiDefName:" << s << "\n";
  if (const int32_t n = vpi_get(vpiGeneric, obj_h))
    stream_indent(indent) << "|vpiGeneric:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiActual, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiActual", true);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiTaskFunc, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiTaskFunc", false);
    release_handle(itr);
  }
  if (const int32_t n = vpi_get(vpiStructMember, obj_h))
    stream_indent(indent) << "|vpiStructMember:" << n << "\n";
}

void VpiVisitor::visit_short_real_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_variables(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_real_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_variables(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_byte_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_variables(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_short_int_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_variables(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_int_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_variables(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_long_int_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_variables(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_integer_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_variables(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_time_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_variables(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_array_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_variables(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiArrayType, obj_h))
    stream_indent(indent) << "|vpiArrayType:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiVarSelect, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiVarSelect", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiRange, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiRange", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiLeftRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLeftRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiRightRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRightRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiReg, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiReg", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_array_expr(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_expr(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiExpr, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiExpr", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_reg_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiIsMemory, obj_h))
    stream_indent(indent) << "|vpiIsMemory:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiLeftRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLeftRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiRightRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRightRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiMemoryWord, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiMemoryWord", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_reg(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiLeftRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLeftRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiRightRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRightRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiIndex, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiIndex", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_packed_array_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_variables(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiPackedArrayMember, obj_h))
    stream_indent(indent) << "|vpiPackedArrayMember:" << n << "\n";
  if (const int32_t n = vpi_get(vpiConstantSelect, obj_h))
    stream_indent(indent) << "|vpiConstantSelect:" << n << "\n";
  if (const int32_t n = vpi_get(vpiPacked, obj_h))
    stream_indent(indent) << "|vpiPacked:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiRange, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiRange", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiLeftRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLeftRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiRightRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRightRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiBit, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiBit", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiElement, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiElement", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiIndex, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiIndex", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_bit_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_variables(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiRange, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiRange", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiLeftRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLeftRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiRightRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRightRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiBit, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiBit", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_logic_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_variables(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiRange, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiRange", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiLeftRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLeftRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiRightRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRightRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiBit, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiBit", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_struct_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_variables(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiPackedArrayMember, obj_h))
    stream_indent(indent) << "|vpiPackedArrayMember:" << n << "\n";
  if (const int32_t n = vpi_get(vpiConstantSelect, obj_h))
    stream_indent(indent) << "|vpiConstantSelect:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiBit, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiBit", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiMember, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiMember", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiIndex, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiIndex", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_union_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_variables(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiPackedArrayMember, obj_h))
    stream_indent(indent) << "|vpiPackedArrayMember:" << n << "\n";
  if (const int32_t n = vpi_get(vpiConstantSelect, obj_h))
    stream_indent(indent) << "|vpiConstantSelect:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiBit, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiBit", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiMember, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiMember", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiIndex, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiIndex", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_enum_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_variables(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiPackedArrayMember, obj_h))
    stream_indent(indent) << "|vpiPackedArrayMember:" << n << "\n";
  if (const int32_t n = vpi_get(vpiConstantSelect, obj_h))
    stream_indent(indent) << "|vpiConstantSelect:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiIndex, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiIndex", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_string_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_variables(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_chandle_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_variables(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiActual, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiActual", true);
    release_handle(itr);
  }
}

void VpiVisitor::visit_var_bit(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_variables(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiConstantSelect, obj_h))
    stream_indent(indent) << "|vpiConstantSelect:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiIndex, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiIndex", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiIndex, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiIndex", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_task_func(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_scope(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiMethod, obj_h))
    stream_indent(indent) << "|vpiMethod:" << n << "\n";
  if (const int32_t n = vpi_get(vpiAccessType, obj_h))
    stream_indent(indent) << "|vpiAccessType:" << n << "\n";
  if (const int32_t n = vpi_get(vpiVisibility, obj_h))
    stream_indent(indent) << "|vpiVisibility:" << n << "\n";
  if (const int32_t n = vpi_get(vpiVirtual, obj_h))
    stream_indent(indent) << "|vpiVirtual:" << n << "\n";
  if (const int32_t n = vpi_get(vpiAutomatic, obj_h))
    stream_indent(indent) << "|vpiAutomatic:" << n << "\n";
  if (const int32_t n = vpi_get(vpiDPIPure, obj_h))
    stream_indent(indent) << "|vpiDPIPure:" << n << "\n";
  if (const int32_t n = vpi_get(vpiDPIContext, obj_h))
    stream_indent(indent) << "|vpiDPIContext:" << n << "\n";
  if (const int32_t n = vpi_get(vpiDPICStr, obj_h))
    stream_indent(indent) << "|vpiDPICStr:" << n << "\n";
  if (const char* s = vpi_get_str(vpiDPICIdentifier, obj_h))
    stream_indent(indent) << "|vpiDPICIdentifier:" << s << "\n";
  if (vpiHandle itr = vpi_handle(vpiLeftRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLeftRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiRightRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRightRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiReturn, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiReturn", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiClassDefn, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiClassDefn", true);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiIODecl, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiIODecl", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiInstance, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiInstance", true);
    release_handle(itr);
  }
}

void VpiVisitor::visit_task(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_task_func(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_function(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_task_func(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiSigned, obj_h))
    stream_indent(indent) << "|vpiSigned:" << n << "\n";
  if (const int32_t n = vpi_get(vpiSize, obj_h))
    stream_indent(indent) << "|vpiSize:" << n << "\n";
  if (const int32_t n = vpi_get(vpiFuncType, obj_h))
    stream_indent(indent) << "|vpiFuncType:" << n << "\n";
}

void VpiVisitor::visit_modport(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (vpiHandle itr = vpi_iterate(vpiIODecl, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiIODecl", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiInterface, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiInterface", true);
    release_handle(itr);
  }
}

void VpiVisitor::visit_interface_tf_decl(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiAccessType, obj_h))
    stream_indent(indent) << "|vpiAccessType:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiTask, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiTask", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiFunction, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiFunction", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_cont_assign(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiNetDeclAssign, obj_h))
    stream_indent(indent) << "|vpiNetDeclAssign:" << n << "\n";
  if (const int32_t n = vpi_get(vpiStrength0, obj_h))
    stream_indent(indent) << "|vpiStrength0:" << n << "\n";
  if (const int32_t n = vpi_get(vpiStrength1, obj_h))
    stream_indent(indent) << "|vpiStrength1:" << n << "\n";
  s_vpi_value value;
  vpi_get_value(obj_h, &value);
  if (value.format) {
    std::string val = visit_value(&value);
    if (!val.empty()) {
      stream_indent(indent) << val;
    }
  }
  if (vpiHandle itr = vpi_handle(vpiDelay, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiDelay", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiRhs, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRhs", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiLhs, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLhs", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiBit, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiBit", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_cont_assign_bit(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiOffset, obj_h))
    stream_indent(indent) << "|vpiOffset:" << n << "\n";
  if (const int32_t n = vpi_get(vpiNetDeclAssign, obj_h))
    stream_indent(indent) << "|vpiNetDeclAssign:" << n << "\n";
  if (const int32_t n = vpi_get(vpiStrength0, obj_h))
    stream_indent(indent) << "|vpiStrength0:" << n << "\n";
  if (const int32_t n = vpi_get(vpiStrength1, obj_h))
    stream_indent(indent) << "|vpiStrength1:" << n << "\n";
  s_vpi_value value;
  vpi_get_value(obj_h, &value);
  if (value.format) {
    std::string val = visit_value(&value);
    if (!val.empty()) {
      stream_indent(indent) << val;
    }
  }
  if (vpiHandle itr = vpi_handle(vpiDelay, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiDelay", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiRhs, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRhs", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiLhs, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLhs", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_ports(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiPortIndex, obj_h))
    stream_indent(indent) << "|vpiPortIndex:" << n << "\n";
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const int32_t n = vpi_get(vpiPortType, obj_h))
    stream_indent(indent) << "|vpiPortType:" << n << "\n";
  if (const int32_t n = vpi_get(vpiScalar, obj_h))
    stream_indent(indent) << "|vpiScalar:" << n << "\n";
  if (const int32_t n = vpi_get(vpiVector, obj_h))
    stream_indent(indent) << "|vpiVector:" << n << "\n";
  if (const int32_t n = vpi_get(vpiConnByName, obj_h))
    stream_indent(indent) << "|vpiConnByName:" << n << "\n";
  if (const int32_t n = vpi_get(vpiDirection, obj_h))
    stream_indent(indent) << "|vpiDirection:" << n << "\n";
  if (const int32_t n = vpi_get(vpiSize, obj_h))
    stream_indent(indent) << "|vpiSize:" << n << "\n";
  if (const char* s = vpi_get_str(vpiExplicitName, obj_h))
    stream_indent(indent) << "|vpiExplicitName:" << s << "\n";
  if (vpiHandle itr = vpi_handle(vpiHighConn, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiHighConn", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiLowConn, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLowConn", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiTypedef, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiTypedef", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiInstance, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiInstance", true);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiModule, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiModule", true);
    release_handle(itr);
  }
}

void VpiVisitor::visit_port(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_ports(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiBit, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiBit", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_port_bit(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_ports(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_checker_port(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_ports(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiPropertyDecl, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiPropertyDecl", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiSequenceDecl, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiSequenceDecl", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_checker_inst_port(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiPropertyInst, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiPropertyInst", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiSequenceInst, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiSequenceInst", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_primitive(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiArrayMember, obj_h))
    stream_indent(indent) << "|vpiArrayMember:" << n << "\n";
  if (const char* s = vpi_get_str(vpiDefName, obj_h))
    stream_indent(indent) << "|vpiDefName:" << s << "\n";
  s_vpi_delay delay;
  vpi_get_delays(obj_h, &delay);
  if (delay.da != nullptr) {
    stream_indent(indent) << visit_delays(&delay);
  }
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const char* s = vpi_get_str(vpiFullName, obj_h))
    stream_indent(indent) << "|vpiFullName:" << s << "\n";
  if (const int32_t n = vpi_get(vpiPrimType, obj_h))
    stream_indent(indent) << "|vpiPrimType:" << n << "\n";
  if (const int32_t n = vpi_get(vpiStrength0, obj_h))
    stream_indent(indent) << "|vpiStrength0:" << n << "\n";
  if (const int32_t n = vpi_get(vpiStrength1, obj_h))
    stream_indent(indent) << "|vpiStrength1:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  s_vpi_value value;
  vpi_get_value(obj_h, &value);
  if (value.format) {
    std::string val = visit_value(&value);
    if (!val.empty()) {
      stream_indent(indent) << val;
    }
  }
  if (vpiHandle itr = vpi_handle(vpiDelay, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiDelay", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiIndex, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiIndex", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiPrimTerm, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiPrimTerm", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_gate(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_primitive(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_switch_tran(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_primitive(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_udp(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_primitive(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiUdpDefn, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiUdpDefn", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_mod_path(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_tchk(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiModule, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiModule", true);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiDelay, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiDelay", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiExpr, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiExpr", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiTchkRefTerm, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiTchkRefTerm", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiTchkDataTerm, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiTchkDataTerm", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiTchkNotifier, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiTchkNotifier", false);
    release_handle(itr);
  }
  s_vpi_delay delay;
  vpi_get_delays(obj_h, &delay);
  if (delay.da != nullptr) {
    stream_indent(indent) << visit_delays(&delay);
  }
  if (const int32_t n = vpi_get(vpiTchkType, obj_h))
    stream_indent(indent) << "|vpiTchkType:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_range(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiSize, obj_h))
    stream_indent(indent) << "|vpiSize:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiLeftRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLeftRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiRightRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRightRange", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_udp_defn(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiDefName, obj_h))
    stream_indent(indent) << "|vpiDefName:" << s << "\n";
  if (const int32_t n = vpi_get(vpiSize, obj_h))
    stream_indent(indent) << "|vpiSize:" << n << "\n";
  if (const int32_t n = vpi_get(vpiProtected, obj_h))
    stream_indent(indent) << "|vpiProtected:" << n << "\n";
  if (const int32_t n = vpi_get(vpiPrimType, obj_h))
    stream_indent(indent) << "|vpiPrimType:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiIODecl, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiIODecl", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiTableEntry, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiTableEntry", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiInitial, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiInitial", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_table_entry(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiSize, obj_h))
    stream_indent(indent) << "|vpiSize:" << n << "\n";
  s_vpi_value value;
  vpi_get_value(obj_h, &value);
  if (value.format) {
    std::string val = visit_value(&value);
    if (!val.empty()) {
      stream_indent(indent) << val;
    }
  }
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_io_decl(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiDirection, obj_h))
    stream_indent(indent) << "|vpiDirection:" << n << "\n";
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const int32_t n = vpi_get(vpiScalar, obj_h))
    stream_indent(indent) << "|vpiScalar:" << n << "\n";
  if (const int32_t n = vpi_get(vpiSigned, obj_h))
    stream_indent(indent) << "|vpiSigned:" << n << "\n";
  if (const int32_t n = vpi_get(vpiSize, obj_h))
    stream_indent(indent) << "|vpiSize:" << n << "\n";
  if (const int32_t n = vpi_get(vpiVector, obj_h))
    stream_indent(indent) << "|vpiVector:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExpr", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiLeftRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLeftRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiRightRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRightRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiRange, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiRange", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiTypedef, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiTypedef", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_alias_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_clocking_block(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_scope(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiInputEdge, obj_h))
    stream_indent(indent) << "|vpiInputEdge:" << n << "\n";
  if (const int32_t n = vpi_get(vpiOutputEdge, obj_h))
    stream_indent(indent) << "|vpiOutputEdge:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiInputSkew, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiInputSkew", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiOutputSkew, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiOutputSkew", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiClockingEvent, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiClockingEvent", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiInstance, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiInstance", true);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiClockingIODecl, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiClockingIODecl", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiPrefix, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiPrefix", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiActual, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiActual", true);
    release_handle(itr);
  }
}

void VpiVisitor::visit_clocking_io_decl(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiDirection, obj_h))
    stream_indent(indent) << "|vpiDirection:" << n << "\n";
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const int32_t n = vpi_get(vpiInputEdge, obj_h))
    stream_indent(indent) << "|vpiInputEdge:" << n << "\n";
  if (const int32_t n = vpi_get(vpiOutputEdge, obj_h))
    stream_indent(indent) << "|vpiOutputEdge:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiInputSkew, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiInputSkew", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiOutputSkew, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiOutputSkew", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExpr", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_param_assign(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiConnByName, obj_h))
    stream_indent(indent) << "|vpiConnByName:" << n << "\n";
  if (const int32_t n = vpi_get(vpiOverriden, obj_h))
    stream_indent(indent) << "|vpiOverriden:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiRhs, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRhs", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiLhs, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLhs", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_instance_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const char* s = vpi_get_str(vpiFullName, obj_h))
    stream_indent(indent) << "|vpiFullName:" << s << "\n";
  if (const int32_t n = vpi_get(vpiSize, obj_h))
    stream_indent(indent) << "|vpiSize:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExpr", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiRange, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiRange", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiLeftRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLeftRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiRightRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRightRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiInstance, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiInstance", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiModule, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiModule", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiElemTypespec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiElemTypespec", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiPort, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiPort", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_interface_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_instance_array(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiParamAssign, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiParamAssign", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_program_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_instance_array(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_module_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_instance_array(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiParamAssign, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiParamAssign", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_primitive_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_instance_array(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiDelay, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiDelay", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiPrimitive, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiPrimitive", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_gate_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_primitive_array(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_switch_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_primitive_array(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_udp_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_primitive_array(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (vpiHandle itr = vpi_handle(vpiTypedefAlias, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiTypedefAlias", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiInstance, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiInstance", true);
    release_handle(itr);
  }
}

void VpiVisitor::visit_prim_term(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiDirection, obj_h))
    stream_indent(indent) << "|vpiDirection:" << n << "\n";
  if (const int32_t n = vpi_get(vpiTermIndex, obj_h))
    stream_indent(indent) << "|vpiTermIndex:" << n << "\n";
  s_vpi_value value;
  vpi_get_value(obj_h, &value);
  if (value.format) {
    std::string val = visit_value(&value);
    if (!val.empty()) {
      stream_indent(indent) << val;
    }
  }
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExpr", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_path_term(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_tchk_term(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExpr", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiCondition, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiCondition", false);
    release_handle(itr);
  }
  if (const int32_t n = vpi_get(vpiEdge, obj_h))
    stream_indent(indent) << "|vpiEdge:" << n << "\n";
}

void VpiVisitor::visit_nets(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_simple_expr(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiArrayMember, obj_h))
    stream_indent(indent) << "|vpiArrayMember:" << n << "\n";
  if (const int32_t n = vpi_get(vpiConstantSelect, obj_h))
    stream_indent(indent) << "|vpiConstantSelect:" << n << "\n";
  if (const int32_t n = vpi_get(vpiExpanded, obj_h))
    stream_indent(indent) << "|vpiExpanded:" << n << "\n";
  if (const int32_t n = vpi_get(vpiImplicitDecl, obj_h))
    stream_indent(indent) << "|vpiImplicitDecl:" << n << "\n";
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const char* s = vpi_get_str(vpiFullName, obj_h))
    stream_indent(indent) << "|vpiFullName:" << s << "\n";
  if (const int32_t n = vpi_get(vpiNetDeclAssign, obj_h))
    stream_indent(indent) << "|vpiNetDeclAssign:" << n << "\n";
  if (const int32_t n = vpi_get(vpiNetType, obj_h))
    stream_indent(indent) << "|vpiNetType:" << n << "\n";
  if (const int32_t n = vpi_get(vpiResolvedNetType, obj_h))
    stream_indent(indent) << "|vpiResolvedNetType:" << n << "\n";
  if (const int32_t n = vpi_get(vpiScalar, obj_h))
    stream_indent(indent) << "|vpiScalar:" << n << "\n";
  if (const int32_t n = vpi_get(vpiExplicitScalared, obj_h))
    stream_indent(indent) << "|vpiExplicitScalared:" << n << "\n";
  if (const int32_t n = vpi_get(vpiSigned, obj_h))
    stream_indent(indent) << "|vpiSigned:" << n << "\n";
  if (const int32_t n = vpi_get(vpiStrength0, obj_h))
    stream_indent(indent) << "|vpiStrength0:" << n << "\n";
  if (const int32_t n = vpi_get(vpiStrength1, obj_h))
    stream_indent(indent) << "|vpiStrength1:" << n << "\n";
  if (const int32_t n = vpi_get(vpiChargeStrength, obj_h))
    stream_indent(indent) << "|vpiChargeStrength:" << n << "\n";
  if (const int32_t n = vpi_get(vpiVector, obj_h))
    stream_indent(indent) << "|vpiVector:" << n << "\n";
  if (const int32_t n = vpi_get(vpiExplicitVectored, obj_h))
    stream_indent(indent) << "|vpiExplicitVectored:" << n << "\n";
  if (const int32_t n = vpi_get(vpiStructUnionMember, obj_h))
    stream_indent(indent) << "|vpiStructUnionMember:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiPortInst, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiPortInst", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiDriver, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiDriver", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiLoad, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiLoad", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiLocalDriver, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiLocalDriver", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiLocalLoad, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiLocalLoad", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiPrimTerm, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiPrimTerm", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiContAssign, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiContAssign", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiPathTerm, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiPathTerm", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiTchkTerm, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiTchkTerm", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiSimNet, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiSimNet", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiModule, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiModule", true);
    release_handle(itr);
  }
}

void VpiVisitor::visit_net_bit(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_nets(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiIndex, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiIndex", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_net(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_nets(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiBit, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiBit", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiIndex, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiIndex", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_struct_net(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_net(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiPackedArrayMember, obj_h))
    stream_indent(indent) << "|vpiPackedArrayMember:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiMember, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiMember", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_enum_net(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_net(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiPackedArrayMember, obj_h))
    stream_indent(indent) << "|vpiPackedArrayMember:" << n << "\n";
}

void VpiVisitor::visit_integer_net(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_net(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_time_net(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_net(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_logic_net(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_net(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiLeftRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLeftRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiRightRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRightRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiRange, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiRange", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_array_net(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_nets(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiRange, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiRange", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiNet, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiNet", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_packed_array_net(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_net(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiPackedArrayMember, obj_h))
    stream_indent(indent) << "|vpiPackedArrayMember:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiLeftRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLeftRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiRightRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRightRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiRange, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiRange", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiElement, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiElement", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_event_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_named_event(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiArrayMember, obj_h))
    stream_indent(indent) << "|vpiArrayMember:" << n << "\n";
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const char* s = vpi_get_str(vpiFullName, obj_h))
    stream_indent(indent) << "|vpiFullName:" << s << "\n";
  if (const int32_t n = vpi_get(vpiAutomatic, obj_h))
    stream_indent(indent) << "|vpiAutomatic:" << n << "\n";
  if (const int32_t n = vpi_get(vpiAllocScheme, obj_h))
    stream_indent(indent) << "|vpiAllocScheme:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiTypespec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiTypespec", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiWaitingProcesses, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiWaitingProcesses", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (const char* s = vpi_get_str(vpiEndLabel, obj_h))
    stream_indent(indent) << "|vpiEndLabel:" << s << "\n";
}

void VpiVisitor::visit_named_event_array(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_parameter(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_simple_expr(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiConstType, obj_h))
    stream_indent(indent) << "|vpiConstType:" << n << "\n";
  if (const int32_t n = vpi_get(vpiSigned, obj_h))
    stream_indent(indent) << "|vpiSigned:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExpr", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiRange, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiRange", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiLeftRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLeftRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiRightRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRightRange", false);
    release_handle(itr);
  }
  if (const int32_t n = vpi_get(vpiLocalParam, obj_h))
    stream_indent(indent) << "|vpiLocalParam:" << n << "\n";
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const char* s = vpi_get_str(vpiFullName, obj_h))
    stream_indent(indent) << "|vpiFullName:" << s << "\n";
  if (const char* s = vpi_get_str(vpiImported, obj_h))
    stream_indent(indent) << "|vpiImported:" << s << "\n";
}

void VpiVisitor::visit_def_param(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiRhs, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRhs", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiLhs, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLhs", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_spec_param(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_simple_expr(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_class_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiClassType, obj_h))
    stream_indent(indent) << "|vpiClassType:" << n << "\n";
  if (const int32_t n = vpi_get(vpiAutomatic, obj_h))
    stream_indent(indent) << "|vpiAutomatic:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiExtends, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExtends", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiVariables, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiVariables", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiMethod, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiMethod", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiConstraint, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiConstraint", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiParameter, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiParameter", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiParamAssign, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiParamAssign", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiVirtualInterfaceVar, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiVirtualInterfaceVar", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiNamedEvent, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiNamedEvent", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiNamedEventArray, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiNamedEventArray", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiInternalScope, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiInternalScope", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiClassDefn, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiClassDefn", true);
    release_handle(itr);
  }
}

void VpiVisitor::visit_extends(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiClassTypespec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiClassTypespec", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiArgument, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiArgument", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_class_defn(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_scope(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiVirtual, obj_h))
    stream_indent(indent) << "|vpiVirtual:" << n << "\n";
  if (const int32_t n = vpi_get(vpiAutomatic, obj_h))
    stream_indent(indent) << "|vpiAutomatic:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiExtends, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExtends", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiMethod, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiMethod", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiConstraint, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiConstraint", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiDerivedClasses, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiDerivedClasses", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiClassTypespec, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiClassTypespec", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (const char* s = vpi_get_str(vpiEndLabel, obj_h))
    stream_indent(indent) << "|vpiEndLabel:" << s << "\n";
}

void VpiVisitor::visit_class_obj(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_scope(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiObjId, obj_h))
    stream_indent(indent) << "|vpiObjId:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiClassTypespec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiClassTypespec", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiWaitingProcesses, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiWaitingProcesses", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiMessages, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiMessages", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiTaskFunc, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiTaskFunc", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiConstraint, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiConstraint", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_class_var(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_variables(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiObjId, obj_h))
    stream_indent(indent) << "|vpiObjId:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiClassObj, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiClassObj", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_instance(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_scope(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiDefName, obj_h))
    stream_indent(indent) << "|vpiDefName:" << s << "\n";
  if (const int32_t n = vpi_get(vpiArrayMember, obj_h))
    stream_indent(indent) << "|vpiArrayMember:" << n << "\n";
  if (const int32_t n = vpi_get(vpiCellInstance, obj_h))
    stream_indent(indent) << "|vpiCellInstance:" << n << "\n";
  if (const int32_t n = vpi_get(vpiDefNetType, obj_h))
    stream_indent(indent) << "|vpiDefNetType:" << n << "\n";
  if (const char* s = vpi_get_str(vpiDefFile, obj_h))
    stream_indent(indent) << "|vpiDefFile:" << s << "\n";
  if (const int32_t n = vpi_get(vpiDefLineNo, obj_h))
    stream_indent(indent) << "|vpiDefLineNo:" << n << "\n";
  if (const int32_t n = vpi_get(vpiDefDelayMode, obj_h))
    stream_indent(indent) << "|vpiDefDelayMode:" << n << "\n";
  if (const int32_t n = vpi_get(vpiProtected, obj_h))
    stream_indent(indent) << "|vpiProtected:" << n << "\n";
  if (const int32_t n = vpi_get(vpiTimePrecision, obj_h))
    stream_indent(indent) << "|vpiTimePrecision:" << n << "\n";
  if (const int32_t n = vpi_get(vpiTimeUnit, obj_h))
    stream_indent(indent) << "|vpiTimeUnit:" << n << "\n";
  if (const int32_t n = vpi_get(vpiUnconnDrive, obj_h))
    stream_indent(indent) << "|vpiUnconnDrive:" << n << "\n";
  if (const char* s = vpi_get_str(vpiLibrary, obj_h))
    stream_indent(indent) << "|vpiLibrary:" << s << "\n";
  if (const char* s = vpi_get_str(vpiCell, obj_h))
    stream_indent(indent) << "|vpiCell:" << s << "\n";
  if (const char* s = vpi_get_str(vpiConfig, obj_h))
    stream_indent(indent) << "|vpiConfig:" << s << "\n";
  if (const int32_t n = vpi_get(vpiAutomatic, obj_h))
    stream_indent(indent) << "|vpiAutomatic:" << n << "\n";
  if (const int32_t n = vpi_get(vpiTop, obj_h))
    stream_indent(indent) << "|vpiTop:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiProgram, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiProgram", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiProgramArray, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiProgramArray", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiClassDefn, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiClassDefn", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiTaskFunc, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiTaskFunc", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiNet, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiNet", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiArrayNet, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiArrayNet", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiSpecParam, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiSpecParam", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiAssertion, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAssertion", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiModule, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiModule", true);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiInstance, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiInstance", true);
    release_handle(itr);
  }
}

void VpiVisitor::visit_interface_inst(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_instance(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiIndex, obj_h))
    stream_indent(indent) << "|vpiIndex:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiInterfaceTfDecl, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiInterfaceTfDecl", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiModport, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiModport", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiGlobalClocking, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiGlobalClocking", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiDefaultClocking, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiDefaultClocking", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiDefaultDisableIff, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiDefaultDisableIff", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiInstanceArray, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiInstanceArray", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiModPath, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiModPath", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiContAssign, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiContAssign", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiClockingBlock, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiClockingBlock", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiInterface, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiInterface", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiInterfaceArray, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiInterfaceArray", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiProcess, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiProcess", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiPort, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiPort", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiGenScopeArray, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiGenScopeArray", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiSysTaskCall, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiSysTaskCall", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiGenStmt, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiGenStmt", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (const char* s = vpi_get_str(vpiEndLabel, obj_h))
    stream_indent(indent) << "|vpiEndLabel:" << s << "\n";
}

void VpiVisitor::visit_program(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_instance(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiIndex, obj_h))
    stream_indent(indent) << "|vpiIndex:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiDefaultClocking, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiDefaultClocking", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiInstanceArray, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiInstanceArray", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiInterface, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiInterface", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiDefaultDisableIff, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiDefaultDisableIff", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiInterfaceArray, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiInterfaceArray", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiProcess, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiProcess", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiContAssign, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiContAssign", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiClockingBlock, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiClockingBlock", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiPort, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiPort", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiGenScopeArray, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiGenScopeArray", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (const char* s = vpi_get_str(vpiEndLabel, obj_h))
    stream_indent(indent) << "|vpiEndLabel:" << s << "\n";
}

void VpiVisitor::visit_package(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_instance(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiUnit, obj_h))
    stream_indent(indent) << "|vpiUnit:" << n << "\n";
  if (const char* s = vpi_get_str(vpiEndLabel, obj_h))
    stream_indent(indent) << "|vpiEndLabel:" << s << "\n";
}

void VpiVisitor::visit_module_inst(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_instance(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiIndex, obj_h))
    stream_indent(indent) << "|vpiIndex:" << n << "\n";
  if (const int32_t n = vpi_get(vpiTopModule, obj_h))
    stream_indent(indent) << "|vpiTopModule:" << n << "\n";
  if (const int32_t n = vpi_get(vpiDefDecayTime, obj_h))
    stream_indent(indent) << "|vpiDefDecayTime:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiGlobalClocking, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiGlobalClocking", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiDefaultClocking, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiDefaultClocking", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiDefaultDisableIff, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiDefaultDisableIff", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiModuleArray, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiModuleArray", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiInstanceArray, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiInstanceArray", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiPort, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiPort", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiInterface, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiInterface", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiInterfaceArray, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiInterfaceArray", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiProcess, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiProcess", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiModule, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiModule", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiModuleArray, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiModuleArray", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiGenScopeArray, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiGenScopeArray", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiContAssign, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiContAssign", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiPrimitive, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiPrimitive", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiPrimitiveArray, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiPrimitiveArray", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiModPath, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiModPath", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiTchk, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiTchk", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiDefParam, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiDefParam", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiIODecl, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiIODecl", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiAliasStmt, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAliasStmt", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiClockingBlock, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiClockingBlock", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiSysTaskCall, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiSysTaskCall", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiRefModule, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiRefModule", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiGenStmt, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiGenStmt", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (const char* s = vpi_get_str(vpiEndLabel, obj_h))
    stream_indent(indent) << "|vpiEndLabel:" << s << "\n";
}

void VpiVisitor::visit_checker_decl(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_instance(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiDefaultClocking, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiDefaultClocking", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiProcess, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiProcess", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiContAssign, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiContAssign", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiPort, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiPort", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_checker_inst(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_instance(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiPort, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiPort", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_short_real_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiFunction, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiFunction", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_real_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiFunction, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiFunction", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_byte_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiSigned, obj_h))
    stream_indent(indent) << "|vpiSigned:" << n << "\n";
}

void VpiVisitor::visit_short_int_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiSigned, obj_h))
    stream_indent(indent) << "|vpiSigned:" << n << "\n";
}

void VpiVisitor::visit_int_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
  s_vpi_value value;
  vpi_get_value(obj_h, &value);
  if (value.format) {
    std::string val = visit_value(&value);
    if (!val.empty()) {
      stream_indent(indent) << val;
    }
  }
  if (vpiHandle itr = vpi_handle(vpiExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExpr", false);
    release_handle(itr);
  }
  if (const int32_t n = vpi_get(vpiSigned, obj_h))
    stream_indent(indent) << "|vpiSigned:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiRange, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiRange", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_long_int_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiSigned, obj_h))
    stream_indent(indent) << "|vpiSigned:" << n << "\n";
}

void VpiVisitor::visit_integer_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
  s_vpi_value value;
  vpi_get_value(obj_h, &value);
  if (value.format) {
    std::string val = visit_value(&value);
    if (!val.empty()) {
      stream_indent(indent) << val;
    }
  }
  if (vpiHandle itr = vpi_handle(vpiExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExpr", false);
    release_handle(itr);
  }
  if (const int32_t n = vpi_get(vpiSigned, obj_h))
    stream_indent(indent) << "|vpiSigned:" << n << "\n";
}

void VpiVisitor::visit_time_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiSigned, obj_h))
    stream_indent(indent) << "|vpiSigned:" << n << "\n";
}

void VpiVisitor::visit_enum_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiBaseTypespec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiBaseTypespec", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiEnumConst, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiEnumConst", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_string_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_chandle_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_module_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_struct_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiPacked, obj_h))
    stream_indent(indent) << "|vpiPacked:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiTypespecMember, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiTypespecMember", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiFunction, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiFunction", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_union_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiPacked, obj_h))
    stream_indent(indent) << "|vpiPacked:" << n << "\n";
  if (const int32_t n = vpi_get(vpiTagged, obj_h))
    stream_indent(indent) << "|vpiTagged:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiTypespecMember, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiTypespecMember", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_logic_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiVector, obj_h))
    stream_indent(indent) << "|vpiVector:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiElemTypespec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiElemTypespec", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiRange, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiRange", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiLeftRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLeftRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiRightRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRightRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiIndexTypespec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiIndexTypespec", false);
    release_handle(itr);
  }
  if (const int32_t n = vpi_get(vpiSigned, obj_h))
    stream_indent(indent) << "|vpiSigned:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiFunction, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiFunction", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_packed_array_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiVector, obj_h))
    stream_indent(indent) << "|vpiVector:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiRange, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiRange", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiLeftRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLeftRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiRightRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRightRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiElemTypespec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiElemTypespec", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiIndexTypespec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiIndexTypespec", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiFunction, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiFunction", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_array_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiArrayType, obj_h))
    stream_indent(indent) << "|vpiArrayType:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiRange, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiRange", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiLeftRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLeftRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiRightRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRightRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiIndexTypespec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiIndexTypespec", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiElemTypespec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiElemTypespec", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiFunction, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiFunction", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_void_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_unsupported_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiPacked, obj_h))
    stream_indent(indent) << "|vpiPacked:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiRange, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiRange", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_sequence_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_property_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_interface_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiDefName, obj_h))
    stream_indent(indent) << "|vpiDefName:" << s << "\n";
  if (const int32_t n = vpi_get(vpiIsModPort, obj_h))
    stream_indent(indent) << "|vpiIsModPort:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiParamAssign, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiParamAssign", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_type_parameter(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiLocalParam, obj_h))
    stream_indent(indent) << "|vpiLocalParam:" << n << "\n";
  if (const char* s = vpi_get_str(vpiFullName, obj_h))
    stream_indent(indent) << "|vpiFullName:" << s << "\n";
  if (vpiHandle itr = vpi_handle(vpiTypespec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiTypespec", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExpr", false);
    release_handle(itr);
  }
  if (const char* s = vpi_get_str(vpiImported, obj_h))
    stream_indent(indent) << "|vpiImported:" << s << "\n";
}

void VpiVisitor::visit_typespec_member(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const int32_t n = vpi_get(vpiRandType, obj_h))
    stream_indent(indent) << "|vpiRandType:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiTypespec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiTypespec", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExpr", false);
    release_handle(itr);
  }
  if (const char* s = vpi_get_str(vpiRefFile, obj_h))
    stream_indent(indent) << "|vpiRefFile:" << s << "\n";
  if (const int32_t n = vpi_get(vpiRefLineNo, obj_h))
    stream_indent(indent) << "|vpiRefLineNo:" << n << "\n";
  if (const int32_t n = vpi_get(vpiRefColumnNo, obj_h))
    stream_indent(indent) << "|vpiRefColumnNo:" << n << "\n";
  if (const int32_t n = vpi_get(vpiRefEndLineNo, obj_h))
    stream_indent(indent) << "|vpiRefEndLineNo:" << n << "\n";
  if (const int32_t n = vpi_get(vpiRefEndColumnNo, obj_h))
    stream_indent(indent) << "|vpiRefEndColumnNo:" << n << "\n";
}

void VpiVisitor::visit_enum_const(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  s_vpi_value value;
  vpi_get_value(obj_h, &value);
  if (value.format) {
    std::string val = visit_value(&value);
    if (!val.empty()) {
      stream_indent(indent) << val;
    }
  }
  if (const char* s = vpi_get_str(vpiDecompile, obj_h))
    stream_indent(indent) << "|vpiDecompile:" << s << "\n";
  if (const int32_t n = vpi_get(vpiSize, obj_h))
    stream_indent(indent) << "|vpiSize:" << n << "\n";
}

void VpiVisitor::visit_bit_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiVector, obj_h))
    stream_indent(indent) << "|vpiVector:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiElemTypespec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiElemTypespec", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiRange, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiRange", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiLeftRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiLeftRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiRightRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiRightRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiIndexTypespec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiIndexTypespec", false);
    release_handle(itr);
  }
  if (const int32_t n = vpi_get(vpiSigned, obj_h))
    stream_indent(indent) << "|vpiSigned:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiFunction, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiFunction", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_tf_call(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_expr(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiScope, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiScope", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiArgument, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiArgument", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
}

void VpiVisitor::visit_user_systf(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_sys_func_call(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_tf_call(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiFuncType, obj_h))
    stream_indent(indent) << "|vpiFuncType:" << n << "\n";
  if (const int32_t n = vpi_get(vpiUserDefn, obj_h))
    stream_indent(indent) << "|vpiUserDefn:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiUserSystf, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiUserSystf", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_sys_task_call(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_tf_call(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiUserDefn, obj_h))
    stream_indent(indent) << "|vpiUserDefn:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiUserSystf, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiUserSystf", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_method_func_call(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_tf_call(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiUserDefn, obj_h))
    stream_indent(indent) << "|vpiUserDefn:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiPrefix, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiPrefix", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiWith, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiWith", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiFunction, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiFunction", true);
    release_handle(itr);
  }
}

void VpiVisitor::visit_method_task_call(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_tf_call(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiUserDefn, obj_h))
    stream_indent(indent) << "|vpiUserDefn:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiPrefix, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiPrefix", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiWith, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiWith", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiTask, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiTask", true);
    release_handle(itr);
  }
}

void VpiVisitor::visit_func_call(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_tf_call(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiFuncType, obj_h))
    stream_indent(indent) << "|vpiFuncType:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiFunction, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiFunction", true);
    release_handle(itr);
  }
}

void VpiVisitor::visit_task_call(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_tf_call(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiTask, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiTask", true);
    release_handle(itr);
  }
}

void VpiVisitor::visit_constraint_expr(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
}

void VpiVisitor::visit_constraint_ordering(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_iterate(vpiSolveBefore, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiSolveBefore", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiSolveAfter, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiSolveAfter", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_constraint(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (const char* s = vpi_get_str(vpiFullName, obj_h))
    stream_indent(indent) << "|vpiFullName:" << s << "\n";
  if (const int32_t n = vpi_get(vpiVirtual, obj_h))
    stream_indent(indent) << "|vpiVirtual:" << n << "\n";
  if (const int32_t n = vpi_get(vpiAutomatic, obj_h))
    stream_indent(indent) << "|vpiAutomatic:" << n << "\n";
  if (const int32_t n = vpi_get(vpiAllocScheme, obj_h))
    stream_indent(indent) << "|vpiAllocScheme:" << n << "\n";
  if (const int32_t n = vpi_get(vpiAccessType, obj_h))
    stream_indent(indent) << "|vpiAccessType:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (const int32_t n = vpi_get(vpiIsConstraintEnabled, obj_h))
    stream_indent(indent) << "|vpiIsConstraintEnabled:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiConstraintItem, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiConstraintItem", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_import_typespec(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_typespec(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiImportTypespec, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiImportTypespec", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_dist_item(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiDistType, obj_h))
    stream_indent(indent) << "|vpiDistType:" << n << "\n";
  if (vpiHandle itr = vpi_handle(vpiValueRange, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiValueRange", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiWeight, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiWeight", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_distribution(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_constraint_expr(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiSoft, obj_h))
    stream_indent(indent) << "|vpiSoft:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiDistItem, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiDistItem", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExpr", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_implication(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_constraint_expr(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiCondition, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiCondition", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiConstraintExpr, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiConstraintExpr", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_constr_if(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_constraint_expr(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiCondition, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiCondition", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiConstraintExpr, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiConstraintExpr", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_constr_if_else(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_constraint_expr(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiCondition, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiCondition", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiConstraintExpr, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiConstraintExpr", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiElseConst, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiElseConst", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_constr_foreach(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_constraint_expr(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiVariables, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiVariables", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiLoopVars, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiLoopVars", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiConstraintExpr, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiConstraintExpr", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_soft_disable(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_constraint_expr(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiExpr, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiExpr", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_gen_stmt(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (vpiHandle itr = vpi_iterate(vpiAttribute, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiAttribute", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_gen_if(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_gen_stmt(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiCondition, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiCondition", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_gen_if_else(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_gen_stmt(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiCondition, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiCondition", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiElseStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiElseStmt", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_gen_for(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_gen_stmt(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiLocalVarDecls, obj_h))
    stream_indent(indent) << "|vpiLocalVarDecls:" << n << "\n";
  if (vpiHandle itr = vpi_iterate(vpiForInitStmt, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiForInitStmt", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiForIncStmt, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiForIncStmt", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiForInitStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiForInitStmt", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiCondition, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiCondition", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiForIncStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiForIncStmt", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_gen_case(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_gen_stmt(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiCondition, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiCondition", false);
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiCaseItem, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiCaseItem", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}

void VpiVisitor::visit_gen_region(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_gen_stmt(obj_h, indent, relation, shallowVisit);
  if (vpiHandle itr = vpi_handle(vpiStmt, obj_h)) {
    visit_object(itr, indent + kLevelIndent, "vpiStmt", false);
    release_handle(itr);
  }
}

void VpiVisitor::visit_design(vpiHandle obj_h, int32_t indent, const char *relation, bool shallowVisit) {
  visit_baseclass(obj_h, indent, relation, shallowVisit);
  if (const int32_t n = vpi_get(vpiElaborated, obj_h))
    stream_indent(indent) << "|vpiElaborated:" << n << "\n";
  if (const char* s = vpi_get_str(vpiName, obj_h))
    stream_indent(indent) << "|vpiName:" << s << "\n";
  if (vpiHandle itr = vpi_iterate(vpiIncludeFileInfo, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiIncludeFileInfo", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(uhdmallPackages, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "uhdmallPackages", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(uhdmtopPackages, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "uhdmtopPackages", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(uhdmallClasses, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "uhdmallClasses", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(uhdmallInterfaces, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "uhdmallInterfaces", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(uhdmallUdps, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "uhdmallUdps", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(uhdmallPrograms, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "uhdmallPrograms", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(uhdmallModules, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "uhdmallModules", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiTypedef, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiTypedef", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiLetDecl, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiLetDecl", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiTaskFunc, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiTaskFunc", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiParameter, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiParameter", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(vpiParamAssign, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "vpiParamAssign", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
  if (vpiHandle itr = vpi_iterate(uhdmtopModules, obj_h)) {
    while (vpiHandle obj = vpi_scan(itr)) {
      visit_object(obj, indent + kLevelIndent, "uhdmtopModules", false);
      release_handle(obj);
    }
    release_handle(itr);
  }
}


void VpiVisitor::visit_object(vpiHandle obj_h, int32_t indent,
                              const char* relation, bool shallowVisit) {
  if (!obj_h) return;

#ifdef STANDARD_VPI
  const bool alreadyVisited = m_visited,find(obj_h) != m_visited.end();
  m_visited.insert(obj_h);
#else
  const uhdm_handle* const handle = (const uhdm_handle*) obj_h;
  const BaseClass* const object = (const BaseClass*) handle->object;
  const bool alreadyVisited = (m_visited.find(object) != m_visited.end());
  if (!shallowVisit)
    m_visited.insert(object);
#endif

  const uint32_t objectType = vpi_get(vpiType, obj_h);

  std::string hspaces;
  std::string rspaces;
  if (indent >= kLevelIndent) {
    hspaces = std::string(indent - 2, ' ');
    rspaces.assign(hspaces).append("|");
    hspaces.append("\\_");
  }

  if (strlen(relation) != 0) {
    m_out << rspaces << relation << ":\n";
  }

#ifdef STANDARD_VPI
  m_out << hspaces << vpiTypeName(obj_h) << "(" << vpi_get(vpiType, obj_h) << "): ";
#else
  m_out << hspaces << UHDM::VpiTypeName(obj_h) << ": ";
#endif

  bool needs_separator = false;
  if (const char* s = vpi_get_str(vpiDefName, obj_h)) {  // defName
    m_out << s;
    needs_separator = true;
  }
  if (const char* s1 = vpi_get_str(vpiFullName, obj_h)) {   // objectName
    if (needs_separator) m_out << " ";
    m_out << "(" << s1 << ")";  // objectName
  } else if (const char* s2 = vpi_get_str(vpiName, obj_h)) {   // objectName
    if (needs_separator) m_out << " ";
    m_out << "(" << s2 << ")";  // objectName
  }

#ifndef STANDARD_VPI
  if (showIDs) m_out << ", id:" << object->UhdmId();
#endif

  if ((objectType == vpiModule) || (objectType == vpiProgram) ||
      (objectType == vpiClassDefn) || (objectType == vpiPackage) ||
      (objectType == vpiInterface) || (objectType == vpiUdp) ||
      (objectType == vpiIncludeFileInfo)) {
    if (const char* s = vpi_get_str(vpiFile, obj_h)) {
      m_out << ", file:" << s;  // fileName
    }
  }

  if (uint32_t sl = vpi_get(vpiLineNo, obj_h)) {
    m_out << ", line:" << sl << ":" << vpi_get(vpiColumnNo, obj_h);

    if (uint32_t el = vpi_get(vpiEndLineNo, obj_h)) {
      m_out << ", endln:" << el << ":" << vpi_get(vpiEndColumnNo, obj_h);  // , endline, endCol
    }
  }
  m_out << "\n";

  if (!alreadyVisited && shallowVisit) {
    m_weaklyReferenced1.emplace(object);
  }

  if (alreadyVisited || shallowVisit) {
    return;
  }

  AnySet::const_iterator it = m_weaklyReferenced1.find(object);
  if (it != m_weaklyReferenced1.end()) m_weaklyReferenced1.erase(it);

  switch (objectType) {
    case vpiAliasStmt: visit_alias_stmt(obj_h, indent, relation, shallowVisit); break;
    case vpiAlways: visit_always(obj_h, indent, relation, shallowVisit); break;
    case vpiAnyPattern: visit_any_pattern(obj_h, indent, relation, shallowVisit); break;
    case vpiArrayExpr: visit_array_expr(obj_h, indent, relation, shallowVisit); break;
    case vpiArrayNet: visit_array_net(obj_h, indent, relation, shallowVisit); break;
    case vpiArrayTypespec: visit_array_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiArrayVar: visit_array_var(obj_h, indent, relation, shallowVisit); break;
    case vpiAssert: visit_assert_stmt(obj_h, indent, relation, shallowVisit); break;
    case vpiAssignStmt: visit_assign_stmt(obj_h, indent, relation, shallowVisit); break;
    case vpiAssignment: visit_assignment(obj_h, indent, relation, shallowVisit); break;
    case vpiAssume: visit_assume(obj_h, indent, relation, shallowVisit); break;
    case vpiAttribute: visit_attribute(obj_h, indent, relation, shallowVisit); break;
    case vpiBegin: visit_begin(obj_h, indent, relation, shallowVisit); break;
    case vpiBitSelect: visit_bit_select(obj_h, indent, relation, shallowVisit); break;
    case vpiBitTypespec: visit_bit_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiBitVar: visit_bit_var(obj_h, indent, relation, shallowVisit); break;
    case vpiBreak: visit_break_stmt(obj_h, indent, relation, shallowVisit); break;
    case vpiByteTypespec: visit_byte_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiByteVar: visit_byte_var(obj_h, indent, relation, shallowVisit); break;
    case vpiCase: visit_case_stmt(obj_h, indent, relation, shallowVisit); break;
    case vpiCaseItem: visit_case_item(obj_h, indent, relation, shallowVisit); break;
    case vpiCaseProperty: visit_case_property(obj_h, indent, relation, shallowVisit); break;
    case vpiCasePropertyItem: visit_case_property_item(obj_h, indent, relation, shallowVisit); break;
    case vpiChandleTypespec: visit_chandle_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiChandleVar: visit_chandle_var(obj_h, indent, relation, shallowVisit); break;
    case vpiCheckerDecl: visit_checker_decl(obj_h, indent, relation, shallowVisit); break;
    case vpiCheckerInst: visit_checker_inst(obj_h, indent, relation, shallowVisit); break;
    case vpiCheckerInstPort: visit_checker_inst_port(obj_h, indent, relation, shallowVisit); break;
    case vpiCheckerPort: visit_checker_port(obj_h, indent, relation, shallowVisit); break;
    case vpiClassDefn: visit_class_defn(obj_h, indent, relation, shallowVisit); break;
    case vpiClassObj: visit_class_obj(obj_h, indent, relation, shallowVisit); break;
    case vpiClassTypespec: visit_class_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiClassVar: visit_class_var(obj_h, indent, relation, shallowVisit); break;
    case vpiClockedProp: visit_clocked_property(obj_h, indent, relation, shallowVisit); break;
    case vpiClockedSeq: visit_clocked_seq(obj_h, indent, relation, shallowVisit); break;
    case vpiClockingBlock: visit_clocking_block(obj_h, indent, relation, shallowVisit); break;
    case vpiClockingIODecl: visit_clocking_io_decl(obj_h, indent, relation, shallowVisit); break;
    case vpiConcurrentAssertions: visit_concurrent_assertions(obj_h, indent, relation, shallowVisit); break;
    case vpiConstant: visit_constant(obj_h, indent, relation, shallowVisit); break;
    case vpiConstrForEach: visit_constr_foreach(obj_h, indent, relation, shallowVisit); break;
    case vpiConstrIf: visit_constr_if(obj_h, indent, relation, shallowVisit); break;
    case vpiConstrIfElse: visit_constr_if_else(obj_h, indent, relation, shallowVisit); break;
    case vpiConstraint: visit_constraint(obj_h, indent, relation, shallowVisit); break;
    case vpiConstraintExpr: visit_constraint_expr(obj_h, indent, relation, shallowVisit); break;
    case vpiConstraintOrdering: visit_constraint_ordering(obj_h, indent, relation, shallowVisit); break;
    case vpiContAssign: visit_cont_assign(obj_h, indent, relation, shallowVisit); break;
    case vpiContAssignBit: visit_cont_assign_bit(obj_h, indent, relation, shallowVisit); break;
    case vpiContinue: visit_continue_stmt(obj_h, indent, relation, shallowVisit); break;
    case vpiCover: visit_cover(obj_h, indent, relation, shallowVisit); break;
    case vpiDeassign: visit_deassign(obj_h, indent, relation, shallowVisit); break;
    case vpiDefParam: visit_def_param(obj_h, indent, relation, shallowVisit); break;
    case vpiDelayControl: visit_delay_control(obj_h, indent, relation, shallowVisit); break;
    case vpiDelayTerm: visit_delay_term(obj_h, indent, relation, shallowVisit); break;
    case vpiDesign: visit_design(obj_h, indent, relation, shallowVisit); break;
    case vpiDisable: visit_disable(obj_h, indent, relation, shallowVisit); break;
    case vpiDisableFork: visit_disable_fork(obj_h, indent, relation, shallowVisit); break;
    case vpiDisables: visit_disables(obj_h, indent, relation, shallowVisit); break;
    case vpiDistItem: visit_dist_item(obj_h, indent, relation, shallowVisit); break;
    case vpiDistribution: visit_distribution(obj_h, indent, relation, shallowVisit); break;
    case vpiDoWhile: visit_do_while(obj_h, indent, relation, shallowVisit); break;
    case vpiEnumConst: visit_enum_const(obj_h, indent, relation, shallowVisit); break;
    case vpiEnumNet: visit_enum_net(obj_h, indent, relation, shallowVisit); break;
    case vpiEnumTypespec: visit_enum_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiEnumVar: visit_enum_var(obj_h, indent, relation, shallowVisit); break;
    case vpiEventControl: visit_event_control(obj_h, indent, relation, shallowVisit); break;
    case vpiEventStmt: visit_event_stmt(obj_h, indent, relation, shallowVisit); break;
    case vpiEventTypespec: visit_event_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiExpectStmt: visit_expect_stmt(obj_h, indent, relation, shallowVisit); break;
    case vpiExpr: visit_expr(obj_h, indent, relation, shallowVisit); break;
    case vpiExtends: visit_extends(obj_h, indent, relation, shallowVisit); break;
    case vpiFinal: visit_final_stmt(obj_h, indent, relation, shallowVisit); break;
    case vpiFor: visit_for_stmt(obj_h, indent, relation, shallowVisit); break;
    case vpiForce: visit_force(obj_h, indent, relation, shallowVisit); break;
    case vpiForeachStmt: visit_foreach_stmt(obj_h, indent, relation, shallowVisit); break;
    case vpiForever: visit_forever_stmt(obj_h, indent, relation, shallowVisit); break;
    case vpiFork: visit_fork_stmt(obj_h, indent, relation, shallowVisit); break;
    case vpiFuncCall: visit_func_call(obj_h, indent, relation, shallowVisit); break;
    case vpiFunction: visit_function(obj_h, indent, relation, shallowVisit); break;
    case vpiGate: visit_gate(obj_h, indent, relation, shallowVisit); break;
    case vpiGateArray: visit_gate_array(obj_h, indent, relation, shallowVisit); break;
    case vpiGenCase: visit_gen_case(obj_h, indent, relation, shallowVisit); break;
    case vpiGenFor: visit_gen_for(obj_h, indent, relation, shallowVisit); break;
    case vpiGenIf: visit_gen_if(obj_h, indent, relation, shallowVisit); break;
    case vpiGenIfElse: visit_gen_if_else(obj_h, indent, relation, shallowVisit); break;
    case vpiGenRegion: visit_gen_region(obj_h, indent, relation, shallowVisit); break;
    case vpiGenScope: visit_gen_scope(obj_h, indent, relation, shallowVisit); break;
    case vpiGenScopeArray: visit_gen_scope_array(obj_h, indent, relation, shallowVisit); break;
    case vpiGenStmt: visit_gen_stmt(obj_h, indent, relation, shallowVisit); break;
    case vpiGenVar: visit_gen_var(obj_h, indent, relation, shallowVisit); break;
    case vpiHierPath: visit_hier_path(obj_h, indent, relation, shallowVisit); break;
    case vpiIODecl: visit_io_decl(obj_h, indent, relation, shallowVisit); break;
    case vpiIf: visit_if_stmt(obj_h, indent, relation, shallowVisit); break;
    case vpiIfElse: visit_if_else(obj_h, indent, relation, shallowVisit); break;
    case vpiImmediateAssert: visit_immediate_assert(obj_h, indent, relation, shallowVisit); break;
    case vpiImmediateAssume: visit_immediate_assume(obj_h, indent, relation, shallowVisit); break;
    case vpiImmediateCover: visit_immediate_cover(obj_h, indent, relation, shallowVisit); break;
    case vpiImplication: visit_implication(obj_h, indent, relation, shallowVisit); break;
    case vpiImportTypespec: visit_import_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiIncludeFileInfo: visit_include_file_info(obj_h, indent, relation, shallowVisit); break;
    case vpiIndexedPartSelect: visit_indexed_part_select(obj_h, indent, relation, shallowVisit); break;
    case vpiInitial: visit_initial(obj_h, indent, relation, shallowVisit); break;
    case vpiInstance: visit_instance(obj_h, indent, relation, shallowVisit); break;
    case vpiInstanceArray: visit_instance_array(obj_h, indent, relation, shallowVisit); break;
    case vpiIntTypespec: visit_int_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiIntVar: visit_int_var(obj_h, indent, relation, shallowVisit); break;
    case vpiIntegerNet: visit_integer_net(obj_h, indent, relation, shallowVisit); break;
    case vpiIntegerTypespec: visit_integer_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiIntegerVar: visit_integer_var(obj_h, indent, relation, shallowVisit); break;
    case vpiInterface: visit_interface_inst(obj_h, indent, relation, shallowVisit); break;
    case vpiInterfaceArray: visit_interface_array(obj_h, indent, relation, shallowVisit); break;
    case vpiInterfaceTfDecl: visit_interface_tf_decl(obj_h, indent, relation, shallowVisit); break;
    case vpiInterfaceTypespec: visit_interface_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiLetDecl: visit_let_decl(obj_h, indent, relation, shallowVisit); break;
    case vpiLetExpr: visit_let_expr(obj_h, indent, relation, shallowVisit); break;
    case vpiLogicNet: visit_logic_net(obj_h, indent, relation, shallowVisit); break;
    case vpiLogicTypespec: visit_logic_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiLogicVar: visit_logic_var(obj_h, indent, relation, shallowVisit); break;
    case vpiLongIntTypespec: visit_long_int_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiLongIntVar: visit_long_int_var(obj_h, indent, relation, shallowVisit); break;
    case vpiMethodFuncCall: visit_method_func_call(obj_h, indent, relation, shallowVisit); break;
    case vpiMethodTaskCall: visit_method_task_call(obj_h, indent, relation, shallowVisit); break;
    case vpiModPath: visit_mod_path(obj_h, indent, relation, shallowVisit); break;
    case vpiModport: visit_modport(obj_h, indent, relation, shallowVisit); break;
    case vpiModule: visit_module_inst(obj_h, indent, relation, shallowVisit); break;
    case vpiModuleArray: visit_module_array(obj_h, indent, relation, shallowVisit); break;
    case vpiModuleTypespec: visit_module_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiMulticlockSequenceExpr: visit_multiclock_sequence_expr(obj_h, indent, relation, shallowVisit); break;
    case vpiNamedBegin: visit_named_begin(obj_h, indent, relation, shallowVisit); break;
    case vpiNamedEvent: visit_named_event(obj_h, indent, relation, shallowVisit); break;
    case vpiNamedEventArray: visit_named_event_array(obj_h, indent, relation, shallowVisit); break;
    case vpiNamedFork: visit_named_fork(obj_h, indent, relation, shallowVisit); break;
    case vpiNetBit: visit_net_bit(obj_h, indent, relation, shallowVisit); break;
    case vpiNets: visit_nets(obj_h, indent, relation, shallowVisit); break;
    case vpiNullStmt: visit_null_stmt(obj_h, indent, relation, shallowVisit); break;
    case vpiOperation: visit_operation(obj_h, indent, relation, shallowVisit); break;
    case vpiOrderedWait: visit_ordered_wait(obj_h, indent, relation, shallowVisit); break;
    case vpiPackage: visit_package(obj_h, indent, relation, shallowVisit); break;
    case vpiPackedArrayNet: visit_packed_array_net(obj_h, indent, relation, shallowVisit); break;
    case vpiPackedArrayTypespec: visit_packed_array_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiPackedArrayVar: visit_packed_array_var(obj_h, indent, relation, shallowVisit); break;
    case vpiParamAssign: visit_param_assign(obj_h, indent, relation, shallowVisit); break;
    case vpiParameter: visit_parameter(obj_h, indent, relation, shallowVisit); break;
    case vpiPartSelect: visit_part_select(obj_h, indent, relation, shallowVisit); break;
    case vpiPathTerm: visit_path_term(obj_h, indent, relation, shallowVisit); break;
    case vpiPort: visit_port(obj_h, indent, relation, shallowVisit); break;
    case vpiPortBit: visit_port_bit(obj_h, indent, relation, shallowVisit); break;
    case vpiPorts: visit_ports(obj_h, indent, relation, shallowVisit); break;
    case vpiPrimTerm: visit_prim_term(obj_h, indent, relation, shallowVisit); break;
    case vpiPrimitive: visit_primitive(obj_h, indent, relation, shallowVisit); break;
    case vpiPrimitiveArray: visit_primitive_array(obj_h, indent, relation, shallowVisit); break;
    case vpiProcess: visit_process_stmt(obj_h, indent, relation, shallowVisit); break;
    case vpiProgram: visit_program(obj_h, indent, relation, shallowVisit); break;
    case vpiProgramArray: visit_program_array(obj_h, indent, relation, shallowVisit); break;
    case vpiPropFormalDecl: visit_prop_formal_decl(obj_h, indent, relation, shallowVisit); break;
    case vpiPropertyDecl: visit_property_decl(obj_h, indent, relation, shallowVisit); break;
    case vpiPropertyInst: visit_property_inst(obj_h, indent, relation, shallowVisit); break;
    case vpiPropertySpec: visit_property_spec(obj_h, indent, relation, shallowVisit); break;
    case vpiPropertyTypespec: visit_property_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiRange: visit_range(obj_h, indent, relation, shallowVisit); break;
    case vpiRealTypespec: visit_real_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiRealVar: visit_real_var(obj_h, indent, relation, shallowVisit); break;
    case vpiRefModule: visit_ref_module(obj_h, indent, relation, shallowVisit); break;
    case vpiRefObj: visit_ref_obj(obj_h, indent, relation, shallowVisit); break;
    case vpiRefTypespec: visit_ref_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiRefVar: visit_ref_var(obj_h, indent, relation, shallowVisit); break;
    case vpiReg: visit_reg(obj_h, indent, relation, shallowVisit); break;
    case vpiRegArray: visit_reg_array(obj_h, indent, relation, shallowVisit); break;
    case vpiRelease: visit_release(obj_h, indent, relation, shallowVisit); break;
    case vpiRepeat: visit_repeat(obj_h, indent, relation, shallowVisit); break;
    case vpiRepeatControl: visit_repeat_control(obj_h, indent, relation, shallowVisit); break;
    case vpiRestrict: visit_restrict(obj_h, indent, relation, shallowVisit); break;
    case vpiReturn: visit_return_stmt(obj_h, indent, relation, shallowVisit); break;
    case vpiScope: visit_scope(obj_h, indent, relation, shallowVisit); break;
    case vpiSeqFormalDecl: visit_seq_formal_decl(obj_h, indent, relation, shallowVisit); break;
    case vpiSequenceDecl: visit_sequence_decl(obj_h, indent, relation, shallowVisit); break;
    case vpiSequenceInst: visit_sequence_inst(obj_h, indent, relation, shallowVisit); break;
    case vpiSequenceTypespec: visit_sequence_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiShortIntTypespec: visit_short_int_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiShortIntVar: visit_short_int_var(obj_h, indent, relation, shallowVisit); break;
    case vpiShortRealTypespec: visit_short_real_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiShortRealVar: visit_short_real_var(obj_h, indent, relation, shallowVisit); break;
    case vpiSimpleExpr: visit_simple_expr(obj_h, indent, relation, shallowVisit); break;
    case vpiSoftDisable: visit_soft_disable(obj_h, indent, relation, shallowVisit); break;
    case vpiSpecParam: visit_spec_param(obj_h, indent, relation, shallowVisit); break;
    case vpiStmt: visit_atomic_stmt(obj_h, indent, relation, shallowVisit); break;
    case vpiStringTypespec: visit_string_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiStringVar: visit_string_var(obj_h, indent, relation, shallowVisit); break;
    case vpiStructNet: visit_struct_net(obj_h, indent, relation, shallowVisit); break;
    case vpiStructPattern: visit_struct_pattern(obj_h, indent, relation, shallowVisit); break;
    case vpiStructTypespec: visit_struct_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiStructVar: visit_struct_var(obj_h, indent, relation, shallowVisit); break;
    case vpiSwitch: visit_switch_tran(obj_h, indent, relation, shallowVisit); break;
    case vpiSwitchArray: visit_switch_array(obj_h, indent, relation, shallowVisit); break;
    case vpiSysFuncCall: visit_sys_func_call(obj_h, indent, relation, shallowVisit); break;
    case vpiSysTaskCall: visit_sys_task_call(obj_h, indent, relation, shallowVisit); break;
    case vpiSysTfCall: visit_tf_call(obj_h, indent, relation, shallowVisit); break;
    case vpiTableEntry: visit_table_entry(obj_h, indent, relation, shallowVisit); break;
    case vpiTaggedPattern: visit_tagged_pattern(obj_h, indent, relation, shallowVisit); break;
    case vpiTask: visit_task(obj_h, indent, relation, shallowVisit); break;
    case vpiTaskCall: visit_task_call(obj_h, indent, relation, shallowVisit); break;
    case vpiTaskFunc: visit_task_func(obj_h, indent, relation, shallowVisit); break;
    case vpiTchk: visit_tchk(obj_h, indent, relation, shallowVisit); break;
    case vpiTchkTerm: visit_tchk_term(obj_h, indent, relation, shallowVisit); break;
    case vpiThread: visit_thread_obj(obj_h, indent, relation, shallowVisit); break;
    case vpiTimeNet: visit_time_net(obj_h, indent, relation, shallowVisit); break;
    case vpiTimeTypespec: visit_time_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiTimeVar: visit_time_var(obj_h, indent, relation, shallowVisit); break;
    case vpiTypeParameter: visit_type_parameter(obj_h, indent, relation, shallowVisit); break;
    case vpiTypespec: visit_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiTypespecMember: visit_typespec_member(obj_h, indent, relation, shallowVisit); break;
    case vpiUdp: visit_udp(obj_h, indent, relation, shallowVisit); break;
    case vpiUdpArray: visit_udp_array(obj_h, indent, relation, shallowVisit); break;
    case vpiUdpDefn: visit_udp_defn(obj_h, indent, relation, shallowVisit); break;
    case vpiUnionTypespec: visit_union_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiUnionVar: visit_union_var(obj_h, indent, relation, shallowVisit); break;
    case vpiUnsupportedExpr: visit_unsupported_expr(obj_h, indent, relation, shallowVisit); break;
    case vpiUnsupportedStmt: visit_unsupported_stmt(obj_h, indent, relation, shallowVisit); break;
    case vpiUnsupportedTypespec: visit_unsupported_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiUserSystf: visit_user_systf(obj_h, indent, relation, shallowVisit); break;
    case vpiVarBit: visit_var_bit(obj_h, indent, relation, shallowVisit); break;
    case vpiVarSelect: visit_var_select(obj_h, indent, relation, shallowVisit); break;
    case vpiVariables: visit_variables(obj_h, indent, relation, shallowVisit); break;
    case vpiVirtualInterfaceVar: visit_virtual_interface_var(obj_h, indent, relation, shallowVisit); break;
    case vpiVoidTypespec: visit_void_typespec(obj_h, indent, relation, shallowVisit); break;
    case vpiWait: visit_wait_stmt(obj_h, indent, relation, shallowVisit); break;
    case vpiWaitFork: visit_wait_fork(obj_h, indent, relation, shallowVisit); break;
    case vpiWaits: visit_waits(obj_h, indent, relation, shallowVisit); break;
    case vpiWhile: visit_while_stmt(obj_h, indent, relation, shallowVisit); break;
  }
}

void VpiVisitor::visit_weakly_referenced() {
  if (m_weaklyReferenced1.empty()) return;
  m_out << "\\_weaklyReferenced:" << std::endl;
  while (!m_weaklyReferenced1.empty()) {
    AnySet::const_iterator it = std::min_element(
        m_weaklyReferenced1.begin(), m_weaklyReferenced1.end(),
        [](const UHDM::any* const lhs, const UHDM::any* const rhs) {
          return lhs->UhdmId() < rhs->UhdmId();
        });
    const UHDM::BaseClass* const object = *it;
    m_weaklyReferenced2.emplace(object);
    vpiHandle h =
        object->GetSerializer()->MakeUhdmHandle(object->UhdmType(), object);
    visit_object(h, kLevelIndent, "", false);
    release_handle(h);
  }
}

void visit_object(vpiHandle obj_h, VpiVisitor *visitor) {
  visitor->visit_object(obj_h, 0, "", false);
  if (visitor->getVisitWeaklyReferenced()) {
    visitor->visit_weakly_referenced();
  }
}

void visit_object(vpiHandle obj_h, std::ostream& out, bool shallowVisit /* = false */) {
  VpiVisitor visitor(out);
  visit_object(obj_h, &visitor);
}

void visit_designs(const std::vector<vpiHandle>& designs, VpiVisitor* visitor) {
  for (auto design : designs) {
    visitor->visit_object(design, 0, "", false);
    if (visitor->getVisitWeaklyReferenced()) {
      visitor->visit_weakly_referenced();
    }
  }
}

void visit_designs(const std::vector<vpiHandle>& designs, std::ostream &out) {
  VpiVisitor visitor(out);
  visit_designs(designs, &visitor);
}

std::string decompile(const UHDM::any* handle) {
  if (handle == nullptr) {
    std::cout << "NULL HANDLE\n";
    return "NULL HANDLE";
  }
  UHDM::VisitedContainer visited;
  vpi_show_ids(true);
  vpiHandle dh =
      handle->GetSerializer()->MakeUhdmHandle(handle->UhdmType(), handle);
  std::stringstream out;
  VpiVisitor visitor(out);
  visitor.visit_object(dh, 0, "decompile", false);
  vpi_release_handle(dh);
  std::cout << out.str() << "\n";
  return out.str();
}

std::string decompileVPI(vpiHandle handle) {
  if (handle == nullptr) {
    std::cout << "NULL HANDLE\n";
    return "NULL HANDLE";
  }
  UHDM::VisitedContainer visited;
  vpi_show_ids(true);
  std::stringstream out;
  VpiVisitor visitor(out);
  visitor.visit_object(handle, 0, "decompile", false);
  std::cout << out.str() << "\n";
  return out.str();
}

} // namespace UHDM

void vpi_show_ids(bool show) {
  showIDs = show;
}

extern "C" {
  void vpi_decompiler (vpiHandle design) {
    std::vector<vpiHandle> designs;
    designs.push_back(design);
    UHDM::visit_designs(designs, std::cout);
    std::cout << std::endl;
  }
}
