/*
 Do not modify, auto-generated by classes.py

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   assignment.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_ASSIGNMENT_H
#define UHDM_ASSIGNMENT_H

#include <uhdm/sv_vpi_user.h>
#include <uhdm/uhdm_vpi_user.h>

#include <uhdm/containers.h>
#include <uhdm/atomic_stmt.h>

#include "expr_interf_expr_group.h"


namespace UHDM {
class delay_control;
class event_control;
class expr;
class repeat_control;

class assignment final : public atomic_stmt {
  UHDM_IMPLEMENT_RTTI(assignment, atomic_stmt)
public:
  // Implicit constructor used to initialize all members,
  // comment: assignment();
  virtual ~assignment() final = default;

  int32_t VpiOpType() const { return vpiOpType_; }
  bool VpiOpType(int32_t data) {
    vpiOpType_ = data;
    return true;
  }

  bool VpiBlocking() const { return vpiBlocking_; }
  bool VpiBlocking(bool data) {
    vpiBlocking_ = data;
    return true;
  }

  any* Rhs()  { return rhs_; }
  const any* Rhs() const { return rhs_; }
  template <typename T>
  T* Rhs() {
    return (rhs_ == nullptr) ? nullptr : any_cast<T*>(rhs_);
  }
  template <typename T>
  const T* Rhs() const {
    return (rhs_ == nullptr) ? nullptr : any_cast<const T*>(rhs_);
  }
  bool Rhs(any* data) {
    if (!expr_interf_expr_groupGroupCompliant(data)) return false;
    rhs_ = data;
    return true;
  }

  expr* Lhs()  { return lhs_; }
  const expr* Lhs() const { return lhs_; }
  template <typename T>
  T* Lhs() {
    return (lhs_ == nullptr) ? nullptr : any_cast<T*>(lhs_);
  }
  template <typename T>
  const T* Lhs() const {
    return (lhs_ == nullptr) ? nullptr : any_cast<const T*>(lhs_);
  }
  bool Lhs(expr* data) {
    lhs_ = data;
    return true;
  }

  delay_control* Delay_control()  { return delay_control_; }
  const delay_control* Delay_control() const { return delay_control_; }
  template <typename T>
  T* Delay_control() {
    return (delay_control_ == nullptr) ? nullptr : any_cast<T*>(delay_control_);
  }
  template <typename T>
  const T* Delay_control() const {
    return (delay_control_ == nullptr) ? nullptr : any_cast<const T*>(delay_control_);
  }
  bool Delay_control(delay_control* data) {
    delay_control_ = data;
    return true;
  }

  event_control* Event_control()  { return event_control_; }
  const event_control* Event_control() const { return event_control_; }
  template <typename T>
  T* Event_control() {
    return (event_control_ == nullptr) ? nullptr : any_cast<T*>(event_control_);
  }
  template <typename T>
  const T* Event_control() const {
    return (event_control_ == nullptr) ? nullptr : any_cast<const T*>(event_control_);
  }
  bool Event_control(event_control* data) {
    event_control_ = data;
    return true;
  }

  repeat_control* Repeat_control()  { return repeat_control_; }
  const repeat_control* Repeat_control() const { return repeat_control_; }
  template <typename T>
  T* Repeat_control() {
    return (repeat_control_ == nullptr) ? nullptr : any_cast<T*>(repeat_control_);
  }
  template <typename T>
  const T* Repeat_control() const {
    return (repeat_control_ == nullptr) ? nullptr : any_cast<const T*>(repeat_control_);
  }
  bool Repeat_control(repeat_control* data) {
    repeat_control_ = data;
    return true;
  }

  virtual uint32_t VpiType() const final { return vpiAssignment; }

  virtual assignment* DeepClone(BaseClass* parent, CloneContext* context) const override;

  virtual const BaseClass* GetByVpiName(std::string_view name) const override;

  virtual std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> GetByVpiType(int32_t type) const override;

  virtual vpi_property_value_t GetVpiPropertyValue(int32_t property) const override;

  virtual int32_t Compare(const BaseClass* other, CompareContext* context) const override;

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return UHDM_OBJECT_TYPE::uhdmassignment; }

protected:
  void DeepCopy(assignment* clone, BaseClass* parent, CloneContext* context) const;

private:
  int32_t vpiOpType_ = 0;

  bool vpiBlocking_ = false;

  any* rhs_ = nullptr;

  expr* lhs_ = nullptr;

  delay_control* delay_control_ = nullptr;

  event_control* event_control_ = nullptr;

  repeat_control* repeat_control_ = nullptr;
};


typedef FactoryT<assignment> assignmentFactory;


typedef FactoryT<std::vector<assignment *>> VectorOfassignmentFactory;

}  // namespace UHDM

#endif
