/*
 Do not modify, auto-generated by classes.py

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   operation.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_OPERATION_H
#define UHDM_OPERATION_H

#include <uhdm/sv_vpi_user.h>
#include <uhdm/uhdm_vpi_user.h>

#include <uhdm/containers.h>
#include <uhdm/expr.h>

#include "operand_group.h"


namespace UHDM {


class operation final : public expr {
  UHDM_IMPLEMENT_RTTI(operation, expr)
public:
  // Implicit constructor used to initialize all members,
  // comment: operation();
  virtual ~operation() final = default;

  int32_t VpiOpType() const { return vpiOpType_; }
  bool VpiOpType(int32_t data) {
    vpiOpType_ = data;
    return true;
  }

  bool VpiReordered() const { return vpiReordered_; }
  bool VpiReordered(bool data) {
    vpiReordered_ = data;
    return true;
  }

  bool VpiFlattened() const { return vpiFlattened_; }
  bool VpiFlattened(bool data) {
    vpiFlattened_ = data;
    return true;
  }

  bool VpiOpStrong() const { return vpiOpStrong_; }
  bool VpiOpStrong(bool data) {
    vpiOpStrong_ = data;
    return true;
  }

  VectorOfany* Operands() const { return operands_; }
  bool Operands(VectorOfany* data) {
    if (!operand_groupGroupCompliant(data)) return false;
    operands_ = data;
    return true;
  }

  VectorOfattribute* Attributes() const { return attributes_; }
  bool Attributes(VectorOfattribute* data) {
    attributes_ = data;
    return true;
  }

  virtual uint32_t VpiType() const final { return vpiOperation; }

  virtual operation* DeepClone(BaseClass* parent, CloneContext* context) const override;

  virtual const BaseClass* GetByVpiName(std::string_view name) const override;

  virtual std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> GetByVpiType(int32_t type) const override;

  virtual vpi_property_value_t GetVpiPropertyValue(int32_t property) const override;

  virtual int32_t Compare(const BaseClass* other, CompareContext* context) const override;

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return UHDM_OBJECT_TYPE::uhdmoperation; }

protected:
  void DeepCopy(operation* clone, BaseClass* parent, CloneContext* context) const;

private:
  int32_t vpiOpType_ = 0;

  bool vpiReordered_ = false;

  bool vpiFlattened_ = false;

  bool vpiOpStrong_ = false;

  VectorOfany* operands_ = nullptr;

  VectorOfattribute* attributes_ = nullptr;
};


typedef FactoryT<operation> operationFactory;


typedef FactoryT<std::vector<operation *>> VectorOfoperationFactory;

}  // namespace UHDM

#endif
