/*
 Do not modify, auto-generated by classes.py

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   foreach_stmt.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_FOREACH_STMT_H
#define UHDM_FOREACH_STMT_H

#include <uhdm/sv_vpi_user.h>
#include <uhdm/uhdm_vpi_user.h>

#include <uhdm/containers.h>
#include <uhdm/scope.h>

#include "stmt.h"
#include "variables_operation_group.h"


namespace UHDM {
class variables;

class foreach_stmt final : public scope {
  UHDM_IMPLEMENT_RTTI(foreach_stmt, scope)
public:
  // Implicit constructor used to initialize all members,
  // comment: foreach_stmt();
  virtual ~foreach_stmt() final = default;

  variables* Variable()  { return variable_; }
  const variables* Variable() const { return variable_; }
  template <typename T>
  T* Variable() {
    return (variable_ == nullptr) ? nullptr : any_cast<T*>(variable_);
  }
  template <typename T>
  const T* Variable() const {
    return (variable_ == nullptr) ? nullptr : any_cast<const T*>(variable_);
  }
  bool Variable(variables* data) {
    variable_ = data;
    return true;
  }

  VectorOfany* VpiLoopVars() const { return vpiLoopVars_; }
  bool VpiLoopVars(VectorOfany* data) {
    if (!variables_operation_groupGroupCompliant(data)) return false;
    vpiLoopVars_ = data;
    return true;
  }

  any* VpiStmt()  { return vpiStmt_; }
  const any* VpiStmt() const { return vpiStmt_; }
  template <typename T>
  T* VpiStmt() {
    return (vpiStmt_ == nullptr) ? nullptr : any_cast<T*>(vpiStmt_);
  }
  template <typename T>
  const T* VpiStmt() const {
    return (vpiStmt_ == nullptr) ? nullptr : any_cast<const T*>(vpiStmt_);
  }
  bool VpiStmt(any* data) {
    if (!stmtGroupCompliant(data)) return false;
    vpiStmt_ = data;
    return true;
  }

  virtual uint32_t VpiType() const final { return vpiForeachStmt; }

  virtual foreach_stmt* DeepClone(BaseClass* parent, CloneContext* context) const override;

  virtual const BaseClass* GetByVpiName(std::string_view name) const override;

  virtual std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> GetByVpiType(int32_t type) const override;

  virtual vpi_property_value_t GetVpiPropertyValue(int32_t property) const override;

  virtual int32_t Compare(const BaseClass* other, CompareContext* context) const override;

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return UHDM_OBJECT_TYPE::uhdmforeach_stmt; }

protected:
  void DeepCopy(foreach_stmt* clone, BaseClass* parent, CloneContext* context) const;

private:
  variables* variable_ = nullptr;

  VectorOfany* vpiLoopVars_ = nullptr;

  any* vpiStmt_ = nullptr;
};


typedef FactoryT<foreach_stmt> foreach_stmtFactory;


typedef FactoryT<std::vector<foreach_stmt *>> VectorOfforeach_stmtFactory;

}  // namespace UHDM

#endif
