/*
 Do not modify, auto-generated by classes.py

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   io_decl.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_IO_DECL_H
#define UHDM_IO_DECL_H

#include <uhdm/sv_vpi_user.h>
#include <uhdm/uhdm_vpi_user.h>

#include <uhdm/containers.h>
#include <uhdm/BaseClass.h>

#include "ref_obj_interf_net_var_group.h"


namespace UHDM {
class expr;
class ref_typespec;

class io_decl final : public BaseClass {
  UHDM_IMPLEMENT_RTTI(io_decl, BaseClass)
public:
  // Implicit constructor used to initialize all members,
  // comment: io_decl();
  virtual ~io_decl() final = default;

  uint32_t VpiType() const final { return vpiIODecl; }

  int32_t VpiDirection() const { return vpiDirection_; }
  bool VpiDirection(int32_t data) {
    vpiDirection_ = data;
    return true;
  }

  virtual bool VpiName(std::string_view data) final;
  virtual std::string_view VpiName() const final;

  bool VpiScalar() const { return vpiScalar_; }
  bool VpiScalar(bool data) {
    vpiScalar_ = data;
    return true;
  }

  bool VpiSigned() const { return vpiSigned_; }
  bool VpiSigned(bool data) {
    vpiSigned_ = data;
    return true;
  }

  int32_t VpiSize() const { return vpiSize_; }
  bool VpiSize(int32_t data) {
    vpiSize_ = data;
    return true;
  }

  bool VpiVector() const { return vpiVector_; }
  bool VpiVector(bool data) {
    vpiVector_ = data;
    return true;
  }

  any* Expr()  { return expr_; }
  const any* Expr() const { return expr_; }
  template <typename T>
  T* Expr() {
    return (expr_ == nullptr) ? nullptr : any_cast<T*>(expr_);
  }
  template <typename T>
  const T* Expr() const {
    return (expr_ == nullptr) ? nullptr : any_cast<const T*>(expr_);
  }
  bool Expr(any* data) {
    if (!ref_obj_interf_net_var_groupGroupCompliant(data)) return false;
    expr_ = data;
    return true;
  }

  expr* Left_expr()  { return left_expr_; }
  const expr* Left_expr() const { return left_expr_; }
  template <typename T>
  T* Left_expr() {
    return (left_expr_ == nullptr) ? nullptr : any_cast<T*>(left_expr_);
  }
  template <typename T>
  const T* Left_expr() const {
    return (left_expr_ == nullptr) ? nullptr : any_cast<const T*>(left_expr_);
  }
  bool Left_expr(expr* data) {
    left_expr_ = data;
    return true;
  }

  expr* Right_expr()  { return right_expr_; }
  const expr* Right_expr() const { return right_expr_; }
  template <typename T>
  T* Right_expr() {
    return (right_expr_ == nullptr) ? nullptr : any_cast<T*>(right_expr_);
  }
  template <typename T>
  const T* Right_expr() const {
    return (right_expr_ == nullptr) ? nullptr : any_cast<const T*>(right_expr_);
  }
  bool Right_expr(expr* data) {
    right_expr_ = data;
    return true;
  }

  VectorOfrange* Ranges() const { return ranges_; }
  bool Ranges(VectorOfrange* data) {
    ranges_ = data;
    return true;
  }

  ref_typespec* Typespec()  { return typespec_; }
  const ref_typespec* Typespec() const { return typespec_; }
  template <typename T>
  T* Typespec() {
    return (typespec_ == nullptr) ? nullptr : any_cast<T*>(typespec_);
  }
  template <typename T>
  const T* Typespec() const {
    return (typespec_ == nullptr) ? nullptr : any_cast<const T*>(typespec_);
  }
  bool Typespec(ref_typespec* data) {
    typespec_ = data;
    return true;
  }

  virtual io_decl* DeepClone(BaseClass* parent, CloneContext* context) const override;

  virtual const BaseClass* GetByVpiName(std::string_view name) const override;

  virtual std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> GetByVpiType(int32_t type) const override;

  virtual vpi_property_value_t GetVpiPropertyValue(int32_t property) const override;

  virtual int32_t Compare(const BaseClass* other, CompareContext* context) const override;

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return UHDM_OBJECT_TYPE::uhdmio_decl; }

protected:
  void DeepCopy(io_decl* clone, BaseClass* parent, CloneContext* context) const;

private:
  int32_t vpiDirection_ = 0;

  SymbolId vpiName_;

  bool vpiScalar_ = false;

  bool vpiSigned_ = false;

  int32_t vpiSize_ = 0;

  bool vpiVector_ = false;

  any* expr_ = nullptr;

  expr* left_expr_ = nullptr;

  expr* right_expr_ = nullptr;

  VectorOfrange* ranges_ = nullptr;

  ref_typespec* typespec_ = nullptr;
};


typedef FactoryT<io_decl> io_declFactory;


typedef FactoryT<std::vector<io_decl *>> VectorOfio_declFactory;

}  // namespace UHDM

#endif
