/*
 Do not modify, auto-generated by classes.py

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   tchk.h
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#ifndef UHDM_TCHK_H
#define UHDM_TCHK_H

#include <uhdm/sv_vpi_user.h>
#include <uhdm/uhdm_vpi_user.h>

#include <uhdm/containers.h>
#include <uhdm/BaseClass.h>

#include "expr_tchk_term_group.h"


namespace UHDM {
class expr;
class module_inst;
class reg;
class tchk_term;

class tchk final : public BaseClass {
  UHDM_IMPLEMENT_RTTI(tchk, BaseClass)
public:
  // Implicit constructor used to initialize all members,
  // comment: tchk();
  virtual ~tchk() final = default;

  module_inst* Module_inst()  { return module_inst_; }
  const module_inst* Module_inst() const { return module_inst_; }
  template <typename T>
  T* Module_inst() {
    return (module_inst_ == nullptr) ? nullptr : any_cast<T*>(module_inst_);
  }
  template <typename T>
  const T* Module_inst() const {
    return (module_inst_ == nullptr) ? nullptr : any_cast<const T*>(module_inst_);
  }
  bool Module_inst(module_inst* data) {
    module_inst_ = data;
    return true;
  }

  expr* Expr()  { return expr_; }
  const expr* Expr() const { return expr_; }
  template <typename T>
  T* Expr() {
    return (expr_ == nullptr) ? nullptr : any_cast<T*>(expr_);
  }
  template <typename T>
  const T* Expr() const {
    return (expr_ == nullptr) ? nullptr : any_cast<const T*>(expr_);
  }
  bool Expr(expr* data) {
    expr_ = data;
    return true;
  }

  VectorOfany* Expr_tchk_terms() const { return expr_tchk_terms_; }
  bool Expr_tchk_terms(VectorOfany* data) {
    if (!expr_tchk_term_groupGroupCompliant(data)) return false;
    expr_tchk_terms_ = data;
    return true;
  }

  tchk_term* Tchk_ref_term()  { return tchk_ref_term_; }
  const tchk_term* Tchk_ref_term() const { return tchk_ref_term_; }
  template <typename T>
  T* Tchk_ref_term() {
    return (tchk_ref_term_ == nullptr) ? nullptr : any_cast<T*>(tchk_ref_term_);
  }
  template <typename T>
  const T* Tchk_ref_term() const {
    return (tchk_ref_term_ == nullptr) ? nullptr : any_cast<const T*>(tchk_ref_term_);
  }
  bool Tchk_ref_term(tchk_term* data) {
    tchk_ref_term_ = data;
    return true;
  }

  tchk_term* Tchk_data_term()  { return tchk_data_term_; }
  const tchk_term* Tchk_data_term() const { return tchk_data_term_; }
  template <typename T>
  T* Tchk_data_term() {
    return (tchk_data_term_ == nullptr) ? nullptr : any_cast<T*>(tchk_data_term_);
  }
  template <typename T>
  const T* Tchk_data_term() const {
    return (tchk_data_term_ == nullptr) ? nullptr : any_cast<const T*>(tchk_data_term_);
  }
  bool Tchk_data_term(tchk_term* data) {
    tchk_data_term_ = data;
    return true;
  }

  reg* Reg()  { return reg_; }
  const reg* Reg() const { return reg_; }
  template <typename T>
  T* Reg() {
    return (reg_ == nullptr) ? nullptr : any_cast<T*>(reg_);
  }
  template <typename T>
  const T* Reg() const {
    return (reg_ == nullptr) ? nullptr : any_cast<const T*>(reg_);
  }
  bool Reg(reg* data) {
    reg_ = data;
    return true;
  }

  bool VpiDelay(std::string_view data);
  std::string_view VpiDelay() const;

  int32_t VpiTchkType() const { return vpiTchkType_; }
  bool VpiTchkType(int32_t data) {
    vpiTchkType_ = data;
    return true;
  }

  VectorOfattribute* Attributes() const { return attributes_; }
  bool Attributes(VectorOfattribute* data) {
    attributes_ = data;
    return true;
  }

  virtual uint32_t VpiType() const final { return vpiTchk; }

  virtual tchk* DeepClone(BaseClass* parent, CloneContext* context) const override;

  virtual const BaseClass* GetByVpiName(std::string_view name) const override;

  virtual std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> GetByVpiType(int32_t type) const override;

  virtual vpi_property_value_t GetVpiPropertyValue(int32_t property) const override;

  virtual int32_t Compare(const BaseClass* other, CompareContext* context) const override;

  virtual  UHDM_OBJECT_TYPE UhdmType() const final { return UHDM_OBJECT_TYPE::uhdmtchk; }

protected:
  void DeepCopy(tchk* clone, BaseClass* parent, CloneContext* context) const;

private:
  module_inst* module_inst_ = nullptr;

  expr* expr_ = nullptr;

  VectorOfany* expr_tchk_terms_ = nullptr;

  tchk_term* tchk_ref_term_ = nullptr;

  tchk_term* tchk_data_term_ = nullptr;

  reg* reg_ = nullptr;

  SymbolId vpiDelay_;

  int32_t vpiTchkType_ = 0;

  VectorOfattribute* attributes_ = nullptr;
};


typedef FactoryT<tchk> tchkFactory;


typedef FactoryT<std::vector<tchk *>> VectorOftchkFactory;

}  // namespace UHDM

#endif
