\name{StochasticFractalDimensionImageFilter}
\alias{StochasticFractalDimensionImageFilter}
\title{StochasticFractalDimensionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
This filter computes the stochastic fractal dimension of the input
image.
StochasticFractalDimensionImageFilter}
\details{
The methodology is based on Mandelbrot's fractal theory and the
concept of fractional Brownian motion and yields images which have
been used for classification and edge enhancement.
This class which is templated over the input and output images as well
as a mask image type. The input is a scalar image, an optional
neighborhood radius (default = 2), and an optional mask. The mask can
be specified to decrease computation time since, as the authors point
out, calculation is time-consuming.
This filter was contributed by Nick Tustison and James Gee from the
PICSL lab, at the University of Pennsylvania as an paper to the
Insight Journal:
"Stochastic Fractal Dimension Image" https://hdl.handle.net/1926/1525 https://www.insight-journal.org/browse/publication/318
Nick Tustison
See:
StochasticFractalDimension for the procedural interface
itk::StochasticFractalDimensionImageFilter for the Doxygen on the original ITK class.
StochasticFractalDimensionImageFilter}
%C++ includes: sitkStochasticFractalDimensionImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image):}{}
\item{Image Execute(const Image &image, const Image &maskImage):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< unsigned int > GetNeighborhoodRadius() const:}{
Manhattan radius used for evaluating the fractal dimension.
}
\item{Self SetNeighborhoodRadius(std::vector< unsigned int > NeighborhoodRadius):}{
Manhattan radius used for evaluating the fractal dimension.
}
\item{Self SetNeighborhoodRadius(unsigned int value):}{
Set the values of the NeighborhoodRadius vector all to value
}
\item{ StochasticFractalDimensionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~StochasticFractalDimensionImageFilter():}{
Destructor
}
}
}
